/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_0_0;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class LayoutClassedModelUsageUpgradeProcess
extends UpgradeProcess {
    private final AssetEntryLocalService _assetEntryLocalService;

    public LayoutClassedModelUsageUpgradeProcess(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeSchema();
        if (this.hasTable("AssetEntryUsage")) {
            this._upgradeLayoutClassedModelUsage();
        }
    }

    private void _upgradeLayoutClassedModelUsage() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select groupId, assetEntryId, containerKey, containerType, plid, type_ from AssetEntryUsage");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into LayoutClassedModelUsage (mvccVersion, ", "uuid_, layoutClassedModelUsageId, groupId, ", "createDate, modifiedDate, classNameId, classPK, ", "containerKey, containerType, plid, type_ ) values ", "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"}));){
            while (resultSet.next()) {
                long assetEntryId = resultSet.getLong("assetEntryId");
                long plid = resultSet.getLong("plid");
                AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(assetEntryId);
                if (assetEntry == null || plid <= 0L) continue;
                long groupId = resultSet.getLong("groupId");
                String containerKey = resultSet.getString("containerKey");
                long containerType = resultSet.getLong("containerType");
                int type = resultSet.getInt("type_");
                preparedStatement.setLong(1, 0L);
                preparedStatement.setString(2, PortalUUIDUtil.generate());
                preparedStatement.setLong(3, this.increment());
                preparedStatement.setLong(4, groupId);
                preparedStatement.setDate(5, new Date(System.currentTimeMillis()));
                preparedStatement.setDate(6, new Date(System.currentTimeMillis()));
                preparedStatement.setLong(7, assetEntry.getClassNameId());
                preparedStatement.setLong(8, assetEntry.getClassPK());
                preparedStatement.setString(9, containerKey);
                preparedStatement.setLong(10, containerType);
                preparedStatement.setLong(11, plid);
                preparedStatement.setInt(12, type);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }

    private void _upgradeSchema() throws Exception {
        String template = StringUtil.read((InputStream)LayoutClassedModelUsageUpgradeProcess.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false);
    }
}

