/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.service.impl;

import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.service.base.LayoutClassedModelUsageLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.model.LayoutClassedModelUsage"}, service={AopService.class})
public class LayoutClassedModelUsageLocalServiceImpl
extends LayoutClassedModelUsageLocalServiceBaseImpl {
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public LayoutClassedModelUsage addDefaultLayoutClassedModelUsage(long groupId, long classNameId, long classPK, ServiceContext serviceContext) {
        return this.addLayoutClassedModelUsage(groupId, classNameId, classPK, "", 0L, 0L, serviceContext);
    }

    public LayoutClassedModelUsage addLayoutClassedModelUsage(long groupId, long classNameId, long classPK, String containerKey, long containerType, long plid, ServiceContext serviceContext) {
        long layoutClassedModelUsageId = this.counterLocalService.increment();
        LayoutClassedModelUsage layoutClassedModelUsage = this.layoutClassedModelUsagePersistence.create(layoutClassedModelUsageId);
        layoutClassedModelUsage.setUuid(serviceContext.getUuid());
        layoutClassedModelUsage.setGroupId(groupId);
        long companyId = serviceContext.getCompanyId();
        Group group = this.groupLocalService.fetchGroup(groupId);
        if (group != null) {
            companyId = group.getCompanyId();
        }
        layoutClassedModelUsage.setCompanyId(companyId);
        layoutClassedModelUsage.setCreateDate(new Date());
        layoutClassedModelUsage.setModifiedDate(new Date());
        layoutClassedModelUsage.setClassNameId(classNameId);
        layoutClassedModelUsage.setClassPK(classPK);
        layoutClassedModelUsage.setContainerKey(containerKey);
        layoutClassedModelUsage.setContainerType(containerType);
        layoutClassedModelUsage.setPlid(plid);
        layoutClassedModelUsage.setType(this._getType(plid));
        return (LayoutClassedModelUsage)this.layoutClassedModelUsagePersistence.update((BaseModel)layoutClassedModelUsage);
    }

    public void deleteLayoutClassedModelUsages(long classNameId, long classPK) {
        this.layoutClassedModelUsagePersistence.removeByC_C(classNameId, classPK);
    }

    public void deleteLayoutClassedModelUsages(String containerKey, long containerType, long plid) {
        this.layoutClassedModelUsagePersistence.removeByCK_CT_P(containerKey, containerType, plid);
    }

    public void deleteLayoutClassedModelUsagesByPlid(long plid) {
        this.layoutClassedModelUsagePersistence.removeByPlid(plid);
    }

    public LayoutClassedModelUsage fetchLayoutClassedModelUsage(long classNameId, long classPK, String containerKey, long containerType, long plid) {
        return this.layoutClassedModelUsagePersistence.fetchByC_C_CK_CT_P(classNameId, classPK, containerKey, containerType, plid);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsages(long classNameId, long classPK) {
        return this.layoutClassedModelUsagePersistence.findByC_C(classNameId, classPK);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsages(long classNameId, long classPK, int type, int start, int end, OrderByComparator<LayoutClassedModelUsage> orderByComparator) {
        return this.layoutClassedModelUsagePersistence.findByC_C_T(classNameId, classPK, type, start, end, orderByComparator);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsages(long classNameId, long classPK, int start, int end, OrderByComparator<LayoutClassedModelUsage> orderByComparator) {
        return this.layoutClassedModelUsagePersistence.findByC_C(classNameId, classPK, start, end, orderByComparator);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsagesByPlid(long plid) {
        return this.layoutClassedModelUsagePersistence.findByPlid(plid);
    }

    public int getLayoutClassedModelUsagesCount(long classNameId, long classPK) {
        return this.layoutClassedModelUsagePersistence.countByC_C(classNameId, classPK);
    }

    public int getLayoutClassedModelUsagesCount(long classNameId, long classPK, int type) {
        return this.layoutClassedModelUsagePersistence.countByC_C_T(classNameId, classPK, type);
    }

    public int getUniqueLayoutClassedModelUsagesCount(long classNameId, long classPK) {
        return this.layoutClassedModelUsageFinder.countByC_C(classNameId, classPK);
    }

    public boolean hasDefaultLayoutClassedModelUsage(long classNameId, long classPK) {
        LayoutClassedModelUsage layoutClassedModelUsage = this.layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(classNameId, classPK, "", 0L, 0L);
        return layoutClassedModelUsage != null;
    }

    private int _getType(long plid) {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        if (plid <= 0L) {
            return 0;
        }
        Layout layout = this.layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return 0;
        }
        if (layout.getClassNameId() > 0L && layout.getClassPK() > 0L) {
            plid = layout.getClassPK();
        }
        if ((layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(plid)) == null) {
            return 2;
        }
        if (layoutPageTemplateEntry.getType() == 1) {
            return 1;
        }
        return 3;
    }
}

