/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.layout.internal.service.DefaultLayoutLayoutSetPrototypeLocalServiceWrapper;
import com.liferay.layout.page.template.importer.LayoutPageTemplatesImporter;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DefaultLayoutDefinitionImporter.class})
public class DefaultLayoutDefinitionImporter {
    private static final String _DEFAULT_LAYOUT_DEFINITION = StringUtil.read(DefaultLayoutLayoutSetPrototypeLocalServiceWrapper.class, (String)"default-layout-definition.json");
    private static final String _FILE_NAME_WELCOME_IMAGE = "welcome_bg.jpg";
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase((String)PropsValues.HTTP_HEADER_VERSION_VERBOSITY, (String)"off");
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase((String)PropsValues.HTTP_HEADER_VERSION_VERBOSITY, (String)"partial");
    @Reference
    private File _file;
    @Reference
    private LayoutPageTemplatesImporter _layoutPageTemplatesImporter;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public void importDefaultLayoutDefinition(Layout layout, ServiceContext serviceContext) throws PortalException {
        try {
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid(), true);
            LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(0L));
            String releaseInfo = "";
            if (_HTTP_HEADER_VERSION_VERBOSITY_PARTIAL) {
                releaseInfo = ReleaseInfo.getName();
            } else if (!_HTTP_HEADER_VERSION_VERBOSITY_DEFAULT) {
                releaseInfo = ReleaseInfo.getReleaseInfo();
            }
            String layoutDefinitionJSON = StringUtil.replace((String)_DEFAULT_LAYOUT_DEFINITION, (String)"${", (String)"}", (Map)HashMapBuilder.put((Object)"RELEASE_INFO", (Object)StringBundler.concat((String[])new String[]{"Welcome to ", StringUtil.replace((String)releaseInfo, (char)'(', (String)"<br>("), "."})).put((Object)"WELCOME_IMAGE_URL", (Object)this._getWelcomeImageURL(layout.getGroupId(), layout.getUserId(), layout.getPlid(), serviceContext)).build());
            this._layoutPageTemplatesImporter.importPageElement(layout, layoutStructure, layoutStructure.getMainItemId(), layoutDefinitionJSON, 0);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private String _getWelcomeImageURL(long groupId, long userId, long plid, ServiceContext serviceContext) throws Exception {
        FileEntry fileEntry;
        Repository repository = this._portletFileRepository.fetchPortletRepository(groupId, Layout.class.getName());
        if (repository == null) {
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = this._portletFileRepository.addPortletRepository(groupId, Layout.class.getName(), serviceContext);
        }
        if ((fileEntry = this._portletFileRepository.fetchPortletFileEntry(groupId, repository.getDlFolderId(), _FILE_NAME_WELCOME_IMAGE)) == null) {
            byte[] bytes = this._file.getBytes(DefaultLayoutLayoutSetPrototypeLocalServiceWrapper.class, _FILE_NAME_WELCOME_IMAGE);
            fileEntry = this._portletFileRepository.addPortletFileEntry(groupId, userId, Layout.class.getName(), plid, Layout.class.getName(), repository.getDlFolderId(), bytes, _FILE_NAME_WELCOME_IMAGE, MimeTypesUtil.getContentType((String)_FILE_NAME_WELCOME_IMAGE), false);
        }
        return DLUtil.getDownloadURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"");
    }
}

