/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.layout.seo.exception.NoSuchEntryException;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.base.LayoutSEOEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.seo.model.LayoutSEOEntry"}, service={AopService.class})
public class LayoutSEOEntryLocalServiceImpl
extends LayoutSEOEntryLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDM _ddm;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private StorageEngine _storageEngine;

    public LayoutSEOEntry copyLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean canonicalURLEnabled, Map<Locale, String> canonicalURLMap, long copyDDMStorageId, boolean openGraphDescriptionEnabled, Map<Locale, String> openGraphDescriptionMap, Map<Locale, String> openGraphImageAltMap, long openGraphImageFileEntryId, boolean openGraphTitleEnabled, Map<Locale, String> openGraphTitleMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, canonicalURLEnabled, canonicalURLMap, copyDDMStorageId, openGraphDescriptionEnabled, openGraphDescriptionMap, openGraphImageAltMap, openGraphImageFileEntryId, openGraphTitleEnabled, openGraphTitleMap, serviceContext);
        }
        return this.updateLayoutSEOEntry(userId, groupId, privateLayout, layoutId, canonicalURLEnabled, canonicalURLMap, openGraphDescriptionEnabled, openGraphDescriptionMap, openGraphImageAltMap, openGraphImageFileEntryId, openGraphTitleEnabled, openGraphTitleMap, serviceContext);
    }

    public void deleteLayoutSEOEntry(long groupId, boolean privateLayout, long layoutId) throws NoSuchEntryException {
        this.layoutSEOEntryPersistence.removeByG_P_L(groupId, privateLayout, layoutId);
    }

    public void deleteLayoutSEOEntry(String uuid, long groupId) throws NoSuchEntryException {
        this.layoutSEOEntryPersistence.removeByUUID_G(uuid, groupId);
    }

    public LayoutSEOEntry fetchLayoutSEOEntry(long groupId, boolean privateLayout, long layoutId) {
        return this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
    }

    public LayoutSEOEntry updateCustomMetaTags(long userId, long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, false, Collections.emptyMap(), 0L, false, Collections.emptyMap(), Collections.emptyMap(), 0L, false, Collections.emptyMap(), serviceContext);
        }
        layoutSEOEntry.setModifiedDate(DateUtil.newDate());
        DDMStructure ddmStructure = this._getDDMStructure(this.groupLocalService.getGroup(groupId));
        long ddmStorageId = this._updateDDMStorage(layoutSEOEntry.getCompanyId(), layoutSEOEntry.getDDMStorageId(), 0L, ddmStructure.getStructureId(), serviceContext);
        layoutSEOEntry.setDDMStorageId(ddmStorageId);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    public LayoutSEOEntry updateLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean canonicalURLEnabled, Map<Locale, String> canonicalURLMap, boolean openGraphDescriptionEnabled, Map<Locale, String> openGraphDescriptionMap, Map<Locale, String> openGraphImageAltMap, long openGraphImageFileEntryId, boolean openGraphTitleEnabled, Map<Locale, String> openGraphTitleMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, canonicalURLEnabled, canonicalURLMap, 0L, openGraphDescriptionEnabled, openGraphDescriptionMap, openGraphImageAltMap, openGraphImageFileEntryId, openGraphTitleEnabled, openGraphTitleMap, serviceContext);
        }
        layoutSEOEntry.setModifiedDate(DateUtil.newDate());
        layoutSEOEntry.setCanonicalURLMap(canonicalURLMap);
        layoutSEOEntry.setCanonicalURLEnabled(canonicalURLEnabled);
        layoutSEOEntry.setOpenGraphDescriptionMap(openGraphDescriptionMap);
        layoutSEOEntry.setOpenGraphDescriptionEnabled(openGraphDescriptionEnabled);
        if (openGraphImageFileEntryId != 0L) {
            layoutSEOEntry.setOpenGraphImageAltMap(openGraphImageAltMap);
        } else {
            layoutSEOEntry.setOpenGraphImageAltMap(Collections.emptyMap());
        }
        layoutSEOEntry.setOpenGraphImageFileEntryId(openGraphImageFileEntryId);
        layoutSEOEntry.setOpenGraphTitleMap(openGraphTitleMap);
        layoutSEOEntry.setOpenGraphTitleEnabled(openGraphTitleEnabled);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    public LayoutSEOEntry updateLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean canonicalURLEnabled, Map<Locale, String> canonicalURLMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, canonicalURLEnabled, canonicalURLMap, 0L, false, Collections.emptyMap(), Collections.emptyMap(), 0L, false, Collections.emptyMap(), serviceContext);
        }
        layoutSEOEntry.setModifiedDate(DateUtil.newDate());
        layoutSEOEntry.setCanonicalURLMap(canonicalURLMap);
        layoutSEOEntry.setCanonicalURLEnabled(canonicalURLEnabled);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    private LayoutSEOEntry _addLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean canonicalURLEnabled, Map<Locale, String> canonicalURLMap, long copyDDMStorageId, boolean openGraphDescriptionEnabled, Map<Locale, String> openGraphDescriptionMap, Map<Locale, String> openGraphImageAltMap, long openGraphImageFileEntryId, boolean openGraphTitleEnabled, Map<Locale, String> openGraphTitleMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.create(this.counterLocalService.increment());
        layoutSEOEntry.setUuid(serviceContext.getUuid());
        layoutSEOEntry.setGroupId(groupId);
        Group group = this.groupLocalService.getGroup(groupId);
        layoutSEOEntry.setCompanyId(group.getCompanyId());
        layoutSEOEntry.setUserId(userId);
        Date now = DateUtil.newDate();
        layoutSEOEntry.setCreateDate(now);
        layoutSEOEntry.setModifiedDate(now);
        layoutSEOEntry.setPrivateLayout(privateLayout);
        layoutSEOEntry.setLayoutId(layoutId);
        layoutSEOEntry.setCanonicalURLMap(canonicalURLMap);
        layoutSEOEntry.setCanonicalURLEnabled(canonicalURLEnabled);
        DDMStructure ddmStructure = this._getDDMStructure(this.groupLocalService.getGroup(groupId));
        long ddmStorageId = this._updateDDMStorage(layoutSEOEntry.getCompanyId(), layoutSEOEntry.getDDMStorageId(), copyDDMStorageId, ddmStructure.getStructureId(), serviceContext);
        layoutSEOEntry.setDDMStorageId(ddmStorageId);
        layoutSEOEntry.setOpenGraphDescriptionMap(openGraphDescriptionMap);
        layoutSEOEntry.setOpenGraphDescriptionEnabled(openGraphDescriptionEnabled);
        if (openGraphImageFileEntryId != 0L) {
            layoutSEOEntry.setOpenGraphImageAltMap(openGraphImageAltMap);
        }
        layoutSEOEntry.setOpenGraphImageFileEntryId(openGraphImageFileEntryId);
        layoutSEOEntry.setOpenGraphTitleMap(openGraphTitleMap);
        layoutSEOEntry.setOpenGraphTitleEnabled(openGraphTitleEnabled);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    private DDMFormValues _getDDMFormValues(long copyDDMStorageId, long structureId, ServiceContext serviceContext) throws PortalException {
        DDMFormValues ddmFormValues = null;
        ddmFormValues = copyDDMStorageId != 0L ? this._storageEngine.getDDMFormValues(copyDDMStorageId) : this._ddm.getDDMFormValues(structureId, String.valueOf(structureId), serviceContext);
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        LinkedHashSet<DDMFormFieldValue> ddmFormFieldValues = new LinkedHashSet<DDMFormFieldValue>();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            Value value = ddmFormFieldValue.getValue();
            if (value == null) continue;
            block1: for (Locale locale : ddmFormValues.getAvailableLocales()) {
                if (!Validator.isBlank((String)value.getString(locale))) {
                    availableLocales.add(locale);
                    ddmFormFieldValues.add(ddmFormFieldValue);
                    continue;
                }
                for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                    Value nestedDDMFormFieldValueValue = nestedDDMFormFieldValue.getValue();
                    if (Validator.isBlank((String)nestedDDMFormFieldValueValue.getString(locale))) continue;
                    availableLocales.add(locale);
                    ddmFormFieldValues.add(ddmFormFieldValue);
                    continue block1;
                }
            }
        }
        ddmFormValues.setAvailableLocales(availableLocales);
        ddmFormValues.setDDMFormFieldValues(new ArrayList(ddmFormFieldValues));
        return ddmFormValues;
    }

    private DDMStructure _getDDMStructure(Group group) throws PortalException {
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        return this._ddmStructureLocalService.getStructure(companyGroup.getGroupId(), this._classNameLocalService.getClassNameId(LayoutSEOEntry.class.getName()), "custom-meta-tags");
    }

    private long _updateDDMStorage(long companyId, long ddmStorageId, long copyDDMStorageId, long structureId, ServiceContext serviceContext) throws PortalException {
        DDMFormValues ddmFormValues = this._getDDMFormValues(copyDDMStorageId, structureId, serviceContext);
        if (ListUtil.isEmpty((List)ddmFormValues.getDDMFormFieldValues())) {
            if (ddmStorageId != 0L) {
                this._storageEngine.deleteByClass(ddmStorageId);
            }
            return 0L;
        }
        if (ddmStorageId == 0L) {
            return this._storageEngine.create(companyId, structureId, ddmFormValues, serviceContext);
        }
        this._storageEngine.update(ddmStorageId, ddmFormValues, serviceContext);
        return ddmStorageId;
    }
}

