/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.service.persistence.impl;

import com.liferay.layout.seo.exception.NoSuchSiteException;
import com.liferay.layout.seo.model.LayoutSEOSite;
import com.liferay.layout.seo.model.LayoutSEOSiteTable;
import com.liferay.layout.seo.model.impl.LayoutSEOSiteImpl;
import com.liferay.layout.seo.model.impl.LayoutSEOSiteModelImpl;
import com.liferay.layout.seo.service.persistence.LayoutSEOSitePersistence;
import com.liferay.layout.seo.service.persistence.LayoutSEOSiteUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutSEOSitePersistence.class})
public class LayoutSEOSitePersistenceImpl
extends BasePersistenceImpl<LayoutSEOSite>
implements LayoutSEOSitePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = LayoutSEOSiteImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "layoutSEOSite.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(layoutSEOSite.uuid IS NULL OR layoutSEOSite.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "layoutSEOSite.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(layoutSEOSite.uuid IS NULL OR layoutSEOSite.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "layoutSEOSite.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "layoutSEOSite.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(layoutSEOSite.uuid IS NULL OR layoutSEOSite.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "layoutSEOSite.companyId = ?";
    private FinderPath _finderPathFetchByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "layoutSEOSite.groupId = ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private BundleContext _bundleContext;
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_LAYOUTSEOSITE = "SELECT layoutSEOSite FROM LayoutSEOSite layoutSEOSite";
    private static final String _SQL_SELECT_LAYOUTSEOSITE_WHERE = "SELECT layoutSEOSite FROM LayoutSEOSite layoutSEOSite WHERE ";
    private static final String _SQL_COUNT_LAYOUTSEOSITE = "SELECT COUNT(layoutSEOSite) FROM LayoutSEOSite layoutSEOSite";
    private static final String _SQL_COUNT_LAYOUTSEOSITE_WHERE = "SELECT COUNT(layoutSEOSite) FROM LayoutSEOSite layoutSEOSite WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "layoutSEOSite.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No LayoutSEOSite exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No LayoutSEOSite exists with the key {";
    private static final Log _log;
    private static final Set<String> _badColumnNames;
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<LayoutSEOSite> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<LayoutSEOSite> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<LayoutSEOSite> findByUuid(String uuid, int start, int end, OrderByComparator<LayoutSEOSite> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<LayoutSEOSite> findByUuid(String uuid, int start, int end, OrderByComparator<LayoutSEOSite> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByUuid;
                    finderArgs = new Object[]{uuid};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByUuid;
                finderArgs = new Object[]{uuid, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
                for (LayoutSEOSite layoutSEOSite : list) {
                    if (uuid.equals(layoutSEOSite.getUuid())) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
                sb.append(_SQL_SELECT_LAYOUTSEOSITE_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append(_FINDER_COLUMN_UUID_UUID_3);
                } else {
                    bindUuid = true;
                    sb.append(_FINDER_COLUMN_UUID_UUID_2);
                }
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY layoutSEOSite.layoutSEOSiteId ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public LayoutSEOSite findByUuid_First(String uuid, OrderByComparator<LayoutSEOSite> orderByComparator) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.fetchByUuid_First(uuid, orderByComparator);
        if (layoutSEOSite != null) {
            return layoutSEOSite;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchSiteException(sb.toString());
    }

    public LayoutSEOSite fetchByUuid_First(String uuid, OrderByComparator<LayoutSEOSite> orderByComparator) {
        List<LayoutSEOSite> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSEOSite findByUuid_Last(String uuid, OrderByComparator<LayoutSEOSite> orderByComparator) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.fetchByUuid_Last(uuid, orderByComparator);
        if (layoutSEOSite != null) {
            return layoutSEOSite;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchSiteException(sb.toString());
    }

    public LayoutSEOSite fetchByUuid_Last(String uuid, OrderByComparator<LayoutSEOSite> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<LayoutSEOSite> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSEOSite[] findByUuid_PrevAndNext(long layoutSEOSiteId, String uuid, OrderByComparator<LayoutSEOSite> orderByComparator) throws NoSuchSiteException {
        uuid = Objects.toString(uuid, "");
        LayoutSEOSite layoutSEOSite = this.findByPrimaryKey(layoutSEOSiteId);
        Session session = null;
        try {
            session = this.openSession();
            LayoutSEOSite[] array = new LayoutSEOSiteImpl[]{this.getByUuid_PrevAndNext(session, layoutSEOSite, uuid, orderByComparator, true), layoutSEOSite, this.getByUuid_PrevAndNext(session, layoutSEOSite, uuid, orderByComparator, false)};
            LayoutSEOSite[] layoutSEOSiteArray = array;
            return layoutSEOSiteArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSEOSite getByUuid_PrevAndNext(Session session, LayoutSEOSite layoutSEOSite, String uuid, OrderByComparator<LayoutSEOSite> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_LAYOUTSEOSITE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY layoutSEOSite.layoutSEOSiteId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)layoutSEOSite)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LayoutSEOSite)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (LayoutSEOSite layoutSEOSite : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)layoutSEOSite);
        }
    }

    public int countByUuid(String uuid) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = this._finderPathCountByUuid;
            Object[] finderArgs = new Object[]{uuid};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
            if (count == null) {
                StringBundler sb = new StringBundler(2);
                sb.append(_SQL_COUNT_LAYOUTSEOSITE_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append(_FINDER_COLUMN_UUID_UUID_3);
                } else {
                    bindUuid = true;
                    sb.append(_FINDER_COLUMN_UUID_UUID_2);
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public LayoutSEOSite findByUUID_G(String uuid, long groupId) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.fetchByUUID_G(uuid, groupId);
        if (layoutSEOSite == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchSiteException(sb.toString());
        }
        return layoutSEOSite;
    }

    public LayoutSEOSite fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public LayoutSEOSite fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            LayoutSEOSite layoutSEOSite;
            LayoutSEOSite layoutSEOSite2;
            uuid = Objects.toString(uuid, "");
            Object[] finderArgs = null;
            if (useFinderCache) {
                finderArgs = new Object[]{uuid, groupId};
            }
            Object result = null;
            if (useFinderCache) {
                result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistenceImpl)this);
            }
            if (result instanceof LayoutSEOSite && (!Objects.equals(uuid, (layoutSEOSite2 = (LayoutSEOSite)result).getUuid()) || groupId != layoutSEOSite2.getGroupId())) {
                result = null;
            }
            if (result == null) {
                StringBundler sb = new StringBundler(4);
                sb.append(_SQL_SELECT_LAYOUTSEOSITE_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append("(layoutSEOSite.uuid IS NULL OR layoutSEOSite.uuid = '') AND ");
                } else {
                    bindUuid = true;
                    sb.append("layoutSEOSite.uuid = ? AND ");
                }
                sb.append("layoutSEOSite.groupId = ?");
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    queryPos.add(groupId);
                    List list = query.list();
                    if (list.isEmpty()) {
                        if (useFinderCache) {
                            this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                        }
                    } else {
                        LayoutSEOSite layoutSEOSite3 = (LayoutSEOSite)list.get(0);
                        result = layoutSEOSite3;
                        this.cacheResult(layoutSEOSite3);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            if (result instanceof List) {
                layoutSEOSite = null;
                return layoutSEOSite;
            }
            layoutSEOSite = (LayoutSEOSite)result;
            return layoutSEOSite;
        }
    }

    public LayoutSEOSite removeByUUID_G(String uuid, long groupId) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.findByUUID_G(uuid, groupId);
        return (LayoutSEOSite)this.remove((BaseModel)layoutSEOSite);
    }

    public int countByUUID_G(String uuid, long groupId) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = this._finderPathCountByUUID_G;
            Object[] finderArgs = new Object[]{uuid, groupId};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
            if (count == null) {
                StringBundler sb = new StringBundler(3);
                sb.append(_SQL_COUNT_LAYOUTSEOSITE_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append("(layoutSEOSite.uuid IS NULL OR layoutSEOSite.uuid = '') AND ");
                } else {
                    bindUuid = true;
                    sb.append("layoutSEOSite.uuid = ? AND ");
                }
                sb.append("layoutSEOSite.groupId = ?");
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    queryPos.add(groupId);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public List<LayoutSEOSite> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<LayoutSEOSite> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<LayoutSEOSite> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<LayoutSEOSite> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<LayoutSEOSite> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<LayoutSEOSite> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                    finderArgs = new Object[]{uuid, companyId};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
                for (LayoutSEOSite layoutSEOSite : list) {
                    if (uuid.equals(layoutSEOSite.getUuid()) && companyId == layoutSEOSite.getCompanyId()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
                sb.append(_SQL_SELECT_LAYOUTSEOSITE_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append("(layoutSEOSite.uuid IS NULL OR layoutSEOSite.uuid = '') AND ");
                } else {
                    bindUuid = true;
                    sb.append("layoutSEOSite.uuid = ? AND ");
                }
                sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY layoutSEOSite.layoutSEOSiteId ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    queryPos.add(companyId);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public LayoutSEOSite findByUuid_C_First(String uuid, long companyId, OrderByComparator<LayoutSEOSite> orderByComparator) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (layoutSEOSite != null) {
            return layoutSEOSite;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchSiteException(sb.toString());
    }

    public LayoutSEOSite fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<LayoutSEOSite> orderByComparator) {
        List<LayoutSEOSite> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSEOSite findByUuid_C_Last(String uuid, long companyId, OrderByComparator<LayoutSEOSite> orderByComparator) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (layoutSEOSite != null) {
            return layoutSEOSite;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchSiteException(sb.toString());
    }

    public LayoutSEOSite fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<LayoutSEOSite> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<LayoutSEOSite> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public LayoutSEOSite[] findByUuid_C_PrevAndNext(long layoutSEOSiteId, String uuid, long companyId, OrderByComparator<LayoutSEOSite> orderByComparator) throws NoSuchSiteException {
        uuid = Objects.toString(uuid, "");
        LayoutSEOSite layoutSEOSite = this.findByPrimaryKey(layoutSEOSiteId);
        Session session = null;
        try {
            session = this.openSession();
            LayoutSEOSite[] array = new LayoutSEOSiteImpl[]{this.getByUuid_C_PrevAndNext(session, layoutSEOSite, uuid, companyId, orderByComparator, true), layoutSEOSite, this.getByUuid_C_PrevAndNext(session, layoutSEOSite, uuid, companyId, orderByComparator, false)};
            LayoutSEOSite[] layoutSEOSiteArray = array;
            return layoutSEOSiteArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSEOSite getByUuid_C_PrevAndNext(Session session, LayoutSEOSite layoutSEOSite, String uuid, long companyId, OrderByComparator<LayoutSEOSite> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_LAYOUTSEOSITE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(layoutSEOSite.uuid IS NULL OR layoutSEOSite.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("layoutSEOSite.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY layoutSEOSite.layoutSEOSiteId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)layoutSEOSite)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (LayoutSEOSite)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (LayoutSEOSite layoutSEOSite : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)layoutSEOSite);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = this._finderPathCountByUuid_C;
            Object[] finderArgs = new Object[]{uuid, companyId};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
            if (count == null) {
                StringBundler sb = new StringBundler(3);
                sb.append(_SQL_COUNT_LAYOUTSEOSITE_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append("(layoutSEOSite.uuid IS NULL OR layoutSEOSite.uuid = '') AND ");
                } else {
                    bindUuid = true;
                    sb.append("layoutSEOSite.uuid = ? AND ");
                }
                sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    queryPos.add(companyId);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public LayoutSEOSite findByGroupId(long groupId) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.fetchByGroupId(groupId);
        if (layoutSEOSite == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchSiteException(sb.toString());
        }
        return layoutSEOSite;
    }

    public LayoutSEOSite fetchByGroupId(long groupId) {
        return this.fetchByGroupId(groupId, true);
    }

    public LayoutSEOSite fetchByGroupId(long groupId, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            LayoutSEOSite layoutSEOSite;
            LayoutSEOSite layoutSEOSite2;
            Object[] finderArgs = null;
            if (useFinderCache) {
                finderArgs = new Object[]{groupId};
            }
            Object result = null;
            if (useFinderCache) {
                result = this.finderCache.getResult(this._finderPathFetchByGroupId, finderArgs, (BasePersistenceImpl)this);
            }
            if (result instanceof LayoutSEOSite && groupId != (layoutSEOSite2 = (LayoutSEOSite)result).getGroupId()) {
                result = null;
            }
            if (result == null) {
                StringBundler sb = new StringBundler(3);
                sb.append(_SQL_SELECT_LAYOUTSEOSITE_WHERE);
                sb.append("layoutSEOSite.groupId = ?");
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(groupId);
                    List list = query.list();
                    if (list.isEmpty()) {
                        if (useFinderCache) {
                            this.finderCache.putResult(this._finderPathFetchByGroupId, finderArgs, (Object)list);
                        }
                    } else {
                        LayoutSEOSite layoutSEOSite3 = (LayoutSEOSite)list.get(0);
                        result = layoutSEOSite3;
                        this.cacheResult(layoutSEOSite3);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            if (result instanceof List) {
                layoutSEOSite = null;
                return layoutSEOSite;
            }
            layoutSEOSite = (LayoutSEOSite)result;
            return layoutSEOSite;
        }
    }

    public LayoutSEOSite removeByGroupId(long groupId) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.findByGroupId(groupId);
        return (LayoutSEOSite)this.remove((BaseModel)layoutSEOSite);
    }

    public int countByGroupId(long groupId) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            FinderPath finderPath = this._finderPathCountByGroupId;
            Object[] finderArgs = new Object[]{groupId};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
            if (count == null) {
                StringBundler sb = new StringBundler(2);
                sb.append(_SQL_COUNT_LAYOUTSEOSITE_WHERE);
                sb.append("layoutSEOSite.groupId = ?");
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(groupId);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public LayoutSEOSitePersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(LayoutSEOSite.class);
        this.setModelImplClass(LayoutSEOSiteImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)LayoutSEOSiteTable.INSTANCE);
    }

    public void cacheResult(LayoutSEOSite layoutSEOSite) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)layoutSEOSite.getCtCollectionId());){
            this.entityCache.putResult(LayoutSEOSiteImpl.class, (Serializable)Long.valueOf(layoutSEOSite.getPrimaryKey()), (Serializable)layoutSEOSite);
            this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{layoutSEOSite.getUuid(), layoutSEOSite.getGroupId()}, (Object)layoutSEOSite);
            this.finderCache.putResult(this._finderPathFetchByGroupId, new Object[]{layoutSEOSite.getGroupId()}, (Object)layoutSEOSite);
        }
    }

    public void cacheResult(List<LayoutSEOSite> layoutSEOSites) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && layoutSEOSites.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (LayoutSEOSite layoutSEOSite : layoutSEOSites) {
            SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)layoutSEOSite.getCtCollectionId());
            Throwable throwable = null;
            try {
                if (this.entityCache.getResult(LayoutSEOSiteImpl.class, (Serializable)Long.valueOf(layoutSEOSite.getPrimaryKey())) != null) continue;
                this.cacheResult(layoutSEOSite);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (safeCloseable == null) continue;
                if (throwable != null) {
                    try {
                        safeCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                safeCloseable.close();
            }
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(LayoutSEOSiteImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(LayoutSEOSite layoutSEOSite) {
        this.entityCache.removeResult(LayoutSEOSiteImpl.class, (BaseModel)layoutSEOSite);
    }

    public void clearCache(List<LayoutSEOSite> layoutSEOSites) {
        for (LayoutSEOSite layoutSEOSite : layoutSEOSites) {
            this.entityCache.removeResult(LayoutSEOSiteImpl.class, (BaseModel)layoutSEOSite);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(LayoutSEOSiteImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(LayoutSEOSiteModelImpl layoutSEOSiteModelImpl) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)layoutSEOSiteModelImpl.getCtCollectionId());){
            Object[] args = new Object[]{layoutSEOSiteModelImpl.getUuid(), layoutSEOSiteModelImpl.getGroupId()};
            this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L, false);
            this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)layoutSEOSiteModelImpl, false);
            args = new Object[]{layoutSEOSiteModelImpl.getGroupId()};
            this.finderCache.putResult(this._finderPathCountByGroupId, args, (Object)1L, false);
            this.finderCache.putResult(this._finderPathFetchByGroupId, args, (Object)layoutSEOSiteModelImpl, false);
        }
    }

    public LayoutSEOSite create(long layoutSEOSiteId) {
        LayoutSEOSiteImpl layoutSEOSite = new LayoutSEOSiteImpl();
        layoutSEOSite.setNew(true);
        layoutSEOSite.setPrimaryKey(layoutSEOSiteId);
        String uuid = PortalUUIDUtil.generate();
        layoutSEOSite.setUuid(uuid);
        layoutSEOSite.setCompanyId(CompanyThreadLocal.getCompanyId());
        return layoutSEOSite;
    }

    public LayoutSEOSite remove(long layoutSEOSiteId) throws NoSuchSiteException {
        return this.remove(Long.valueOf(layoutSEOSiteId));
    }

    public LayoutSEOSite remove(Serializable primaryKey) throws NoSuchSiteException {
        Session session = null;
        try {
            session = this.openSession();
            LayoutSEOSite layoutSEOSite = (LayoutSEOSite)session.get(LayoutSEOSiteImpl.class, primaryKey);
            if (layoutSEOSite == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchSiteException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            LayoutSEOSite layoutSEOSite2 = (LayoutSEOSite)this.remove((BaseModel)layoutSEOSite);
            return layoutSEOSite2;
        }
        catch (NoSuchSiteException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected LayoutSEOSite removeImpl(LayoutSEOSite layoutSEOSite) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)layoutSEOSite)) {
                layoutSEOSite = (LayoutSEOSite)session.get(LayoutSEOSiteImpl.class, layoutSEOSite.getPrimaryKeyObj());
            }
            if (layoutSEOSite != null && this.ctPersistenceHelper.isRemove((CTModel)layoutSEOSite)) {
                session.delete((Object)layoutSEOSite);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (layoutSEOSite != null) {
            this.clearCache(layoutSEOSite);
        }
        return layoutSEOSite;
    }

    public LayoutSEOSite updateImpl(LayoutSEOSite layoutSEOSite) {
        boolean isNew = layoutSEOSite.isNew();
        if (!(layoutSEOSite instanceof LayoutSEOSiteModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(layoutSEOSite.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)layoutSEOSite);
                throw new IllegalArgumentException("Implement ModelWrapper in layoutSEOSite proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom LayoutSEOSite implementation " + layoutSEOSite.getClass());
        }
        LayoutSEOSiteModelImpl layoutSEOSiteModelImpl = (LayoutSEOSiteModelImpl)layoutSEOSite;
        if (Validator.isNull((String)layoutSEOSite.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            layoutSEOSite.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && layoutSEOSite.getCreateDate() == null) {
            if (serviceContext == null) {
                layoutSEOSite.setCreateDate(date);
            } else {
                layoutSEOSite.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!layoutSEOSiteModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                layoutSEOSite.setModifiedDate(date);
            } else {
                layoutSEOSite.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)layoutSEOSite)) {
                if (!isNew) {
                    session.evict(LayoutSEOSiteImpl.class, layoutSEOSite.getPrimaryKeyObj());
                }
                session.save((Object)layoutSEOSite);
            } else {
                layoutSEOSite = (LayoutSEOSite)session.merge((Object)layoutSEOSite);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(LayoutSEOSiteImpl.class, (BaseModel)layoutSEOSiteModelImpl, false, true);
        this.cacheUniqueFindersCache(layoutSEOSiteModelImpl);
        if (isNew) {
            layoutSEOSite.setNew(false);
        }
        layoutSEOSite.resetOriginalValues();
        return layoutSEOSite;
    }

    public LayoutSEOSite findByPrimaryKey(Serializable primaryKey) throws NoSuchSiteException {
        LayoutSEOSite layoutSEOSite = this.fetchByPrimaryKey(primaryKey);
        if (layoutSEOSite == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchSiteException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return layoutSEOSite;
    }

    public LayoutSEOSite findByPrimaryKey(long layoutSEOSiteId) throws NoSuchSiteException {
        return this.findByPrimaryKey(Long.valueOf(layoutSEOSiteId));
    }

    public LayoutSEOSite fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(LayoutSEOSite.class, primaryKey)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                LayoutSEOSite layoutSEOSite = (LayoutSEOSite)super.fetchByPrimaryKey(primaryKey);
                return layoutSEOSite;
            }
        }
        LayoutSEOSite layoutSEOSite = (LayoutSEOSite)this.entityCache.getResult(LayoutSEOSiteImpl.class, primaryKey);
        if (layoutSEOSite != null) {
            return layoutSEOSite;
        }
        Session session = null;
        try {
            session = this.openSession();
            layoutSEOSite = (LayoutSEOSite)session.get(LayoutSEOSiteImpl.class, primaryKey);
            if (layoutSEOSite != null) {
                this.cacheResult(layoutSEOSite);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return layoutSEOSite;
    }

    public LayoutSEOSite fetchByPrimaryKey(long layoutSEOSiteId) {
        return this.fetchByPrimaryKey(Long.valueOf(layoutSEOSiteId));
    }

    public Map<Serializable, LayoutSEOSite> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(LayoutSEOSite.class)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                Map map = super.fetchByPrimaryKeys(primaryKeys);
                return map;
            }
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, LayoutSEOSite> map = new HashMap<Serializable, LayoutSEOSite>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            LayoutSEOSite layoutSEOSite = this.fetchByPrimaryKey(primaryKey);
            if (layoutSEOSite != null) {
                map.put(primaryKey, layoutSEOSite);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class, primaryKey);
            Throwable throwable = null;
            try {
                LayoutSEOSite layoutSEOSite = (LayoutSEOSite)this.entityCache.getResult(LayoutSEOSiteImpl.class, primaryKey);
                if (layoutSEOSite == null) {
                    if (uncachedPrimaryKeys == null) {
                        uncachedPrimaryKeys = new HashSet<Serializable>();
                    }
                    uncachedPrimaryKeys.add(primaryKey);
                    continue;
                }
                map.put(primaryKey, layoutSEOSite);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (safeCloseable == null) continue;
                if (throwable != null) {
                    try {
                        safeCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                safeCloseable.close();
            }
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (LayoutSEOSite layoutSEOSite : query.list()) {
                map.put(layoutSEOSite.getPrimaryKeyObj(), layoutSEOSite);
                this.cacheResult(layoutSEOSite);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<LayoutSEOSite> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<LayoutSEOSite> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<LayoutSEOSite> findAll(int start, int end, OrderByComparator<LayoutSEOSite> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<LayoutSEOSite> findAll(int start, int end, OrderByComparator<LayoutSEOSite> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindAll;
                    finderArgs = FINDER_ARGS_EMPTY;
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindAll;
                finderArgs = new Object[]{start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache) {
                list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
            }
            if (list == null) {
                StringBundler sb = null;
                String sql = null;
                if (orderByComparator != null) {
                    sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                    sb.append(_SQL_SELECT_LAYOUTSEOSITE);
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                    sql = sb.toString();
                } else {
                    sql = _SQL_SELECT_LAYOUTSEOSITE;
                    sql = sql.concat(" ORDER BY layoutSEOSite.layoutSEOSiteId ASC");
                }
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public void removeAll() {
        for (LayoutSEOSite layoutSEOSite : this.findAll()) {
            this.remove((BaseModel)layoutSEOSite);
        }
    }

    public int countAll() {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(LayoutSEOSite.class);){
            Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
            if (count == null) {
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(_SQL_COUNT_LAYOUTSEOSITE);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "layoutSEOSiteId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_LAYOUTSEOSITE;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return LayoutSEOSiteModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "LayoutSEOSite";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new LayoutSEOSiteModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)LayoutSEOSite.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathCountByUUID_G = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, false);
        this._finderPathWithPaginationFindByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathFetchByGroupId = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathCountByGroupId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        LayoutSEOSiteUtil.setPersistence((LayoutSEOSitePersistence)this);
    }

    @Deactivate
    public void deactivate() {
        LayoutSEOSiteUtil.setPersistence(null);
        this.entityCache.removeCache(LayoutSEOSiteImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.layout.seo.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.layout.seo.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.layout.seo.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctIgnoreColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("uuid_");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("userId");
        ctStrictColumnNames.add("userName");
        ctStrictColumnNames.add("createDate");
        ctIgnoreColumnNames.add("modifiedDate");
        ctStrictColumnNames.add("openGraphEnabled");
        ctStrictColumnNames.add("openGraphImageAlt");
        ctStrictColumnNames.add("openGraphImageFileEntryId");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.IGNORE, ctIgnoreColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("layoutSEOSiteId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"uuid_", "groupId"});
        _uniqueIndexColumnNames.add(new String[]{"groupId"});
        _log = LogFactoryUtil.getLog(LayoutSEOSitePersistenceImpl.class);
        _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    }

    private static class LayoutSEOSiteModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private LayoutSEOSiteModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            LayoutSEOSiteModelImpl layoutSEOSiteModelImpl = (LayoutSEOSiteModelImpl)baseModel;
            long columnBitmask = layoutSEOSiteModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return LayoutSEOSiteModelArgumentsResolver._getValue(layoutSEOSiteModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | LayoutSEOSiteModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return LayoutSEOSiteModelArgumentsResolver._getValue(layoutSEOSiteModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(LayoutSEOSiteModelImpl layoutSEOSiteModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? layoutSEOSiteModelImpl.getColumnOriginalValue(columnName) : layoutSEOSiteModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

