/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.util;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.display.page.util.AssetDisplayPageUtil;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class FriendlyURLMapperProvider {
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLMapperProvider.class);
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private ClassNameLocalService _classNameLocalService;

    public FriendlyURLMapperProvider(AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, ClassNameLocalService classNameLocalService) {
        this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
        this._classNameLocalService = classNameLocalService;
    }

    public FriendlyURLMapper getFriendlyURLMapper(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return Optional.ofNullable((LayoutDisplayPageObjectProvider)httpServletRequest.getAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER")).filter(layoutDisplayPageObjectProvider -> {
            try {
                return AssetDisplayPageUtil.hasAssetDisplayPage((long)layoutDisplayPageObjectProvider.getGroupId(), (long)layoutDisplayPageObjectProvider.getClassNameId(), (long)layoutDisplayPageObjectProvider.getClassPK(), (long)layoutDisplayPageObjectProvider.getClassTypeId());
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
                return false;
            }
        }).map(layoutDisplayPageObjectProvider -> new AssetDisplayPageFriendlyURLMapper(this._assetDisplayPageFriendlyURLProvider, this._classNameLocalService, (LayoutDisplayPageObjectProvider<?>)layoutDisplayPageObjectProvider, themeDisplay)).orElseGet(() -> new DefaultPageFriendlyURLMapper());
    }

    public static interface FriendlyURLMapper {
        public String getMappedFriendlyURL(String var1, Locale var2) throws PortalException;

        public Map<Locale, String> getMappedFriendlyURLs(Map<Locale, String> var1) throws PortalException;
    }

    public static class DefaultPageFriendlyURLMapper
    implements FriendlyURLMapper {
        @Override
        public String getMappedFriendlyURL(String url, Locale locale) {
            return url;
        }

        @Override
        public Map<Locale, String> getMappedFriendlyURLs(Map<Locale, String> friendlyURLs) {
            return friendlyURLs;
        }
    }

    public static class AssetDisplayPageFriendlyURLMapper
    implements FriendlyURLMapper {
        private final AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
        private final ClassNameLocalService _classNameLocalService;
        private final LayoutDisplayPageObjectProvider<?> _layoutDisplayPageObjectProvider;
        private final ThemeDisplay _themeDisplay;

        @Override
        public String getMappedFriendlyURL(String url, Locale locale) throws PortalException {
            if (this._layoutDisplayPageObjectProvider == null) {
                return url;
            }
            ClassName className = this._classNameLocalService.getClassName(this._layoutDisplayPageObjectProvider.getClassNameId());
            return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(className.getClassName(), this._layoutDisplayPageObjectProvider.getClassPK(), locale, this._themeDisplay);
        }

        @Override
        public Map<Locale, String> getMappedFriendlyURLs(Map<Locale, String> friendlyURLs) throws PortalException {
            if (this._layoutDisplayPageObjectProvider == null) {
                return friendlyURLs;
            }
            HashMap<Locale, String> mappedFriendlyURLs = new HashMap<Locale, String>();
            for (Map.Entry<Locale, String> entry : friendlyURLs.entrySet()) {
                mappedFriendlyURLs.put(entry.getKey(), this.getMappedFriendlyURL(entry.getValue(), entry.getKey()));
            }
            return mappedFriendlyURLs;
        }

        protected AssetDisplayPageFriendlyURLMapper(AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, ClassNameLocalService classNameLocalService, LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider, ThemeDisplay themeDisplay) {
            this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
            this._classNameLocalService = classNameLocalService;
            this._layoutDisplayPageObjectProvider = layoutDisplayPageObjectProvider;
            this._themeDisplay = themeDisplay;
        }
    }
}

