/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateStructureLocalServiceBaseImpl;
import com.liferay.layout.page.template.util.CheckUnlockedLayoutThreadLocal;
import com.liferay.layout.util.UpdateLayoutStatusThreadLocal;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.LockedLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateStructure"}, service={AopService.class})
public class LayoutPageTemplateStructureLocalServiceImpl
extends LayoutPageTemplateStructureLocalServiceBaseImpl {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public LayoutPageTemplateStructure addLayoutPageTemplateStructure(long userId, long groupId, long plid, long segmentsExperienceId, String data, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long layoutPageTemplateStructureId = this.counterLocalService.increment();
        LayoutPageTemplateStructure layoutPageTemplateStructure = this.layoutPageTemplateStructurePersistence.create(layoutPageTemplateStructureId);
        layoutPageTemplateStructure.setUuid(serviceContext.getUuid());
        layoutPageTemplateStructure.setGroupId(groupId);
        layoutPageTemplateStructure.setCompanyId(user.getCompanyId());
        layoutPageTemplateStructure.setUserId(user.getUserId());
        layoutPageTemplateStructure.setUserName(user.getFullName());
        layoutPageTemplateStructure.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateStructure.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateStructure.setPlid(plid);
        layoutPageTemplateStructure = (LayoutPageTemplateStructure)this.layoutPageTemplateStructurePersistence.update((BaseModel)layoutPageTemplateStructure);
        int count = this._fragmentEntryLinkLocalService.getFragmentEntryLinksCountByPlid(groupId, plid);
        if (count > 0) {
            this._updateLayoutStatus(userId, plid);
        }
        if (!ExportImportThreadLocal.isImportInProcess()) {
            this._layoutPageTemplateStructureRelLocalService.addLayoutPageTemplateStructureRel(userId, groupId, layoutPageTemplateStructureId, segmentsExperienceId, data, serviceContext);
        }
        return layoutPageTemplateStructure;
    }

    @Override
    @SystemEvent(type=1)
    public LayoutPageTemplateStructure deleteLayoutPageTemplateStructure(LayoutPageTemplateStructure layoutPageTemplateStructure) {
        this.layoutPageTemplateStructurePersistence.remove((BaseModel)layoutPageTemplateStructure);
        List layoutPageTemplateStructureRels = this._layoutPageTemplateStructureRelLocalService.getLayoutPageTemplateStructureRels(layoutPageTemplateStructure.getLayoutPageTemplateStructureId());
        for (LayoutPageTemplateStructureRel layoutPageTemplateStructureRel : layoutPageTemplateStructureRels) {
            this._layoutPageTemplateStructureRelLocalService.deleteLayoutPageTemplateStructureRel(layoutPageTemplateStructureRel);
        }
        return layoutPageTemplateStructure;
    }

    public LayoutPageTemplateStructure deleteLayoutPageTemplateStructure(long groupId, long plid) throws PortalException {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this.layoutPageTemplateStructurePersistence.findByG_P(groupId, plid);
        this.layoutPageTemplateStructureLocalService.deleteLayoutPageTemplateStructure(layoutPageTemplateStructure);
        return layoutPageTemplateStructure;
    }

    public LayoutPageTemplateStructure fetchLayoutPageTemplateStructure(long groupId, long plid) {
        return this.layoutPageTemplateStructurePersistence.fetchByG_P(groupId, plid);
    }

    public LayoutPageTemplateStructure updateLayoutPageTemplateStructureData(long userId, long groupId, long plid, long segmentsExperienceId, String data) throws PortalException {
        if (CheckUnlockedLayoutThreadLocal.isCheckUnlockedLayout().booleanValue()) {
            this._checkUnlockedLayout(userId, plid);
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this.layoutPageTemplateStructurePersistence.findByG_P(groupId, plid);
        layoutPageTemplateStructure.setModifiedDate(new Date());
        layoutPageTemplateStructure = (LayoutPageTemplateStructure)this.layoutPageTemplateStructurePersistence.update((BaseModel)layoutPageTemplateStructure);
        LayoutPageTemplateStructureRel layoutPageTemplateStructureRel = this._layoutPageTemplateStructureRelLocalService.fetchLayoutPageTemplateStructureRel(layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperienceId);
        if (layoutPageTemplateStructureRel == null) {
            this._layoutPageTemplateStructureRelLocalService.addLayoutPageTemplateStructureRel(userId, groupId, layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperienceId, data, ServiceContextThreadLocal.getServiceContext());
        } else {
            this._layoutPageTemplateStructureRelLocalService.updateLayoutPageTemplateStructureRel(layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperienceId, data);
        }
        this._updateLayoutStatus(userId, plid);
        return layoutPageTemplateStructure;
    }

    public LayoutPageTemplateStructure updateLayoutPageTemplateStructureData(long userId, long groupId, long plid, String data) throws PortalException {
        this._checkUnlockedLayout(userId, plid);
        long defaultSegmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(plid);
        return this.layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(userId, groupId, plid, defaultSegmentsExperienceId, data);
    }

    private void _checkUnlockedLayout(long userId, long plid) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout != null && !layout.isUnlocked("edit", userId)) {
            throw new LockedLayoutException();
        }
    }

    private void _updateLayoutStatus(long userId, long plid) throws PortalException {
        if (UpdateLayoutStatusThreadLocal.isUpdateLayoutStatus().booleanValue()) {
            this._layoutLocalService.updateStatus(userId, plid, 2, ServiceContextThreadLocal.getServiceContext());
        }
    }
}

