/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v5_0_0;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class LayoutPageTemplateStructureUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (PreparedStatement deletePreparedStatement = this.connection.prepareStatement("delete from LayoutPageTemplateStructure where ctCollectionId = ? and layoutPageTemplateStructureId = ?");
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, layoutPageTemplateStructureId, classPK from LayoutPageTemplateStructure where classNameId = ?");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update LayoutPageTemplateStructure set classNameId = ?, classPK = ? where ctCollectionId = ? and layoutPageTemplateStructureId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId(LayoutPageTemplateEntry.class));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long ctCollectionId = resultSet.getLong("ctCollectionId");
                    long layoutPageTemplateStructureId = resultSet.getLong("layoutPageTemplateStructureId");
                    long classPK = resultSet.getLong("classPK");
                    long plid = this._getPlidFromLayoutPageTemplateEntry(ctCollectionId, classPK);
                    if (this._hasLayoutPageTemplateStructure(ctCollectionId, plid)) {
                        deletePreparedStatement.setLong(1, ctCollectionId);
                        deletePreparedStatement.setLong(2, layoutPageTemplateStructureId);
                        deletePreparedStatement.executeUpdate();
                        continue;
                    }
                    preparedStatement2.setLong(1, PortalUtil.getClassNameId(Layout.class));
                    preparedStatement2.setLong(2, plid);
                    preparedStatement2.setLong(3, ctCollectionId);
                    preparedStatement2.setLong(4, layoutPageTemplateStructureId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    private long _getPlidFromLayoutPageTemplateEntry(long ctCollectionId, long layoutPageTemplateEntryId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select plid from LayoutPageTemplateEntry where ctCollectionId = ? and layoutPageTemplateEntryId = ?");){
            preparedStatement.setLong(1, ctCollectionId);
            preparedStatement.setLong(2, layoutPageTemplateEntryId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong("plid");
                    return l;
                }
            }
        }
        return 0L;
    }

    private boolean _hasLayoutPageTemplateStructure(long ctCollectionId, long classPK) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select 1 from LayoutPageTemplateStructure where ctCollectionId = ? and classNameId = ? and classPK = ?");){
            boolean bl;
            block12: {
                preparedStatement.setLong(1, ctCollectionId);
                preparedStatement.setLong(2, PortalUtil.getClassNameId(Layout.class));
                preparedStatement.setLong(3, classPK);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }
}

