/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.exportimport.content.processor;

import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.fragment.entry.processor.helper.LayoutReferenceResolver;
import com.liferay.fragment.util.exportimport.content.processor.ExportImportContentProcessorUtil;
import com.liferay.info.item.ERCInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.staging.InfoStagingClassMapperRegistry;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=LayoutPageTemplateStructureRelReferences"}, service={ExportImportContentProcessor.class})
public class DataValuesMappingExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String _DDM_TEMPLATE = "ddmTemplate_";
    private static final Log _log = LogFactoryUtil.getLog(DataValuesMappingExportImportContentProcessor.class);
    @Reference
    private AssetListEntryLocalService _assetListEntryLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private InfoStagingClassMapperRegistry _infoStagingClassMapperRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutReferenceResolver _layoutReferenceResolver;
    @Reference
    private Portal _portal;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String data, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        if (!JSONUtil.isJSONObject((String)data)) {
            return data;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(data);
        this._exportContentReferences(exportReferencedContent, jsonObject, portletDataContext, stagedModel);
        return jsonObject.toString();
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String data) throws Exception {
        if (!JSONUtil.isJSONObject((String)data)) {
            return data;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(data);
        this._replaceImportContentReferences(jsonObject, portletDataContext, stagedModel);
        return jsonObject.toString();
    }

    public void validateContentReferences(long groupId, String data) {
    }

    private void _exportCollectionContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) {
        block7: {
            Long assetListEntryGroupId;
            JSONObject collectionJSONObject = this._getCollectionJSONObject(itemJSONObject);
            if (collectionJSONObject == null) {
                return;
            }
            AssetListEntry assetListEntry = null;
            long classPK = collectionJSONObject.getLong("classPK");
            String externalReferenceCode = collectionJSONObject.getString("externalReferenceCode");
            if (classPK > 0L) {
                assetListEntry = this._assetListEntryLocalService.fetchAssetListEntry(classPK);
            } else if (Validator.isNotNull((String)externalReferenceCode) && (assetListEntryGroupId = this._getGroupId(portletDataContext.getCompanyId(), collectionJSONObject.getString("scopeExternalReferenceCode"), portletDataContext.getScopeGroupId())) != null) {
                assetListEntry = this._assetListEntryLocalService.fetchAssetListEntryByExternalReferenceCode(externalReferenceCode, assetListEntryGroupId.longValue());
            }
            if (assetListEntry != null) {
                try {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)assetListEntry, (String)"dependency");
                }
                catch (PortletDataException portletDataException) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Throwable)portletDataException);
                }
            }
        }
    }

    private void _exportContainerContentReferences(boolean exportReferencedContent, JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (configJSONObject.has("link")) {
            JSONObject linkJSONObject = configJSONObject.getJSONObject("link");
            this._exportMappedFieldContentReference(exportReferencedContent, linkJSONObject, portletDataContext, stagedModel);
            if (linkJSONObject.has("layout")) {
                this._exportLayoutContentReference(exportReferencedContent, linkJSONObject.getJSONObject("layout"), portletDataContext, stagedModel);
            }
        }
        if (!configJSONObject.has("styles")) {
            return;
        }
        JSONObject stylesJSONObject = configJSONObject.getJSONObject("styles");
        if (stylesJSONObject.has("backgroundImage")) {
            this._exportMappedFieldContentReference(exportReferencedContent, stylesJSONObject.getJSONObject("backgroundImage"), portletDataContext, stagedModel);
        }
    }

    private void _exportContentReferences(boolean exportReferencedContent, JSONObject jsonObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!jsonObject.has("items")) {
            return;
        }
        JSONObject itemsJSONObject = jsonObject.getJSONObject("items");
        if (itemsJSONObject == null) {
            return;
        }
        for (String key : itemsJSONObject.keySet()) {
            JSONObject itemJSONObject = itemsJSONObject.getJSONObject(key);
            if (Objects.equals(itemJSONObject.get("type"), "container")) {
                this._exportContainerContentReferences(exportReferencedContent, itemJSONObject, portletDataContext, stagedModel);
                continue;
            }
            if (Objects.equals(itemJSONObject.get("type"), "collection")) {
                this._exportCollectionContentReferences(itemJSONObject, portletDataContext, stagedModel);
                continue;
            }
            if (Objects.equals(itemJSONObject.get("type"), "form")) {
                this._exportFormReferences(itemJSONObject, portletDataContext, stagedModel);
                this._exportFormOrRowContentReferences(exportReferencedContent, itemJSONObject, portletDataContext, stagedModel);
                this._exportFormSuccessMessageLayoutReferences(exportReferencedContent, itemJSONObject, portletDataContext, stagedModel);
                continue;
            }
            if (!Objects.equals(itemJSONObject.get("type"), "row")) continue;
            this._exportFormOrRowContentReferences(exportReferencedContent, itemJSONObject, portletDataContext, stagedModel);
        }
    }

    private void _exportDDMTemplateReference(JSONObject editableJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        String mappedField = editableJSONObject.getString("mappedField", editableJSONObject.getString("fieldId"));
        if (!mappedField.startsWith(_DDM_TEMPLATE)) {
            return;
        }
        String ddmTemplateKey = mappedField.substring(_DDM_TEMPLATE.length());
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(DDMStructure.class), ddmTemplateKey);
        if (ddmTemplate != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)ddmTemplate, (String)"dependency");
        }
    }

    private void _exportFormOrRowContentReferences(boolean exportReferencedContent, JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (!configJSONObject.has("styles")) {
            return;
        }
        JSONObject stylesJSONObject = configJSONObject.getJSONObject("styles");
        if (stylesJSONObject.has("backgroundImage")) {
            this._exportMappedFieldContentReference(exportReferencedContent, stylesJSONObject.getJSONObject("backgroundImage"), portletDataContext, stagedModel);
        }
    }

    private void _exportFormReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (!configJSONObject.has("classNameId")) {
            return;
        }
        long classNameId = configJSONObject.getLong("classNameId");
        String className = "";
        try {
            className = this._portal.getClassName(classNameId);
        }
        catch (RuntimeException runtimeException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)runtimeException);
            }
            return;
        }
        Element element = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
        element.addAttribute("formClassName", this._infoStagingClassMapperRegistry.getStagingClassName(className));
    }

    private void _exportFormSuccessMessageLayoutReferences(boolean exportReferencedContent, JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        JSONObject successMessageJSONObject = this._getSuccessMessageJSONObject(itemJSONObject);
        if (successMessageJSONObject == null || JSONUtil.isEmpty((JSONObject)successMessageJSONObject.getJSONObject("layout"))) {
            return;
        }
        JSONObject layoutJSONObject = successMessageJSONObject.getJSONObject("layout");
        this._exportLayoutContentReference(exportReferencedContent, layoutJSONObject, portletDataContext, stagedModel);
    }

    private void _exportLayoutContentReference(boolean exportReferencedContent, JSONObject layoutJSONObject, PortletDataContext portletDataContext, StagedModel referrerStagedModel) throws Exception {
        if (JSONUtil.isEmpty((JSONObject)layoutJSONObject)) {
            return;
        }
        Layout layout = this._layoutReferenceResolver.resolve(portletDataContext.getCompanyId(), layoutJSONObject, portletDataContext.getScopeGroupId());
        if (layout == null) {
            return;
        }
        layoutJSONObject.put("plid", layout.getPlid());
        if (exportReferencedContent) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)referrerStagedModel, (StagedModel)layout, (String)"dependency");
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)referrerStagedModel);
            portletDataContext.addReferenceElement((ClassedModel)referrerStagedModel, entityElement, (ClassedModel)layout, "dependency", true);
        }
    }

    private void _exportMappedFieldContentReference(boolean exportReferencedContent, JSONObject jsonObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        long classNameId = jsonObject.getLong("classNameId");
        long classPK = jsonObject.getLong("classPK");
        String externalReferenceCode = jsonObject.getString("externalReferenceCode", null);
        if ((classNameId == 0L || classPK == 0L) && Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        this._exportDDMTemplateReference(jsonObject, portletDataContext, stagedModel);
        String className = this._portal.fetchClassName(classNameId);
        jsonObject.put("className", className);
        if (classPK > 0L) {
            ExportImportContentProcessorUtil.exportContentReference((String)className, (long)classPK, (boolean)exportReferencedContent, (InfoItemServiceRegistry)this._infoItemServiceRegistry, (PortletDataContext)portletDataContext, (StagedModel)stagedModel);
            return;
        }
        ExportImportContentProcessorUtil.exportContentReference((String)className, (boolean)exportReferencedContent, (InfoItemIdentifier)new ERCInfoItemIdentifier(externalReferenceCode, jsonObject.getString("scopeExternalReferenceCode", null)), (InfoItemServiceRegistry)this._infoItemServiceRegistry, (PortletDataContext)portletDataContext, (StagedModel)stagedModel);
    }

    private JSONObject _getCollectionJSONObject(JSONObject itemJSONObject) {
        if (!itemJSONObject.has("config")) {
            return null;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (!configJSONObject.has("collection")) {
            return null;
        }
        JSONObject collectionJSONObject = configJSONObject.getJSONObject("collection");
        String type = collectionJSONObject.getString("type");
        if (!Objects.equals(type, InfoListItemSelectorReturnType.class.getName())) {
            return null;
        }
        return collectionJSONObject;
    }

    private Long _getGroupId(long companyId, String scopeExternalReferenceCode, long scopeGroupId) {
        if (Validator.isNull((String)scopeExternalReferenceCode)) {
            return scopeGroupId;
        }
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(scopeExternalReferenceCode, companyId);
        if (group == null) {
            return null;
        }
        return group.getGroupId();
    }

    private JSONObject _getSuccessMessageJSONObject(JSONObject itemJSONObject) {
        if (!itemJSONObject.has("config")) {
            return null;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (!configJSONObject.has("successMessage")) {
            return null;
        }
        return configJSONObject.getJSONObject("successMessage");
    }

    private void _replaceCollectionImportContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) {
        AssetListEntry assetListEntry;
        long newClassPK;
        Map assetListEntryNewPrimaryKeys;
        long classPK;
        JSONObject collectionJSONObject;
        block7: {
            collectionJSONObject = this._getCollectionJSONObject(itemJSONObject);
            if (collectionJSONObject == null) {
                return;
            }
            classPK = collectionJSONObject.getLong("classPK");
            if (classPK == 0L) {
                return;
            }
            assetListEntryNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(AssetListEntry.class.getName());
            newClassPK = MapUtil.getLong((Map)assetListEntryNewPrimaryKeys, (long)classPK, (long)-1L);
            if (newClassPK == -1L) {
                try {
                    StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, AssetListEntry.class, (Serializable)Long.valueOf(classPK));
                }
                catch (Exception exception) {
                    StringBundler exceptionSB = new StringBundler(6);
                    exceptionSB.append("Unable to process asset list entry ");
                    exceptionSB.append(classPK);
                    exceptionSB.append(" for ");
                    exceptionSB.append(stagedModel.getModelClassName());
                    exceptionSB.append(" with primary key ");
                    exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                    ExportImportContentProcessorException exportImportContentProcessorException = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)exception);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)exceptionSB.toString(), (Throwable)exportImportContentProcessorException);
                    }
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)exceptionSB.toString());
                }
            }
        }
        if ((assetListEntry = this._assetListEntryLocalService.fetchAssetListEntry(newClassPK = MapUtil.getLong((Map)assetListEntryNewPrimaryKeys, (long)classPK, (long)classPK))) != null) {
            collectionJSONObject.put("classNameId", this._portal.getClassNameId(assetListEntry.getAssetEntryType())).put("classPK", String.valueOf(newClassPK)).put("itemSubtype", assetListEntry.getAssetEntrySubtype()).put("itemType", assetListEntry.getAssetEntryType()).put("title", assetListEntry.getTitle());
        }
    }

    private void _replaceContainerImportContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext) {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (configJSONObject.has("link")) {
            JSONObject linkJSONObject = configJSONObject.getJSONObject("link");
            this._replaceMappedFieldImportContentReferences(linkJSONObject, portletDataContext);
            if (linkJSONObject.has("layout")) {
                this._replaceImportLayoutReferences(linkJSONObject.getJSONObject("layout"), portletDataContext);
            }
        }
        if (!configJSONObject.has("styles")) {
            return;
        }
        JSONObject stylesJSONObject = configJSONObject.getJSONObject("styles");
        if (stylesJSONObject.has("backgroundImage")) {
            this._replaceMappedFieldImportContentReferences(stylesJSONObject.getJSONObject("backgroundImage"), portletDataContext);
        }
    }

    private void _replaceFormImportContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        Element element = portletDataContext.getImportDataStagedModelElement(stagedModel);
        String formClassName = GetterUtil.getString((String)element.attributeValue("formClassName"));
        configJSONObject.put("classNameId", this._portal.getClassNameId(this._infoStagingClassMapperRegistry.getClassName(formClassName)));
    }

    private void _replaceFormOrRowImportContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext) {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (!configJSONObject.has("styles")) {
            return;
        }
        JSONObject stylesJSONObject = configJSONObject.getJSONObject("styles");
        if (stylesJSONObject.has("backgroundImage")) {
            this._replaceMappedFieldImportContentReferences(stylesJSONObject.getJSONObject("backgroundImage"), portletDataContext);
        }
    }

    private void _replaceFormSuccessMessageLayoutReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext) {
        JSONObject successMessageJSONObject = this._getSuccessMessageJSONObject(itemJSONObject);
        if (successMessageJSONObject == null) {
            return;
        }
        JSONObject layoutJSONObject = successMessageJSONObject.getJSONObject("layout");
        if (layoutJSONObject == null || layoutJSONObject.length() == 0) {
            return;
        }
        if (layoutJSONObject.getLong("groupId") == portletDataContext.getSourceGroupId()) {
            layoutJSONObject.put("groupId", portletDataContext.getScopeGroupId());
            Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutJSONObject.getString("layoutUuid"), portletDataContext.getScopeGroupId(), layoutJSONObject.getBoolean("privateLayout"));
            if (layout != null) {
                layoutJSONObject.put("layoutId", layout.getLayoutId());
            }
        }
    }

    private void _replaceImportContentReferences(JSONObject jsonObject, PortletDataContext portletDataContext, StagedModel stagedModel) {
        if (!jsonObject.has("items")) {
            return;
        }
        JSONObject itemsJSONObject = jsonObject.getJSONObject("items");
        if (itemsJSONObject == null) {
            return;
        }
        for (String key : itemsJSONObject.keySet()) {
            JSONObject itemJSONObject = itemsJSONObject.getJSONObject(key);
            if (Objects.equals(itemJSONObject.get("type"), "container")) {
                this._replaceContainerImportContentReferences(itemJSONObject, portletDataContext);
                continue;
            }
            if (Objects.equals(itemJSONObject.get("type"), "collection")) {
                this._replaceCollectionImportContentReferences(itemJSONObject, portletDataContext, stagedModel);
                continue;
            }
            if (Objects.equals(itemJSONObject.get("type"), "form")) {
                this._replaceFormImportContentReferences(itemJSONObject, portletDataContext, stagedModel);
                this._replaceFormOrRowImportContentReferences(itemJSONObject, portletDataContext);
                this._replaceFormSuccessMessageLayoutReferences(itemJSONObject, portletDataContext);
                continue;
            }
            if (!Objects.equals(itemJSONObject.get("type"), "row")) continue;
            this._replaceFormOrRowImportContentReferences(itemJSONObject, portletDataContext);
        }
    }

    private void _replaceImportLayoutReferences(JSONObject layoutJSONObject, PortletDataContext portletDataContext) {
        if (layoutJSONObject.length() == 0) {
            return;
        }
        long plid = GetterUtil.getLong((Object)layoutJSONObject.remove("plid"));
        Map layoutNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(Layout.class.getName());
        Layout layout = this._layoutLocalService.fetchLayout(layoutNewPrimaryKeys.getOrDefault(plid, 0L).longValue());
        if (layout == null) {
            return;
        }
        layoutJSONObject.put("groupId", layout.getGroupId()).put("layoutId", layout.getLayoutId()).put("layoutUuid", layout.getUuid()).put("privateLayout", layout.isPrivateLayout());
    }

    private void _replaceMappedFieldImportContentReferences(JSONObject jsonObject, PortletDataContext portletDataContext) {
        String className = jsonObject.getString("className");
        if (Validator.isNull((String)className)) {
            return;
        }
        String mappedField = jsonObject.getString("mappedField", jsonObject.getString("fieldId"));
        if (mappedField.startsWith(_DDM_TEMPLATE)) {
            String ddmTemplateKey = mappedField.substring(_DDM_TEMPLATE.length());
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(String.valueOf(DDMTemplate.class) + ".ddmTemplateKey");
            String importedDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (Object)ddmTemplateKey, (String)ddmTemplateKey);
            if (jsonObject.has("mappedField")) {
                jsonObject.put("mappedField", _DDM_TEMPLATE + importedDDMTemplateKey);
            } else {
                jsonObject.put("fieldId", _DDM_TEMPLATE + importedDDMTemplateKey);
            }
        }
        ExportImportContentProcessorUtil.replaceImportContentReferences((JSONObject)jsonObject, (PortletDataContext)portletDataContext);
        if (jsonObject.has("fileEntryId")) {
            jsonObject.put("fileEntryId", jsonObject.getLong("classPK"));
        }
    }
}

