/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateCollectionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=layout", "json.web.service.context.path=LayoutPageTemplateCollection"}, service={AopService.class})
public class LayoutPageTemplateCollectionServiceImpl
extends LayoutPageTemplateCollectionServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference(target="(model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateCollection)")
    private ModelResourcePermission<LayoutPageTemplateCollection> _layoutPageTemplateCollectionModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.layout.page.template)")
    private PortletResourcePermission _portletResourcePermission;

    public LayoutPageTemplateCollection addLayoutPageTemplateCollection(String externalReferenceCode, long groupId, long parentLayoutPageTemplateCollectionId, String name, String description, int type, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_LAYOUT_PAGE_TEMPLATE_COLLECTION");
        return this.layoutPageTemplateCollectionLocalService.addLayoutPageTemplateCollection(externalReferenceCode, this.getUserId(), groupId, parentLayoutPageTemplateCollectionId, name, description, type, serviceContext);
    }

    public LayoutPageTemplateCollection copyLayoutPageTemplateCollection(long groupId, long sourceLayoutPageTemplateCollectionId, long layoutParentPageTemplateCollectionId, boolean copyPermissions, ServiceContext serviceContext) throws Exception {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_LAYOUT_PAGE_TEMPLATE_COLLECTION");
        return this.layoutPageTemplateCollectionLocalService.copyLayoutPageTemplateCollection(this.getUserId(), groupId, sourceLayoutPageTemplateCollectionId, layoutParentPageTemplateCollectionId, copyPermissions, serviceContext);
    }

    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(long layoutPageTemplateCollectionId) throws PortalException {
        this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), layoutPageTemplateCollectionId, "DELETE");
        return this.layoutPageTemplateCollectionLocalService.deleteLayoutPageTemplateCollection(layoutPageTemplateCollectionId);
    }

    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(String externalReferenceCode, long groupId) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionLocalService.getLayoutPageTemplateCollectionByExternalReferenceCode(externalReferenceCode, groupId);
        this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)layoutPageTemplateCollection, "DELETE");
        return this.layoutPageTemplateCollectionLocalService.deleteLayoutPageTemplateCollection(layoutPageTemplateCollection);
    }

    public void deleteLayoutPageTemplateCollections(long[] layoutPageTemplateCollectionIds) throws PortalException {
        for (long layoutPageTemplateCollectionId : layoutPageTemplateCollectionIds) {
            this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), layoutPageTemplateCollectionId, "DELETE");
            this.layoutPageTemplateCollectionLocalService.deleteLayoutPageTemplateCollection(layoutPageTemplateCollectionId);
        }
    }

    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long layoutPageTemplateCollectionId) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollection(layoutPageTemplateCollectionId);
        if (layoutPageTemplateCollection != null) {
            this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)layoutPageTemplateCollection, "VIEW");
        }
        return layoutPageTemplateCollection;
    }

    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long groupId, String name, long parentLayoutPageTemplateCollectionId, int type) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollection(groupId, name, parentLayoutPageTemplateCollectionId, type);
        if (layoutPageTemplateCollection != null) {
            this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)layoutPageTemplateCollection, "VIEW");
        }
        return layoutPageTemplateCollection;
    }

    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(String externalReferenceCode, long groupId) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollectionByExternalReferenceCode(externalReferenceCode, groupId);
        if (layoutPageTemplateCollection != null) {
            this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)layoutPageTemplateCollection, "VIEW");
        }
        return layoutPageTemplateCollection;
    }

    public LayoutPageTemplateCollection getLayoutPageTemplateCollection(String externalReferenceCode, long groupId) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionLocalService.getLayoutPageTemplateCollectionByExternalReferenceCode(externalReferenceCode, groupId);
        this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)layoutPageTemplateCollection, "VIEW");
        return layoutPageTemplateCollection;
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int type) {
        return this.layoutPageTemplateCollectionPersistence.filterFindByG_T(groupId, type);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int type, int start, int end) {
        return this.layoutPageTemplateCollectionPersistence.filterFindByG_T(groupId, type, start, end);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int type, int start, int end, OrderByComparator<LayoutPageTemplateCollection> orderByComparator) {
        return this.layoutPageTemplateCollectionPersistence.filterFindByG_T(groupId, type, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, long layoutPageTemplateCollectionId) {
        return this.layoutPageTemplateCollectionPersistence.filterFindByG_P(groupId, layoutPageTemplateCollectionId);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, String name, int type, int start, int end, OrderByComparator<LayoutPageTemplateCollection> orderByComparator) {
        return this.layoutPageTemplateCollectionPersistence.filterFindByG_LikeN_T(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], type, start, end, orderByComparator);
    }

    public int getLayoutPageTemplateCollectionsCount(long groupId, int type) {
        return this.layoutPageTemplateCollectionPersistence.filterCountByG_T(groupId, type);
    }

    public int getLayoutPageTemplateCollectionsCount(long groupId, String name, int type) {
        return this.layoutPageTemplateCollectionPersistence.filterCountByG_LikeN_T(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], type);
    }

    public LayoutPageTemplateCollection moveLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, long targetLayoutPageTemplateCollectionId) throws PortalException {
        this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), layoutPageTemplateCollectionId, "UPDATE");
        return this.layoutPageTemplateCollectionLocalService.moveLayoutPageTemplateCollection(layoutPageTemplateCollectionId, targetLayoutPageTemplateCollectionId);
    }

    public LayoutPageTemplateCollection updateLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, String name) throws PortalException {
        this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), layoutPageTemplateCollectionId, "UPDATE");
        return this.layoutPageTemplateCollectionLocalService.updateLayoutPageTemplateCollection(layoutPageTemplateCollectionId, name);
    }

    public LayoutPageTemplateCollection updateLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, String name, String description) throws PortalException {
        this._layoutPageTemplateCollectionModelResourcePermission.check(this.getPermissionChecker(), layoutPageTemplateCollectionId, "UPDATE");
        return this.layoutPageTemplateCollectionLocalService.updateLayoutPageTemplateCollection(layoutPageTemplateCollectionId, name, description);
    }
}

