/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.layout.page.template.exception.DuplicateLayoutPageTemplateCollectionException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateCollectionNameException;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateCollectionLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateCollection"}, service={AopService.class})
public class LayoutPageTemplateCollectionLocalServiceImpl
extends LayoutPageTemplateCollectionLocalServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private Language _language;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public LayoutPageTemplateCollection addLayoutPageTemplateCollection(String externalReferenceCode, long userId, long groupId, long parentLayoutPageTemplateCollectionId, String name, String description, int type, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validate(groupId, name, parentLayoutPageTemplateCollectionId, type);
        long layoutPageTemplateId = this.counterLocalService.increment();
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.create(layoutPageTemplateId);
        layoutPageTemplateCollection.setUuid(serviceContext.getUuid());
        layoutPageTemplateCollection.setExternalReferenceCode(externalReferenceCode);
        layoutPageTemplateCollection.setGroupId(groupId);
        layoutPageTemplateCollection.setCompanyId(user.getCompanyId());
        layoutPageTemplateCollection.setUserId(user.getUserId());
        layoutPageTemplateCollection.setUserName(user.getFullName());
        layoutPageTemplateCollection.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateCollection.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateCollection.setParentLayoutPageTemplateCollectionId(parentLayoutPageTemplateCollectionId);
        layoutPageTemplateCollection.setLayoutPageTemplateCollectionKey(this._generateLayoutPageTemplateCollectionKey(groupId, name, type));
        layoutPageTemplateCollection.setName(name);
        layoutPageTemplateCollection.setDescription(description);
        layoutPageTemplateCollection.setType(type);
        layoutPageTemplateCollection = (LayoutPageTemplateCollection)this.layoutPageTemplateCollectionPersistence.update((BaseModel)layoutPageTemplateCollection);
        this._resourceLocalService.addModelResources((AuditedModel)layoutPageTemplateCollection, serviceContext);
        return layoutPageTemplateCollection;
    }

    public LayoutPageTemplateCollection copyLayoutPageTemplateCollection(long userId, long groupId, long sourceLayoutPageTemplateCollectionId, long layoutParentPageTemplateCollectionId, boolean copyPermissions, ServiceContext serviceContext) throws Exception {
        LayoutPageTemplateCollection sourceLayoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.findByPrimaryKey(sourceLayoutPageTemplateCollectionId);
        LayoutPageTemplateCollection targetLayoutPageTemplateCollection = this.addLayoutPageTemplateCollection(null, userId, sourceLayoutPageTemplateCollection.getGroupId(), layoutParentPageTemplateCollectionId, this.getUniqueLayoutPageTemplateCollectionName(groupId, layoutParentPageTemplateCollectionId, sourceLayoutPageTemplateCollection.getName(), sourceLayoutPageTemplateCollection.getType()), sourceLayoutPageTemplateCollection.getDescription(), sourceLayoutPageTemplateCollection.getType(), serviceContext);
        if (copyPermissions) {
            this._resourceLocalService.deleteResource(targetLayoutPageTemplateCollection.getCompanyId(), LayoutPageTemplateCollection.class.getName(), 4, targetLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
            this._resourceLocalService.copyModelResources(sourceLayoutPageTemplateCollection.getCompanyId(), LayoutPageTemplateCollection.class.getName(), sourceLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), targetLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        }
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntries(sourceLayoutPageTemplateCollection.getGroupId(), sourceLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            this._layoutPageTemplateEntryLocalService.copyLayoutPageTemplateEntry(userId, groupId, targetLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), copyPermissions, serviceContext);
        }
        List<LayoutPageTemplateCollection> layoutPageTemplateCollections = this.getLayoutPageTemplateCollections(sourceLayoutPageTemplateCollection.getGroupId(), sourceLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        for (LayoutPageTemplateCollection layoutPageTemplateCollection : layoutPageTemplateCollections) {
            this.copyLayoutPageTemplateCollection(userId, groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), targetLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), copyPermissions, serviceContext);
        }
        return targetLayoutPageTemplateCollection;
    }

    @Override
    @SystemEvent(type=1)
    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(LayoutPageTemplateCollection layoutPageTemplateCollection) throws PortalException {
        this.layoutPageTemplateCollectionPersistence.remove((BaseModel)layoutPageTemplateCollection);
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-189856")) {
            List layoutPageTemplateCollections = this.layoutPageTemplateCollectionPersistence.findByG_P(layoutPageTemplateCollection.getGroupId(), layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
            for (LayoutPageTemplateCollection curLayoutPageTemplateCollection : layoutPageTemplateCollections) {
                this.layoutPageTemplateCollectionLocalService.deleteLayoutPageTemplateCollection(curLayoutPageTemplateCollection);
            }
        }
        this._resourceLocalService.deleteResource(layoutPageTemplateCollection.getCompanyId(), LayoutPageTemplateCollection.class.getName(), 4, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntries(layoutPageTemplateCollection.getGroupId(), layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            this._layoutPageTemplateEntryLocalService.deleteLayoutPageTemplateEntry(layoutPageTemplateEntry);
        }
        return layoutPageTemplateCollection;
    }

    @Override
    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(long layoutPageTemplateCollectionId) throws PortalException {
        return this.deleteLayoutPageTemplateCollection(this.getLayoutPageTemplateCollection(layoutPageTemplateCollectionId));
    }

    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(String externalReferenceCode, long groupId) throws PortalException {
        return this.deleteLayoutPageTemplateCollection(this.getLayoutPageTemplateCollectionByExternalReferenceCode(externalReferenceCode, groupId));
    }

    @Override
    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long layoutPageTemplateCollectionId) {
        return this.layoutPageTemplateCollectionPersistence.fetchByPrimaryKey(layoutPageTemplateCollectionId);
    }

    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long groupId, String layoutPageTemplateCollectionKey, int type) {
        return this.layoutPageTemplateCollectionPersistence.fetchByG_LPTCK_T(groupId, layoutPageTemplateCollectionKey, type);
    }

    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long groupId, String name, long parentLayoutPageTemplateCollectionId, int type) {
        return this.layoutPageTemplateCollectionPersistence.fetchByG_P_N_T(groupId, parentLayoutPageTemplateCollectionId, name, type);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId) {
        return this.layoutPageTemplateCollectionPersistence.findByGroupId(groupId);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int type, int start, int end) {
        return this.layoutPageTemplateCollectionPersistence.findByG_T(groupId, type, start, end);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int type, int start, int end, OrderByComparator<LayoutPageTemplateCollection> orderByComparator) {
        return this.layoutPageTemplateCollectionPersistence.findByG_T(groupId, type, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, long layoutPageTemplateCollectionId) {
        return this.layoutPageTemplateCollectionPersistence.findByG_P(groupId, layoutPageTemplateCollectionId);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, long layoutPageTemplateCollectionId, int type) {
        return this.layoutPageTemplateCollectionPersistence.findByG_P_T(groupId, layoutPageTemplateCollectionId, type);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, String name, int type, int start, int end, OrderByComparator<LayoutPageTemplateCollection> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateCollectionPersistence.findByG_T(groupId, type, start, end, orderByComparator);
        }
        return this.layoutPageTemplateCollectionPersistence.findByG_LikeN_T(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], type, start, end, orderByComparator);
    }

    public int getLayoutPageTemplateCollectionsCount(long groupId, int type) {
        return this.layoutPageTemplateCollectionPersistence.countByG_T(groupId, type);
    }

    public int getLayoutPageTemplateCollectionsCount(long groupId, String name, int type) {
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateCollectionPersistence.countByG_T(groupId, type);
        }
        return this.layoutPageTemplateCollectionPersistence.countByG_LikeN_T(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], type);
    }

    public String getUniqueLayoutPageTemplateCollectionName(long groupId, long layoutPageTemplateCollectionId, String sourceName, int type) {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_P_N_T(groupId, layoutPageTemplateCollectionId, sourceName, type);
        if (layoutPageTemplateCollection == null) {
            return sourceName;
        }
        String copy = this._language.get(LocaleUtil.getSiteDefault(), "copy");
        String name = StringUtil.appendParentheticalSuffix((String)sourceName, (String)copy);
        int i = 1;
        while ((layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_P_N_T(groupId, layoutPageTemplateCollectionId, name, type)) != null) {
            name = StringUtil.appendParentheticalSuffix((String)sourceName, (String)(copy + " " + i));
            ++i;
        }
        return name;
    }

    public LayoutPageTemplateCollection moveLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, long parentLayoutPageTemplateCollectionId) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionLocalService.getLayoutPageTemplateCollection(layoutPageTemplateCollectionId);
        if (parentLayoutPageTemplateCollectionId == layoutPageTemplateCollection.getLayoutPageTemplateCollectionId() || parentLayoutPageTemplateCollectionId == layoutPageTemplateCollection.getParentLayoutPageTemplateCollectionId()) {
            return layoutPageTemplateCollection;
        }
        layoutPageTemplateCollection.setParentLayoutPageTemplateCollectionId(parentLayoutPageTemplateCollectionId);
        return this.updateLayoutPageTemplateCollection(layoutPageTemplateCollection);
    }

    public LayoutPageTemplateCollection updateLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, String name) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.findByPrimaryKey(layoutPageTemplateCollectionId);
        if (!Objects.equals(layoutPageTemplateCollection.getName(), name)) {
            this._validate(layoutPageTemplateCollection.getGroupId(), name, layoutPageTemplateCollection.getParentLayoutPageTemplateCollectionId(), layoutPageTemplateCollection.getType());
        }
        layoutPageTemplateCollection.setLayoutPageTemplateCollectionKey(this._generateLayoutPageTemplateCollectionKey(layoutPageTemplateCollection.getGroupId(), name, layoutPageTemplateCollection.getType()));
        layoutPageTemplateCollection.setName(name);
        return (LayoutPageTemplateCollection)this.layoutPageTemplateCollectionPersistence.update((BaseModel)layoutPageTemplateCollection);
    }

    public LayoutPageTemplateCollection updateLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, String name, String description) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.findByPrimaryKey(layoutPageTemplateCollectionId);
        if (!Objects.equals(layoutPageTemplateCollection.getName(), name)) {
            this._validate(layoutPageTemplateCollection.getGroupId(), name, layoutPageTemplateCollection.getParentLayoutPageTemplateCollectionId(), layoutPageTemplateCollection.getType());
        }
        layoutPageTemplateCollection.setModifiedDate(new Date());
        layoutPageTemplateCollection.setLayoutPageTemplateCollectionKey(this._generateLayoutPageTemplateCollectionKey(layoutPageTemplateCollection.getGroupId(), name, layoutPageTemplateCollection.getType()));
        layoutPageTemplateCollection.setName(name);
        layoutPageTemplateCollection.setDescription(description);
        return (LayoutPageTemplateCollection)this.layoutPageTemplateCollectionPersistence.update((BaseModel)layoutPageTemplateCollection);
    }

    private String _generateLayoutPageTemplateCollectionKey(long groupId, String name, int type) {
        String layoutPageTemplateCollectionKey;
        String curLayoutPageTemplateCollectionKey = layoutPageTemplateCollectionKey = StringUtil.replace((String)StringUtil.toLowerCase((String)name.trim()), (char[])new char[]{'/', ' '}, (char[])new char[]{'-', '-'});
        int count = 0;
        LayoutPageTemplateCollection layoutPageTemplateCollection;
        while ((layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_LPTCK_T(groupId, curLayoutPageTemplateCollectionKey, type)) != null) {
            curLayoutPageTemplateCollectionKey = curLayoutPageTemplateCollectionKey + '-' + count++;
        }
        return curLayoutPageTemplateCollectionKey;
    }

    private void _validate(long groupId, String name, long parentLayoutPageTemplateCollection, int type) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutPageTemplateCollectionNameException("Name must not be null");
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new LayoutPageTemplateCollectionNameException("Maximum length of name exceeded " + nameMaxLength);
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_P_N_T(groupId, parentLayoutPageTemplateCollection, name, type);
        if (layoutPageTemplateCollection != null) {
            throw new DuplicateLayoutPageTemplateCollectionException(name);
        }
    }
}

