/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_3_1;

import com.liferay.layout.page.template.internal.validator.LayoutPageTemplateEntryValidator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LayoutPageTemplateEntryUpgradeProcess
extends UpgradeProcess {
    private final Map<String, Set<String>> _columnUniqueValues = HashMapBuilder.put((Object)"layoutPageTemplateEntryKey", new HashSet()).put((Object)"name", new HashSet()).build();
    private final LayoutPrototypeLocalService _layoutPrototypeLocalService;

    public LayoutPageTemplateEntryUpgradeProcess(LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeLayoutPageTemplateEntryNameAndKey();
    }

    private String _generateValidString(String value) {
        StringBundler sb = new StringBundler(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (LayoutPageTemplateEntryValidator.isBlacklistedChar(c)) {
                sb.append('-');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String _getUniqueColumnValue(String value, String column) {
        Set<String> uniqueValues = this._columnUniqueValues.get(column);
        int maxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntryUpgradeProcess.class.getName(), (String)column);
        String currentValue = value;
        int i = 1;
        while (uniqueValues.contains(currentValue)) {
            String suffix = "-" + i;
            String prefix = value.substring(0, Math.min(maxLength - suffix.length(), value.length()));
            currentValue = prefix + suffix;
            ++i;
        }
        uniqueValues.remove(value);
        uniqueValues.add(currentValue);
        return currentValue;
    }

    private void _loadDistinctKeysAndNames() throws Exception {
        Set<String> names = this._columnUniqueValues.get("name");
        Set<String> layoutPageTemplateEntryKeys = this._columnUniqueValues.get("layoutPageTemplateEntryKey");
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select distinct layoutPageTemplateEntryKey, name from LayoutPageTemplateEntry");){
            while (resultSet.next()) {
                names.add(resultSet.getString("name"));
                layoutPageTemplateEntryKeys.add(resultSet.getString("layoutPageTemplateEntryKey"));
            }
        }
    }

    private void _updateLayoutPrototypeName(long layoutPrototypeId, String oldName, String newName) throws PortalException {
        Locale locale;
        LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.fetchLayoutPrototype(layoutPrototypeId);
        if (layoutPrototype == null) {
            return;
        }
        Map nameMap = layoutPrototype.getNameMap();
        String defaultName = (String)nameMap.get(locale = LocaleUtil.fromLanguageId((String)layoutPrototype.getDefaultLanguageId()));
        if (!StringUtil.equals((String)defaultName, (String)oldName)) {
            return;
        }
        nameMap.put(locale, StringUtil.replaceFirst((String)defaultName, (String)oldName, (String)newName));
        this._layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototypeId, nameMap, layoutPrototype.getDescriptionMap(), layoutPrototype.isActive(), new ServiceContext());
    }

    private void _upgradeLayoutPageTemplateEntryNameAndKey() throws Exception {
        this._loadDistinctKeysAndNames();
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select layoutPageTemplateEntryId, layoutPageTemplateEntryKey, layoutPrototypeId, name from LayoutPageTemplateEntry");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutPageTemplateEntry set layoutPageTemplateEntryKey = ?, name = ? where layoutPageTemplateEntryId = ?");){
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if (LayoutPageTemplateEntryValidator.isValidName(name)) continue;
                long layoutPageTemplateEntryId = resultSet.getLong("layoutPageTemplateEntryId");
                String layoutPageTemplateEntryKey = this._generateValidString(resultSet.getString("layoutPageTemplateEntryKey"));
                preparedStatement.setString(1, this._getUniqueColumnValue(layoutPageTemplateEntryKey, "layoutPageTemplateEntryKey"));
                String newName = this._generateValidString(name);
                preparedStatement.setString(2, this._getUniqueColumnValue(newName, "name"));
                preparedStatement.setLong(3, layoutPageTemplateEntryId);
                long layoutPrototypeId = resultSet.getLong("layoutPrototypeId");
                this._updateLayoutPrototypeName(layoutPrototypeId, name, newName);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

