/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v5_1_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class LayoutPageTemplateStructureUpgradeProcess
extends UpgradeProcess {
    private final LayoutLocalService _layoutLocalService;

    public LayoutPageTemplateStructureUpgradeProcess(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._deleteOrphanLayoutPageTemplateStructures();
        this._processLayoutPageTemplateStructuresOfWidgetLayouts();
    }

    private void _deleteOrphanLayoutPageTemplateStructures() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement("select layoutPageTemplateStructureId from LayoutPageTemplateStructure where classPK not in (select plid from Layout)");
             PreparedStatement deletePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from LayoutPageTemplateStructureRel where layoutPageTemplateStructureId = ?");){
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
                while (resultSet.next()) {
                    deletePreparedStatement.setLong(1, resultSet.getLong("layoutPageTemplateStructureId"));
                    deletePreparedStatement.addBatch();
                }
            }
            deletePreparedStatement.executeBatch();
        }
        this.runSQL("delete from LayoutPageTemplateStructure where classPK not in (select plid from Layout)");
    }

    private void _processLayoutPageTemplateStructuresOfWidgetLayouts() throws Exception {
        ArrayList<Long> plids = new ArrayList<Long>();
        PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select LayoutPageTemplateStructure.ctCollectionId, ", "LayoutPageTemplateStructure.", "layoutPageTemplateStructureId, ", "LayoutPageTemplateStructure.classPK from ", "LayoutPageTemplateStructure inner join Layout on ", "LayoutPageTemplateStructure.ctCollectionId = ", "Layout.ctCollectionId and ", "LayoutPageTemplateStructure.classPK = Layout.plid and ", "Layout.type_ = ?"}));
        Object object = null;
        try (PreparedStatement preparedStatement22 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"delete from LayoutPageTemplateStructure where ctCollectionId = ? and layoutPageTemplateStructureId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from LayoutPageTemplateStructureRel where ctCollectionId = ? and layoutPageTemplateStructureId = ?");){
            preparedStatement1.setString(1, "portlet");
            ResultSet resultSet = preparedStatement1.executeQuery();
            while (resultSet.next()) {
                plids.add(resultSet.getLong(3));
                long ctCollectionId = resultSet.getLong(1);
                preparedStatement22.setLong(1, ctCollectionId);
                long layoutPageTemplateStructureId = resultSet.getLong(2);
                preparedStatement22.setLong(2, layoutPageTemplateStructureId);
                preparedStatement22.addBatch();
                preparedStatement3.setLong(1, ctCollectionId);
                preparedStatement3.setLong(2, layoutPageTemplateStructureId);
                preparedStatement3.addBatch();
            }
            preparedStatement22.executeBatch();
            preparedStatement3.executeBatch();
        }
        catch (Throwable preparedStatement22) {
            object = preparedStatement22;
            throw preparedStatement22;
        }
        finally {
            if (preparedStatement1 != null) {
                if (object != null) {
                    try {
                        preparedStatement1.close();
                    }
                    catch (Throwable preparedStatement22) {
                        ((Throwable)object).addSuppressed(preparedStatement22);
                    }
                } else {
                    preparedStatement1.close();
                }
            }
        }
        ServiceContext serviceContext = new ServiceContext();
        object = plids.iterator();
        while (object.hasNext()) {
            long plid = (Long)object.next();
            Layout layout = this._layoutLocalService.fetchLayout(plid);
            if (layout.getStatus() != 2) continue;
            this._layoutLocalService.updateStatus(layout.getUserId(), plid, 0, serviceContext);
        }
    }
}

