/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_2_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class LayoutPageTemplateEntryUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this._upgradeLayoutPageTemplateEntryKey();
    }

    protected void upgradeSchema() throws Exception {
        this.alterTableAddColumn("LayoutPageTemplateEntry", "layoutPageTemplateEntryKey", "VARCHAR(75)");
    }

    private String _generateLayoutPageTemplateEntryKey(String name) {
        String layoutPageTemplateEntryKey = StringUtil.toLowerCase((String)name.trim());
        return StringUtil.replace((String)layoutPageTemplateEntryKey, (char)' ', (char)'-');
    }

    private void _upgradeLayoutPageTemplateEntryKey() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select layoutPageTemplateEntryId, name from LayoutPageTemplateEntry");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutPageTemplateEntry set layoutPageTemplateEntryKey = ? where layoutPageTemplateEntryId = ?");){
            while (resultSet.next()) {
                long layoutPageTemplateEntryId = resultSet.getLong("layoutPageTemplateEntryId");
                String name = resultSet.getString("name");
                preparedStatement.setString(1, this._generateLayoutPageTemplateEntryKey(name));
                preparedStatement.setLong(2, layoutPageTemplateEntryId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

