/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.info.item.provider;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.DisplayPageInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.URLInfoFieldType;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.ERCInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.localized.bundle.FunctionInfoLocalizedValue;
import com.liferay.info.type.WebURL;
import com.liferay.layout.page.template.info.item.provider.DisplayPageInfoItemFieldSetProvider;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DisplayPageInfoItemFieldSetProvider.class})
public class DisplayPageInfoItemFieldSetProviderImpl
implements DisplayPageInfoItemFieldSetProvider {
    private static final Log _log = LogFactoryUtil.getLog(DisplayPageInfoItemFieldSetProviderImpl.class);
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;

    public InfoFieldSet getInfoFieldSet(String itemClassName, String infoItemFormVariationKey, String namespace, long scopeGroupId) {
        return InfoFieldSet.builder().infoFieldSetEntries(this._getInfoFieldSetEntries(itemClassName, infoItemFormVariationKey, namespace, scopeGroupId)).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"display-page")).name("display-page").build();
    }

    public List<InfoFieldValue<Object>> getInfoFieldValues(InfoItemReference infoItemReference, String infoItemFormVariationKey, String namespace, Object object, ThemeDisplay themeDisplay) throws Exception {
        if (themeDisplay == null) {
            return Collections.emptyList();
        }
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        infoFieldValues.add(new InfoFieldValue(InfoField.builder((String)namespace).infoFieldType((InfoFieldType)URLInfoFieldType.INSTANCE).name("displayPageURL").labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"default")).build(), (Object)this._getDefaultDisplayPageURL(infoItemReference, object, themeDisplay)));
        Group group = themeDisplay.getScopeGroup();
        String groupFriendlyURL = this._portal.getGroupFriendlyURL(group.getPublicLayoutSet(), themeDisplay, false, false);
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(themeDisplay.getScopeGroupId(), this._portal.getClassNameId(infoItemReference.getClassName()), GetterUtil.getLong((String)infoItemFormVariationKey), 1);
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            Layout layout = this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
            infoFieldValues.add(this._getInfoFieldValue(groupFriendlyURL, String.valueOf(layoutPageTemplateEntry.getLayoutPageTemplateEntryId()), infoItemReference, layout, layoutPageTemplateEntry, themeDisplay));
            infoFieldValues.add(this._getInfoFieldValue(groupFriendlyURL, layoutPageTemplateEntry.getLayoutPageTemplateEntryKey(), infoItemReference, layout, layoutPageTemplateEntry, themeDisplay));
        }
        return infoFieldValues;
    }

    private String _getDefaultDisplayPageURL(InfoItemReference infoItemReference, Object object, ThemeDisplay themeDisplay) throws Exception {
        block6: {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)infoItemReference.getClassName());
            if (assetRendererFactory == null) {
                return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(infoItemReference, object, themeDisplay);
            }
            try {
                AssetRenderer assetRenderer = null;
                if (infoItemReference.getInfoItemIdentifier() instanceof ClassPKInfoItemIdentifier) {
                    ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
                    assetRenderer = assetRendererFactory.getAssetRenderer(classPKInfoItemIdentifier.getClassPK());
                }
                if (assetRenderer == null) {
                    return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(infoItemReference, object, themeDisplay);
                }
                String viewInContextURL = assetRenderer.getURLViewInContext(themeDisplay, "");
                if (Validator.isNotNull((String)viewInContextURL)) {
                    return viewInContextURL;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)exception);
            }
        }
        return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(infoItemReference, object, themeDisplay);
    }

    private InfoField<InfoFieldType> _getDefaultDisplayPageURLInfoField(String namespace) {
        return InfoField.builder((String)namespace).infoFieldType(this._getDisplayPageInfoFieldType()).name("displayPageURL").labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"default")).build();
    }

    private InfoFieldType _getDisplayPageInfoFieldType() {
        return DisplayPageInfoFieldType.INSTANCE;
    }

    private List<InfoFieldSetEntry> _getInfoFieldSetEntries(String itemClassName, String infoItemFormVariationKey, String namespace, long scopeGroupId) {
        ArrayList<InfoFieldSetEntry> infoFieldSetEntries = new ArrayList<InfoFieldSetEntry>();
        infoFieldSetEntries.add((InfoFieldSetEntry)this._getDefaultDisplayPageURLInfoField(namespace));
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(scopeGroupId, this._portal.getClassNameId(itemClassName), GetterUtil.getLong((String)infoItemFormVariationKey), 1, 0);
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            infoFieldSetEntries.add((InfoFieldSetEntry)InfoField.builder().infoFieldType(this._getDisplayPageInfoFieldType()).uniqueId(this._getUniqueId(String.valueOf(layoutPageTemplateEntry.getLayoutPageTemplateEntryId()))).name(layoutPageTemplateEntry.getName()).labelInfoLocalizedValue(InfoLocalizedValue.singleValue((String)layoutPageTemplateEntry.getName())).build());
        }
        return infoFieldSetEntries;
    }

    private InfoFieldValue<Object> _getInfoFieldValue(String groupFriendlyURL, String id, InfoItemReference infoItemReference, Layout layout, LayoutPageTemplateEntry layoutPageTemplateEntry, ThemeDisplay themeDisplay) {
        return new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)URLInfoFieldType.INSTANCE).uniqueId(this._getUniqueId(id)).name(layoutPageTemplateEntry.getName()).attribute(URLInfoFieldType.NOFOLLOW, (Object)Boolean.TRUE).labelInfoLocalizedValue(InfoLocalizedValue.singleValue((String)layoutPageTemplateEntry.getName())).build(), (Object)new FunctionInfoLocalizedValue(locale -> {
            WebURL webURL = new WebURL(this._portal.addPreservedParameters(themeDisplay, StringBundler.concat((Object[])new Object[]{groupFriendlyURL + this._getURLSeparator(), layout.getFriendlyURL(locale), "/", this._portal.getClassNameId(infoItemReference.getClassName()), "/", this._getInfoItemIdentifier(infoItemReference)})));
            webURL.setNofollow(Boolean.valueOf(true));
            return webURL;
        }));
    }

    private String _getInfoItemIdentifier(InfoItemReference infoItemReference) {
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (infoItemIdentifier instanceof ClassPKInfoItemIdentifier) {
            ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
            return String.valueOf(classPKInfoItemIdentifier.getClassPK());
        }
        if (infoItemIdentifier instanceof ERCInfoItemIdentifier) {
            ERCInfoItemIdentifier ercInfoItemIdentifier = (ERCInfoItemIdentifier)infoItemIdentifier;
            return ercInfoItemIdentifier.getExternalReferenceCode();
        }
        return "";
    }

    private String _getUniqueId(String id) {
        return LayoutPageTemplateEntry.class.getSimpleName() + "_" + id;
    }

    private String _getURLSeparator() {
        FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolverByDefaultURLSeparator((String)"/e/");
        if (friendlyURLResolver != null) {
            String urlSeparator = friendlyURLResolver.getURLSeparator();
            return urlSeparator.substring(0, urlSeparator.length() - 1);
        }
        return "/e";
    }
}

