/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v2_1_0;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.internal.upgrade.v2_1_0.util.LayoutPageTemplateEntryTable;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UpgradeLayout
extends UpgradeProcess {
    private final FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private final LayoutLocalService _layoutLocalService;
    private final LayoutPrototypeLocalService _layoutPrototypeLocalService;

    public UpgradeLayout(FragmentEntryLinkLocalService fragmentEntryLinkLocalService, LayoutLocalService layoutLocalService, LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._fragmentEntryLinkLocalService = fragmentEntryLinkLocalService;
        this._layoutLocalService = layoutLocalService;
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.upgradeLayout();
    }

    protected void upgradeLayout() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("select layoutPageTemplateEntryId, groupId, companyId, ");
        sb.append("userId, name, type_, layoutPrototypeId, companyId from ");
        sb.append("LayoutPageTemplateEntry where plid is null or plid = 0");
        ServiceContext serviceContext = new ServiceContext();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery(sb.toString());
             PreparedStatement ps = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update LayoutPageTemplateEntry set plid = ? where layoutPageTemplateEntryId = ?"));){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                long groupId = rs.getLong("groupId");
                String name = rs.getString("name");
                int type = rs.getInt("type_");
                long layoutPrototypeId = rs.getLong("layoutPrototypeId");
                long plid = this._getPlid(companyId, userId, groupId, name, type, layoutPrototypeId, serviceContext);
                ps.setLong(1, plid);
                long layoutPageTemplateEntryId = rs.getLong("layoutPageTemplateEntryId");
                ps.setLong(2, layoutPageTemplateEntryId);
                ps.addBatch();
                List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(groupId, PortalUtil.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntryId);
                Layout draftLayout = this._layoutLocalService.fetchDraftLayout(plid);
                for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
                    fragmentEntryLink.setClassNameId(PortalUtil.getClassNameId(Layout.class));
                    fragmentEntryLink.setClassPK(plid);
                    fragmentEntryLink.setPlid(plid);
                    this._fragmentEntryLinkLocalService.updateFragmentEntryLink(fragmentEntryLink);
                    this._fragmentEntryLinkLocalService.addFragmentEntryLink(draftLayout.getUserId(), draftLayout.getGroupId(), 0L, fragmentEntryLink.getFragmentEntryId(), 0L, draftLayout.getPlid(), fragmentEntryLink.getCss(), fragmentEntryLink.getHtml(), fragmentEntryLink.getJs(), fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), "", fragmentEntryLink.getPosition(), null, serviceContext);
                }
            }
            ps.executeBatch();
        }
    }

    protected void upgradeSchema() throws Exception {
        if (!this.hasColumn("LayoutPageTemplateEntry", "plid")) {
            this.alter(LayoutPageTemplateEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "plid", "LONG")});
        }
    }

    private long _getPlid(long companyId, long userId, long groupId, String name, int type, long layoutPrototypeId, ServiceContext serviceContext) throws Exception {
        if (type == 2 && layoutPrototypeId > 0L) {
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(layoutPrototypeId);
            Layout layout = layoutPrototype.getLayout();
            return layout.getPlid();
        }
        boolean privateLayout = false;
        String layoutType = "asset_display";
        if (type == 0) {
            layoutType = "content";
            privateLayout = true;
        }
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = this._layoutLocalService.addLayout(PortalUtil.getValidUserId((long)companyId, (long)userId), groupId, privateLayout, 0L, titleMap, titleMap, null, null, null, layoutType, "", true, true, new HashMap(), serviceContext);
        this._layoutLocalService.addLayout(layout.getUserId(), layout.getGroupId(), privateLayout, layout.getParentLayoutId(), PortalUtil.getClassNameId(Layout.class), layout.getPlid(), layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getType(), "", true, true, Collections.emptyMap(), serviceContext);
        return layout.getPlid();
    }
}

