/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.validator;

import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryNameException;

public class LayoutPageTemplateEntryValidator {
    private static final char[] _BLACKLIST_CHAR = new char[]{';', '/', '?', ':', '@', '=', '&', '\"', '<', '>', '#', '%', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};

    public static boolean isBlacklistedChar(char c) {
        for (char blacklistedChar : _BLACKLIST_CHAR) {
            if (c != blacklistedChar) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidName(String layoutPageTemplateEntryName) {
        for (char c : _BLACKLIST_CHAR) {
            if (layoutPageTemplateEntryName.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    public static void validateNameCharacters(String layoutPageTemplateEntryName) throws LayoutPageTemplateEntryNameException {
        for (char c : _BLACKLIST_CHAR) {
            if (layoutPageTemplateEntryName.indexOf(c) < 0) continue;
            throw new LayoutPageTemplateEntryNameException.MustNotContainInvalidCharacters(c);
        }
    }
}

