/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_1_3;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class LayoutPageTemplateStructureUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._deleteOrphanLayoutPageTemplateStructures();
        this._processLayoutPageTemplateStructuresOfWidgetLayouts();
    }

    private void _deleteOrphanLayoutPageTemplateStructures() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement("select layoutPageTemplateStructureId from LayoutPageTemplateStructure where classPK not in (select plid from Layout)");
             PreparedStatement deletePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from LayoutPageTemplateStructureRel where layoutPageTemplateStructureId = ?");){
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
                while (resultSet.next()) {
                    deletePreparedStatement.setLong(1, resultSet.getLong("layoutPageTemplateStructureId"));
                    deletePreparedStatement.addBatch();
                }
            }
            deletePreparedStatement.executeBatch();
        }
        this.runSQL("delete from LayoutPageTemplateStructure where classPK not in (select plid from Layout)");
    }

    private void _processLayoutPageTemplateStructuresOfWidgetLayouts() throws Exception {
        ArrayList<Long> plids = new ArrayList<Long>();
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform((String)"select layoutPageTemplateStructureId, classPK from LayoutPageTemplateStructure where classPK in (select plid from Layout where type_ = ?)"));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("delete from LayoutPageTemplateStructure where classPK = ?"));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from LayoutPageTemplateStructureRel where layoutPageTemplateStructureId = ?");){
            preparedStatement1.setString(1, "portlet");
            ResultSet resultSet = preparedStatement1.executeQuery();
            while (resultSet.next()) {
                long classPK = resultSet.getLong("classPK");
                plids.add(classPK);
                preparedStatement2.setLong(1, classPK);
                preparedStatement2.addBatch();
                preparedStatement3.setLong(1, resultSet.getLong("layoutPageTemplateStructureId"));
                preparedStatement3.addBatch();
            }
            preparedStatement2.executeBatch();
            preparedStatement3.executeBatch();
        }
    }
}

