/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_1_1;

import com.liferay.layout.page.template.internal.validator.LayoutPageTemplateEntryValidator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UpgradeLayoutPageTemplateEntry
extends UpgradeProcess {
    private final Map<String, Set<String>> _columnUniqueValues = HashMapBuilder.put((Object)"layoutPageTemplateEntryKey", new HashSet()).put((Object)"name", new HashSet()).build();
    private final LayoutPrototypeLocalService _layoutPrototypeLocalService;

    public UpgradeLayoutPageTemplateEntry(LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeLayoutPageTemplateEntryName();
    }

    private String _generateValidString(String value) {
        StringBundler sb = new StringBundler(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (LayoutPageTemplateEntryValidator.isBlacklistedChar(c)) {
                sb.append('-');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String _getUniqueColumnValue(String value, String column) {
        Set<String> uniqueValues = this._columnUniqueValues.get(column);
        int maxLength = ModelHintsUtil.getMaxLength((String)UpgradeLayoutPageTemplateEntry.class.getName(), (String)column);
        String currentValue = value;
        int i = 1;
        while (uniqueValues.contains(currentValue)) {
            String suffix = "-" + i;
            String prefix = value.substring(0, Math.min(maxLength - suffix.length(), value.length()));
            currentValue = prefix + suffix;
            ++i;
        }
        uniqueValues.remove(value);
        uniqueValues.add(currentValue);
        return currentValue;
    }

    private void _loadDistinctNames() throws Exception {
        Set<String> names = this._columnUniqueValues.get("name");
        try (Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery("select distinct name from LayoutPageTemplateEntry");){
            while (rs.next()) {
                names.add(rs.getString("name"));
            }
        }
    }

    private void _updateLayoutPrototypeName(long layoutPrototypeId, String oldName, String newName) throws PortalException {
        Locale locale;
        LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(layoutPrototypeId);
        Map nameMap = layoutPrototype.getNameMap();
        String defaultName = (String)nameMap.get(locale = LocaleUtil.fromLanguageId((String)layoutPrototype.getDefaultLanguageId()));
        if (!StringUtil.equals((String)defaultName, (String)oldName)) {
            return;
        }
        nameMap.put(locale, StringUtil.replaceFirst((String)defaultName, (String)oldName, (String)newName));
        this._layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototypeId, nameMap, layoutPrototype.getDescriptionMap(), layoutPrototype.isActive(), new ServiceContext());
    }

    private void _upgradeLayoutPageTemplateEntryName() throws Exception {
        this._loadDistinctNames();
        try (Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery("select layoutPageTemplateEntryId, layoutPrototypeId, name from LayoutPageTemplateEntry");
             PreparedStatement ps = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update LayoutPageTemplateEntry set name = ? where layoutPageTemplateEntryId = ?"));){
            while (rs.next()) {
                String name = rs.getString("name");
                if (LayoutPageTemplateEntryValidator.isValidName(name)) continue;
                long layoutPageTemplateEntryId = rs.getLong("layoutPageTemplateEntryId");
                String newName = this._generateValidString(name);
                ps.setString(1, this._getUniqueColumnValue(newName, "name"));
                ps.setLong(2, layoutPageTemplateEntryId);
                long layoutPrototypeId = rs.getLong("layoutPrototypeId");
                this._updateLayoutPrototypeName(layoutPrototypeId, name, newName);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }
}

