/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v1_2_0;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class UpgradeLayoutPageTemplateStructure
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeLayoutPageTemplateStructure.class);
    private final FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private final LayoutLocalService _layoutLocalService;

    public UpgradeLayoutPageTemplateStructure(FragmentEntryLinkLocalService fragmentEntryLinkLocalService, LayoutLocalService layoutLocalService) {
        this._fragmentEntryLinkLocalService = fragmentEntryLinkLocalService;
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.upgradeLayoutPageTemplates();
        this.upgradeLayouts();
    }

    protected void upgradeLayoutPageTemplates() throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)LayoutPageTemplateEntry.class.getName());
        StringBundler sb = new StringBundler(7);
        sb.append("select layoutPageTemplateEntryId, groupId, companyId, ");
        sb.append("userId, userName, createDate from LayoutPageTemplateEntry ");
        sb.append("where type_ in (");
        sb.append(0);
        sb.append(", ");
        sb.append(1);
        sb.append(")");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long layoutPageTemplateEntryId = rs.getLong("layoutPageTemplateEntryId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                this._updateLayoutPageTemplateStructure(groupId, companyId, userId, userName, createDate, classNameId, layoutPageTemplateEntryId);
            }
        }
    }

    protected void upgradeLayouts() throws PortalException {
        long classNameId = PortalUtil.getClassNameId((String)Layout.class.getName());
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"type", (Object)"content")));
        actionableDynamicQuery.setPerformActionMethod(layout -> {
            Date createDate = layout.getCreateDate();
            this._updateLayoutPageTemplateStructure(layout.getGroupId(), layout.getCompanyId(), layout.getUserId(), layout.getUserName(), new Timestamp(createDate.getTime()), classNameId, layout.getPlid());
        });
        actionableDynamicQuery.performActions();
    }

    protected void upgradeSchema() throws Exception {
        String template = StringUtil.read((InputStream)UpgradeLayoutPageTemplateStructure.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false, false);
    }

    private JSONObject _generateContentLayoutStructure(List<FragmentEntryLink> fragmentEntryLinks) {
        JSONArray structureJSONArray = JSONFactoryUtil.createJSONArray();
        for (int i = 0; i < fragmentEntryLinks.size(); ++i) {
            FragmentEntryLink fragmentEntryLink = fragmentEntryLinks.get(i);
            structureJSONArray.put(JSONUtil.put((String)"columns", (Object)JSONUtil.put((Object)JSONUtil.put((String)"columnId", (Object)String.valueOf(i)).put("fragmentEntryLinkIds", JSONUtil.put((Object)String.valueOf(fragmentEntryLink.getFragmentEntryLinkId()))).put("size", ""))).put("rowId", String.valueOf(i)).put("type", String.valueOf(0)));
        }
        JSONObject jsonObject = JSONUtil.put((String)"config", (Object)JSONFactoryUtil.createJSONObject()).put("nextColumnId", fragmentEntryLinks.size()).put("nextRowId", fragmentEntryLinks.size());
        if (!fragmentEntryLinks.isEmpty()) {
            jsonObject.put("nextRowId", String.valueOf(fragmentEntryLinks.size() - 1));
        }
        jsonObject.put("structure", structureJSONArray);
        return jsonObject;
    }

    private JSONObject _generateLayoutPageTemplateStructureData(long groupId, long classNameId, long classPK) {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(groupId, classNameId, classPK);
        return this._generateContentLayoutStructure(fragmentEntryLinks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateLayoutPageTemplateStructure(long groupId, long companyId, long userId, String userName, Timestamp createDate, long classNameId, long classPK) {
        JSONObject jsonObject = this._generateLayoutPageTemplateStructureData(groupId, classNameId, classPK);
        StringBundler sb = new StringBundler(4);
        sb.append("insert into LayoutPageTemplateStructure (uuid_, ");
        sb.append("layoutPageTemplateStructureId, groupId, companyId, ");
        sb.append("userId, userName, createDate, modifiedDate, classNameId, ");
        sb.append("classPK, data_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        String sql = sb.toString();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(sql);
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, this.increment());
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, createDate);
            ps.setLong(9, classNameId);
            ps.setLong(10, classPK);
            ps.setString(11, jsonObject.toString());
            ps.executeUpdate();
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)exception, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp(ps);
                    throw throwable;
                }
            }
            DataAccess.cleanUp((Statement)ps);
        }
        DataAccess.cleanUp((Statement)ps);
    }
}

