/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.launch.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.launch.model.LaunchSet;
import com.liferay.launch.service.LaunchSetLocalService;
import com.liferay.launch.service.persistence.LaunchSetPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class LaunchSetLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
LaunchSetLocalService {
    protected LaunchSetLocalService launchSetLocalService;
    @Reference
    protected LaunchSetPersistence launchSetPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(LaunchSetLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public LaunchSet addLaunchSet(LaunchSet launchSet) {
        launchSet.setNew(true);
        return (LaunchSet)this.launchSetPersistence.update((BaseModel)launchSet);
    }

    @Transactional(enabled=false)
    public LaunchSet createLaunchSet(long launchSetId) {
        return this.launchSetPersistence.create(launchSetId);
    }

    @Indexable(type=IndexableType.DELETE)
    public LaunchSet deleteLaunchSet(long launchSetId) throws PortalException {
        return this.launchSetPersistence.remove(launchSetId);
    }

    @Indexable(type=IndexableType.DELETE)
    public LaunchSet deleteLaunchSet(LaunchSet launchSet) {
        return (LaunchSet)this.launchSetPersistence.remove((BaseModel)launchSet);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.launchSetPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(LaunchSet.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.launchSetPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.launchSetPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.launchSetPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.launchSetPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.launchSetPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public LaunchSet fetchLaunchSet(long launchSetId) {
        return this.launchSetPersistence.fetchByPrimaryKey(launchSetId);
    }

    public LaunchSet fetchLaunchSetByUuidAndCompanyId(String uuid, long companyId) {
        return this.launchSetPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public LaunchSet fetchLaunchSetByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.launchSetPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public LaunchSet getLaunchSetByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.launchSetPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public LaunchSet getLaunchSet(long launchSetId) throws PortalException {
        return this.launchSetPersistence.findByPrimaryKey(launchSetId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.launchSetLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LaunchSet.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("launchSetId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.launchSetLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(LaunchSet.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("launchSetId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.launchSetLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LaunchSet.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("launchSetId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<LaunchSet>(){

            public void performAction(LaunchSet launchSet) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)launchSet);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)LaunchSet.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.launchSetPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement LaunchSetLocalServiceImpl#deleteLaunchSet(LaunchSet) to avoid orphaned data");
        }
        return this.launchSetLocalService.deleteLaunchSet((LaunchSet)persistedModel);
    }

    public BasePersistence<LaunchSet> getBasePersistence() {
        return this.launchSetPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.launchSetPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public LaunchSet getLaunchSetByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.launchSetPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<LaunchSet> getLaunchSets(int start, int end) {
        return this.launchSetPersistence.findAll(start, end);
    }

    public int getLaunchSetsCount() {
        return this.launchSetPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public LaunchSet updateLaunchSet(LaunchSet launchSet) {
        return (LaunchSet)this.launchSetPersistence.update((BaseModel)launchSet);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{LaunchSetLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.launchSetLocalService = (LaunchSetLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return LaunchSetLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return LaunchSet.class;
    }

    protected String getModelClassName() {
        return LaunchSet.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.launchSetPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

