/**
 * SPDX-FileCopyrightText: (c) 2026 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.launch.model.impl;

import com.liferay.launch.model.LaunchSet;
import com.liferay.launch.service.LaunchSetLocalServiceUtil;

/**
 * The extended model base implementation for the LaunchSet service. Represents a row in the &quot;LaunchSet&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LaunchSetImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LaunchSetImpl
 * @see LaunchSet
 * @generated
 */
public abstract class LaunchSetBaseImpl
	extends LaunchSetModelImpl implements LaunchSet {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a launch set model instance should use the <code>LaunchSet</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LaunchSetLocalServiceUtil.addLaunchSet(this);
		}
		else {
			LaunchSetLocalServiceUtil.updateLaunchSet(this);
		}
	}

}