/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.launch.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.launch.model.LaunchEntry;
import com.liferay.launch.service.LaunchEntryLocalService;
import com.liferay.launch.service.persistence.LaunchEntryPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class LaunchEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
LaunchEntryLocalService {
    protected LaunchEntryLocalService launchEntryLocalService;
    @Reference
    protected LaunchEntryPersistence launchEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(LaunchEntryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public LaunchEntry addLaunchEntry(LaunchEntry launchEntry) {
        launchEntry.setNew(true);
        return (LaunchEntry)this.launchEntryPersistence.update((BaseModel)launchEntry);
    }

    @Transactional(enabled=false)
    public LaunchEntry createLaunchEntry(long launchEntryId) {
        return this.launchEntryPersistence.create(launchEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public LaunchEntry deleteLaunchEntry(long launchEntryId) throws PortalException {
        return this.launchEntryPersistence.remove(launchEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public LaunchEntry deleteLaunchEntry(LaunchEntry launchEntry) {
        return (LaunchEntry)this.launchEntryPersistence.remove((BaseModel)launchEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.launchEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(LaunchEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.launchEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.launchEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.launchEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.launchEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.launchEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public LaunchEntry fetchLaunchEntry(long launchEntryId) {
        return this.launchEntryPersistence.fetchByPrimaryKey(launchEntryId);
    }

    public LaunchEntry fetchLaunchEntryByUuidAndCompanyId(String uuid, long companyId) {
        return this.launchEntryPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public LaunchEntry fetchLaunchEntryByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.launchEntryPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public LaunchEntry getLaunchEntryByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.launchEntryPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public LaunchEntry getLaunchEntry(long launchEntryId) throws PortalException {
        return this.launchEntryPersistence.findByPrimaryKey(launchEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.launchEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LaunchEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("launchEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.launchEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(LaunchEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("launchEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.launchEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(LaunchEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("launchEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<LaunchEntry>(){

            public void performAction(LaunchEntry launchEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)launchEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)LaunchEntry.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.launchEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement LaunchEntryLocalServiceImpl#deleteLaunchEntry(LaunchEntry) to avoid orphaned data");
        }
        return this.launchEntryLocalService.deleteLaunchEntry((LaunchEntry)persistedModel);
    }

    public BasePersistence<LaunchEntry> getBasePersistence() {
        return this.launchEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.launchEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public LaunchEntry getLaunchEntryByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.launchEntryPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<LaunchEntry> getLaunchEntries(int start, int end) {
        return this.launchEntryPersistence.findAll(start, end);
    }

    public int getLaunchEntriesCount() {
        return this.launchEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public LaunchEntry updateLaunchEntry(LaunchEntry launchEntry) {
        return (LaunchEntry)this.launchEntryPersistence.update((BaseModel)launchEntry);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{LaunchEntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.launchEntryLocalService = (LaunchEntryLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return LaunchEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return LaunchEntry.class;
    }

    protected String getModelClassName() {
        return LaunchEntry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.launchEntryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

