/**
 * SPDX-FileCopyrightText: (c) 2026 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.launch.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.launch.model.LaunchSet;
import com.liferay.launch.model.LaunchSetModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the LaunchSet service. Represents a row in the &quot;LaunchSet&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LaunchSetModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LaunchSetImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LaunchSetImpl
 * @generated
 */
@JSON(strict = true)
public class LaunchSetModelImpl
	extends BaseModelImpl<LaunchSet> implements LaunchSetModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a launch set model instance should use the <code>LaunchSet</code> interface instead.
	 */
	public static final String TABLE_NAME = "LaunchSet";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR}, {"launchSetId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"description", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("launchSetId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table LaunchSet (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,launchSetId LONG not null primary key,companyId LONG,userId LONG,createDate DATE null,modifiedDate DATE null,description VARCHAR(75) null,name VARCHAR(75) null,status INTEGER,statusByUserId LONG,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table LaunchSet";

	public static final String ORDER_BY_JPQL =
		" ORDER BY launchSet.modifiedDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY LaunchSet.modifiedDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public LaunchSetModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _launchSetId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setLaunchSetId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _launchSetId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return LaunchSet.class;
	}

	@Override
	public String getModelClassName() {
		return LaunchSet.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<LaunchSet, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<LaunchSet, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LaunchSet, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((LaunchSet)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<LaunchSet, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<LaunchSet, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(LaunchSet)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<LaunchSet, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<LaunchSet, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<LaunchSet, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<LaunchSet, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<LaunchSet, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", LaunchSet::getMvccVersion);
			attributeGetterFunctions.put("uuid", LaunchSet::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode", LaunchSet::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"launchSetId", LaunchSet::getLaunchSetId);
			attributeGetterFunctions.put("companyId", LaunchSet::getCompanyId);
			attributeGetterFunctions.put("userId", LaunchSet::getUserId);
			attributeGetterFunctions.put(
				"createDate", LaunchSet::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", LaunchSet::getModifiedDate);
			attributeGetterFunctions.put(
				"description", LaunchSet::getDescription);
			attributeGetterFunctions.put("name", LaunchSet::getName);
			attributeGetterFunctions.put("status", LaunchSet::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", LaunchSet::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusDate", LaunchSet::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<LaunchSet, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<LaunchSet, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<LaunchSet, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<LaunchSet, Long>)LaunchSet::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<LaunchSet, String>)LaunchSet::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<LaunchSet, String>)
					LaunchSet::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"launchSetId",
				(BiConsumer<LaunchSet, Long>)LaunchSet::setLaunchSetId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<LaunchSet, Long>)LaunchSet::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<LaunchSet, Long>)LaunchSet::setUserId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<LaunchSet, Date>)LaunchSet::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<LaunchSet, Date>)LaunchSet::setModifiedDate);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<LaunchSet, String>)LaunchSet::setDescription);
			attributeSetterBiConsumers.put(
				"name", (BiConsumer<LaunchSet, String>)LaunchSet::setName);
			attributeSetterBiConsumers.put(
				"status", (BiConsumer<LaunchSet, Integer>)LaunchSet::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<LaunchSet, Long>)LaunchSet::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<LaunchSet, Date>)LaunchSet::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getLaunchSetId() {
		return _launchSetId;
	}

	@Override
	public void setLaunchSetId(long launchSetId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_launchSetId = launchSetId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(LaunchSet.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), LaunchSet.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public LaunchSet toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, LaunchSet>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LaunchSetImpl launchSetImpl = new LaunchSetImpl();

		launchSetImpl.setMvccVersion(getMvccVersion());
		launchSetImpl.setUuid(getUuid());
		launchSetImpl.setExternalReferenceCode(getExternalReferenceCode());
		launchSetImpl.setLaunchSetId(getLaunchSetId());
		launchSetImpl.setCompanyId(getCompanyId());
		launchSetImpl.setUserId(getUserId());
		launchSetImpl.setCreateDate(getCreateDate());
		launchSetImpl.setModifiedDate(getModifiedDate());
		launchSetImpl.setDescription(getDescription());
		launchSetImpl.setName(getName());
		launchSetImpl.setStatus(getStatus());
		launchSetImpl.setStatusByUserId(getStatusByUserId());
		launchSetImpl.setStatusDate(getStatusDate());

		launchSetImpl.resetOriginalValues();

		return launchSetImpl;
	}

	@Override
	public LaunchSet cloneWithOriginalValues() {
		LaunchSetImpl launchSetImpl = new LaunchSetImpl();

		launchSetImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		launchSetImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		launchSetImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		launchSetImpl.setLaunchSetId(
			this.<Long>getColumnOriginalValue("launchSetId"));
		launchSetImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		launchSetImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		launchSetImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		launchSetImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		launchSetImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		launchSetImpl.setName(this.<String>getColumnOriginalValue("name"));
		launchSetImpl.setStatus(this.<Integer>getColumnOriginalValue("status"));
		launchSetImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		launchSetImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return launchSetImpl;
	}

	@Override
	public int compareTo(LaunchSet launchSet) {
		int value = 0;

		value = DateUtil.compareTo(
			getModifiedDate(), launchSet.getModifiedDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof LaunchSet)) {
			return false;
		}

		LaunchSet launchSet = (LaunchSet)object;

		long primaryKey = launchSet.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<LaunchSet> toCacheModel() {
		LaunchSetCacheModel launchSetCacheModel = new LaunchSetCacheModel();

		launchSetCacheModel.mvccVersion = getMvccVersion();

		launchSetCacheModel.uuid = getUuid();

		String uuid = launchSetCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			launchSetCacheModel.uuid = null;
		}

		launchSetCacheModel.externalReferenceCode = getExternalReferenceCode();

		String externalReferenceCode =
			launchSetCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			launchSetCacheModel.externalReferenceCode = null;
		}

		launchSetCacheModel.launchSetId = getLaunchSetId();

		launchSetCacheModel.companyId = getCompanyId();

		launchSetCacheModel.userId = getUserId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			launchSetCacheModel.createDate = createDate.getTime();
		}
		else {
			launchSetCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			launchSetCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			launchSetCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		launchSetCacheModel.description = getDescription();

		String description = launchSetCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			launchSetCacheModel.description = null;
		}

		launchSetCacheModel.name = getName();

		String name = launchSetCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			launchSetCacheModel.name = null;
		}

		launchSetCacheModel.status = getStatus();

		launchSetCacheModel.statusByUserId = getStatusByUserId();

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			launchSetCacheModel.statusDate = statusDate.getTime();
		}
		else {
			launchSetCacheModel.statusDate = Long.MIN_VALUE;
		}

		return launchSetCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<LaunchSet, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<LaunchSet, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LaunchSet, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((LaunchSet)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, LaunchSet>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					LaunchSet.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _launchSetId;
	private long _companyId;
	private long _userId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _description;
	private String _name;
	private int _status;
	private long _statusByUserId;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<LaunchSet, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((LaunchSet)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("launchSetId", _launchSetId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("launchSetId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("description", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("status", 1024L);

		columnBitmasks.put("statusByUserId", 2048L);

		columnBitmasks.put("statusDate", 4096L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private LaunchSet _escapedModel;

}