/**
 * SPDX-FileCopyrightText: (c) 2026 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.launch.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ExternalReferenceCodeModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the LaunchSet service. Represents a row in the &quot;LaunchSet&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.launch.model.impl.LaunchSetModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.launch.model.impl.LaunchSetImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LaunchSet
 * @generated
 */
@ProviderType
public interface LaunchSetModel
	extends BaseModel<LaunchSet>, ExternalReferenceCodeModel, MVCCModel,
			ShardedModel, StagedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a launch set model instance should use the {@link LaunchSet} interface instead.
	 */

	/**
	 * Returns the primary key of this launch set.
	 *
	 * @return the primary key of this launch set
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this launch set.
	 *
	 * @param primaryKey the primary key of this launch set
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this launch set.
	 *
	 * @return the mvcc version of this launch set
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this launch set.
	 *
	 * @param mvccVersion the mvcc version of this launch set
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this launch set.
	 *
	 * @return the uuid of this launch set
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this launch set.
	 *
	 * @param uuid the uuid of this launch set
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this launch set.
	 *
	 * @return the external reference code of this launch set
	 */
	@AutoEscape
	@Override
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this launch set.
	 *
	 * @param externalReferenceCode the external reference code of this launch set
	 */
	@Override
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the launch set ID of this launch set.
	 *
	 * @return the launch set ID of this launch set
	 */
	public long getLaunchSetId();

	/**
	 * Sets the launch set ID of this launch set.
	 *
	 * @param launchSetId the launch set ID of this launch set
	 */
	public void setLaunchSetId(long launchSetId);

	/**
	 * Returns the company ID of this launch set.
	 *
	 * @return the company ID of this launch set
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this launch set.
	 *
	 * @param companyId the company ID of this launch set
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this launch set.
	 *
	 * @return the user ID of this launch set
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this launch set.
	 *
	 * @param userId the user ID of this launch set
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this launch set.
	 *
	 * @return the user uuid of this launch set
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this launch set.
	 *
	 * @param userUuid the user uuid of this launch set
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this launch set.
	 *
	 * @return the create date of this launch set
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this launch set.
	 *
	 * @param createDate the create date of this launch set
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this launch set.
	 *
	 * @return the modified date of this launch set
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this launch set.
	 *
	 * @param modifiedDate the modified date of this launch set
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the description of this launch set.
	 *
	 * @return the description of this launch set
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this launch set.
	 *
	 * @param description the description of this launch set
	 */
	public void setDescription(String description);

	/**
	 * Returns the name of this launch set.
	 *
	 * @return the name of this launch set
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this launch set.
	 *
	 * @param name the name of this launch set
	 */
	public void setName(String name);

	/**
	 * Returns the status of this launch set.
	 *
	 * @return the status of this launch set
	 */
	public int getStatus();

	/**
	 * Sets the status of this launch set.
	 *
	 * @param status the status of this launch set
	 */
	public void setStatus(int status);

	/**
	 * Returns the status by user ID of this launch set.
	 *
	 * @return the status by user ID of this launch set
	 */
	public long getStatusByUserId();

	/**
	 * Sets the status by user ID of this launch set.
	 *
	 * @param statusByUserId the status by user ID of this launch set
	 */
	public void setStatusByUserId(long statusByUserId);

	/**
	 * Returns the status by user uuid of this launch set.
	 *
	 * @return the status by user uuid of this launch set
	 */
	public String getStatusByUserUuid();

	/**
	 * Sets the status by user uuid of this launch set.
	 *
	 * @param statusByUserUuid the status by user uuid of this launch set
	 */
	public void setStatusByUserUuid(String statusByUserUuid);

	/**
	 * Returns the status date of this launch set.
	 *
	 * @return the status date of this launch set
	 */
	public Date getStatusDate();

	/**
	 * Sets the status date of this launch set.
	 *
	 * @param statusDate the status date of this launch set
	 */
	public void setStatusDate(Date statusDate);

	@Override
	public LaunchSet cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}