/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.internal.configuration.ConfigurationFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropsUtil {
    private static final Log _log = LogFactoryUtil.getLog(PropsUtil.class);
    private static final Configuration _configuration;

    public static boolean contains(String key) {
        return _configuration.contains(key);
    }

    public static String get(String key) {
        return _configuration.get(key);
    }

    public static String get(String key, Filter filter) {
        return _configuration.get(key, filter);
    }

    public static String[] getArray(String key) {
        return _configuration.getArray(key);
    }

    public static String[] getArray(String key, Filter filter) {
        return _configuration.getArray(key, filter);
    }

    public static List<String> getLoadedSources() {
        return _configuration.getLoadedSources();
    }

    public static Properties getProperties() {
        return PropsUtil.getProperties(false);
    }

    public static Properties getProperties(boolean includeSystem) {
        Properties properties = _configuration.getProperties();
        if (!includeSystem) {
            return properties;
        }
        Properties systemCompanyProperties = _configuration.getProperties();
        Properties mergedProperties = (Properties)systemCompanyProperties.clone();
        mergedProperties.putAll((Map<?, ?>)properties);
        return mergedProperties;
    }

    public static Properties getProperties(String prefix, boolean removePrefix) {
        return _configuration.getProperties(prefix, removePrefix);
    }

    public static void set(String key, String value) {
        _configuration.set(key, value);
    }

    private static String _getDefaultLiferayHome() {
        int pos;
        Object defaultLiferayHome = null;
        defaultLiferayHome = ServerDetector.isJBoss() ? SystemProperties.get("jboss.home.dir") + "/.." : (ServerDetector.isWebLogic() ? SystemProperties.get("env.DOMAIN_HOME") + "/.." : (ServerDetector.isTomcat() ? SystemProperties.get("catalina.base") + "/.." : SystemProperties.get("user.dir") + "/liferay"));
        defaultLiferayHome = StringUtil.replace((String)defaultLiferayHome, '\\', '/');
        if (((String)(defaultLiferayHome = StringUtil.replace((String)defaultLiferayHome, "//", "/"))).endsWith("/..") && (pos = ((String)defaultLiferayHome).lastIndexOf(47, ((String)defaultLiferayHome).length() - 4)) != -1) {
            defaultLiferayHome = ((String)defaultLiferayHome).substring(0, pos);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Default Liferay home " + (String)defaultLiferayHome);
        }
        return defaultLiferayHome;
    }

    static {
        SystemProperties.set("default.liferay.home", PropsUtil._getDefaultLiferayHome());
        _configuration = ConfigurationFactoryImpl.CONFIGURATION_PORTAL;
        String liferayHome = _configuration.get("liferay.home");
        if (_log.isDebugEnabled()) {
            _log.debug("Configured Liferay home " + liferayHome);
        }
        SystemProperties.set("liferay.home", liferayHome);
        SystemProperties.set("ehcache.disk.store.dir", liferayHome + "/data/ehcache");
    }
}

