/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MapUtil {
    private static final Log _log = LogFactoryUtil.getLog(MapUtil.class);

    public static <K, V> void copy(Map<? extends K, ? extends V> master, Map<? super K, ? super V> copy) {
        copy.clear();
        MapUtil.merge(master, copy);
    }

    public static <T> Map<T, T> fromArray(T ... array) {
        if (array.length % 2 != 0) {
            throw new IllegalArgumentException("Array length is not an even number");
        }
        HashMap<T, T> map = new HashMap<T, T>();
        for (int i = 0; i < array.length; i += 2) {
            T key = array[i];
            T value = array[i + 1];
            map.put(key, value);
        }
        return map;
    }

    public static boolean getBoolean(Map<String, ?> map, String key) {
        return MapUtil.getBoolean(map, key, false);
    }

    public static boolean getBoolean(Map<String, ?> map, String key, boolean defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getBoolean(array[0], defaultValue);
        }
        return GetterUtil.getBoolean(String.valueOf(value), defaultValue);
    }

    public static double getDouble(Map<String, ?> map, String key) {
        return MapUtil.getDouble(map, key, 0.0);
    }

    public static double getDouble(Map<String, ?> map, String key, double defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getDouble(array[0], defaultValue);
        }
        return GetterUtil.getDouble(String.valueOf(value), defaultValue);
    }

    public static int getInteger(Map<String, ?> map, String key) {
        return MapUtil.getInteger(map, key, 0);
    }

    public static int getInteger(Map<String, ?> map, String key, int defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getInteger(array[0], defaultValue);
        }
        return GetterUtil.getInteger(String.valueOf(value), defaultValue);
    }

    public static long getLong(Map<Long, Long> map, long key) {
        return MapUtil.getLong(map, key, 0L);
    }

    public static long getLong(Map<Long, Long> map, long key, long defaultValue) {
        Long value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static long getLong(Map<String, ?> map, String key) {
        return MapUtil.getLong(map, key, 0L);
    }

    public static long getLong(Map<String, ?> map, String key, long defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getLong(array[0], defaultValue);
        }
        return GetterUtil.getLong(String.valueOf(value), defaultValue);
    }

    public static short getShort(Map<String, ?> map, String key) {
        return MapUtil.getShort(map, key, (short)0);
    }

    public static short getShort(Map<String, ?> map, String key, short defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getShort(array[0], defaultValue);
        }
        return GetterUtil.getShort(String.valueOf(value), defaultValue);
    }

    public static <K, V> String getString(Map<K, V> map, K key) {
        return MapUtil.getString(map, key, "");
    }

    public static <K, V> String getString(Map<K, V> map, K key, String defaultValue) {
        V value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return GetterUtil.getString((String)value, defaultValue);
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getString(array[0], defaultValue);
        }
        return GetterUtil.getString(String.valueOf(value), defaultValue);
    }

    public static <K, V> V getWithFallbackKey(Map<K, V> map, K key, K fallbackKey) {
        if (map == null) {
            return null;
        }
        V value = map.get(key);
        if (value == null || value instanceof String && Validator.isBlank((String)value)) {
            return map.get(fallbackKey);
        }
        return value;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtil.isEmpty(map);
    }

    public static <K, V> void isNotEmptyForEach(Map<? extends K, ? extends V> map, BiConsumer<? super K, ? super V> biConsumer) {
        if (!MapUtil.isEmpty(map)) {
            map.forEach(biConsumer);
        }
    }

    public static <K, V> void merge(Map<? extends K, ? extends V> master, Map<? super K, ? super V> copy) {
        copy.putAll(master);
    }

    public static <K, V> Dictionary<K, V> singletonDictionary(K key, V value) {
        return new SingletonDictionary<K, V>(key, value);
    }

    public static <T> LinkedHashMap<String, T> toLinkedHashMap(String[] params) {
        return MapUtil.toLinkedHashMap(params, ":");
    }

    public static <T> LinkedHashMap<String, T> toLinkedHashMap(String[] params, String delimiter) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (params == null) {
            return map;
        }
        for (String param : params) {
            String[] kvp = StringUtil.split(param, delimiter);
            if (kvp.length == 2) {
                map.put(kvp[0], kvp[1]);
                continue;
            }
            if (kvp.length != 3) continue;
            String type = kvp[2];
            if (StringUtil.equalsIgnoreCase(type, "boolean") || type.equals(Boolean.class.getName())) {
                map.put(kvp[0], Boolean.valueOf(kvp[1]));
                continue;
            }
            if (StringUtil.equalsIgnoreCase(type, "double") || type.equals(Double.class.getName())) {
                map.put(kvp[0], Double.valueOf(kvp[1]));
                continue;
            }
            if (StringUtil.equalsIgnoreCase(type, "int") || type.equals(Integer.class.getName())) {
                map.put(kvp[0], Integer.valueOf(kvp[1]));
                continue;
            }
            if (StringUtil.equalsIgnoreCase(type, "long") || type.equals(Long.class.getName())) {
                map.put(kvp[0], Long.valueOf(kvp[1]));
                continue;
            }
            if (StringUtil.equalsIgnoreCase(type, "short") || type.equals(Short.class.getName())) {
                map.put(kvp[0], Short.valueOf(kvp[1]));
                continue;
            }
            if (type.equals(String.class.getName())) {
                map.put(kvp[0], kvp[1]);
                continue;
            }
            try {
                Class<?> clazz = Class.forName(type);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                map.put(kvp[0], constructor.newInstance(kvp[1]));
            }
            catch (Exception exception) {
                _log.error(exception);
            }
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toPartitionMap(List<V> list, Function<V, K> keyExtractor) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, List> map = new HashMap<Object, List>();
        for (V v : list) {
            List partitionList = map.computeIfAbsent(keyExtractor.apply(v), key -> new ArrayList());
            partitionList.add(v);
        }
        return map;
    }

    public static String toString(Map<?, ?> map) {
        return MapUtil.toString(map, null, null);
    }

    public static String toString(Map<?, ?> map, String hideIncludesRegex, String hideExcludesRegex) {
        if (MapUtil.isEmpty(map)) {
            return "{}";
        }
        StringBundler sb = new StringBundler(map.size() * 4 + 1);
        sb.append("{");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            String keyString = String.valueOf(entry.getKey());
            if (hideIncludesRegex != null && !keyString.matches(hideIncludesRegex)) {
                value = "********";
            }
            if (hideExcludesRegex != null && keyString.matches(hideExcludesRegex)) {
                value = "********";
            }
            sb.append(keyString);
            sb.append("=");
            if (value instanceof Map) {
                sb.append(MapUtil.toString((Map)value));
            } else if (value instanceof String[]) {
                String valueString = StringUtil.merge((String[])value, ", ");
                sb.append(StringBundler.concat("[", valueString, "]"));
            } else {
                sb.append(value);
            }
            sb.append(", ");
        }
        sb.setStringAt("}", sb.index() - 1);
        return sb.toString();
    }

    private static class SingletonDictionary<K, V>
    extends Dictionary<K, V> {
        private final K _key;
        private final V _value;

        @Override
        public Enumeration<V> elements() {
            return Collections.enumeration(Collections.singleton(this._value));
        }

        @Override
        public V get(Object key) {
            if (Objects.equals(this._key, key)) {
                return this._value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Enumeration<K> keys() {
            return Collections.enumeration(Collections.singleton(this._key));
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 1;
        }

        public String toString() {
            return StringBundler.concat((Object[])new Object[]{"{", this._key, "=", this._value, "}"});
        }

        private SingletonDictionary(K key, V value) {
            this._key = key;
            this._value = value;
        }
    }
}

