/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PrettyDateFormat
extends DateFormat {
    private final Locale _locale;
    private final TimeZone _timeZone;
    private final String _todayString;
    private final String _yesterdayString;

    public PrettyDateFormat(Locale locale, TimeZone timeZone) {
        this._locale = locale;
        this._timeZone = timeZone;
        this._todayString = LanguageUtil.get((Locale)locale, (String)"today");
        this._yesterdayString = LanguageUtil.get((Locale)locale, (String)"yesterday");
    }

    @Override
    public StringBuffer format(Date date, StringBuffer sb, FieldPosition pos) {
        Object dateString = "&nbsp;";
        if (date == null) {
            return sb.append((String)dateString);
        }
        Date today = new Date();
        Calendar cal = Calendar.getInstance(this._timeZone, this._locale);
        cal.setTime(today);
        cal.add(5, -1);
        Date yesterday = cal.getTime();
        Format dateFormat = FastDateFormatFactoryUtil.getDate(this._locale, this._timeZone);
        Format timeFormat = FastDateFormatFactoryUtil.getTime(this._locale, this._timeZone);
        dateString = dateFormat.format(date);
        if (((String)dateString).equals(dateFormat.format(today))) {
            dateString = this._todayString + " " + timeFormat.format(date);
        } else if (((String)dateString).equals(dateFormat.format(yesterday))) {
            dateString = this._yesterdayString + " " + timeFormat.format(date);
        } else {
            Format dateTimeFormat = FastDateFormatFactoryUtil.getDateTime(this._locale, this._timeZone);
            dateString = dateTimeFormat.format(date);
        }
        return sb.append((String)dateString);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        Format dateFormat = FastDateFormatFactoryUtil.getDate(this._locale, this._timeZone);
        DateFormat dateFormatDateTime = DateFormatFactoryUtil.getDateTime(this._locale, this._timeZone);
        Date today = new Date();
        String dateString = source.substring(pos.getIndex());
        if (dateString.startsWith(this._todayString)) {
            dateString = dateString.replaceFirst(this._todayString, dateFormat.format(today));
        } else if (dateString.startsWith(this._yesterdayString)) {
            Calendar cal = Calendar.getInstance(this._timeZone, this._locale);
            cal.setTime(today);
            cal.add(5, -1);
            Date yesterday = cal.getTime();
            dateString = dateString.replaceFirst(this._todayString, dateFormat.format(yesterday));
        }
        return dateFormatDateTime.parse(dateString, new ParsePosition(0));
    }
}

