/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class EnvPropertiesUtil {
    private static final Log _log = LogFactoryUtil.getLog(EnvPropertiesUtil.class);
    private static final Map<String, Character> _charPoolChars = EnvPropertiesUtil._getCharPoolChars();

    public static String decode(String s) {
        int index = -1;
        int openUnderLine = -1;
        int position = 0;
        StringBundler sb = new StringBundler();
        while ((index = s.indexOf(95, index + 1)) != -1) {
            if (openUnderLine == -1) {
                sb.append(s.substring(position, index));
                openUnderLine = index;
                position = index;
                continue;
            }
            String encoded = s.substring(openUnderLine + 1, index);
            Character character = _charPoolChars.get(StringUtil.toUpperCase(encoded));
            if (character == null) {
                int value = GetterUtil.get(encoded, -1);
                if (Character.isDefined(value)) {
                    sb.append(new String(Character.toChars(value)));
                } else {
                    if (_log.isWarnEnabled()) {
                        _log.warn(StringBundler.concat("Unable to decode part \"", encoded, "\" from \"", s, "\", preserve it literally"));
                    }
                    sb.append(s.substring(openUnderLine, index + 1));
                }
            } else {
                sb.append(character);
            }
            openUnderLine = -1;
            position = index + 1;
        }
        sb.append(s.substring(position));
        return sb.toString();
    }

    public static void loadEnvOverrides(String envPrefix, BiConsumer<String, String> biConsumer) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String newKey;
            String key = entry.getKey();
            if (!key.startsWith(envPrefix) || (newKey = EnvPropertiesUtil.decode(StringUtil.toLowerCase(key.substring(envPrefix.length())))).equals("include-and-override")) continue;
            biConsumer.accept(newKey, entry.getValue());
            if (!_log.isInfoEnabled()) continue;
            _log.info(StringBundler.concat("Overrode property ", newKey, " with the value from the environment variable ", key));
        }
    }

    private static Map<String, Character> _getCharPoolChars() {
        try {
            HashMap<String, Character> charPoolChars = new HashMap<String, Character>();
            for (Field field : CharPool.class.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Character.TYPE) continue;
                charPoolChars.put(StringUtil.removeChar(field.getName(), '_'), Character.valueOf(field.getChar(null)));
            }
            return charPoolChars;
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

