/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBTemplateLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKBTemplateUADAnonymizer
extends DynamicQueryUADAnonymizer<KBTemplate> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected KBTemplateLocalService kbTemplateLocalService;

    public void autoAnonymize(KBTemplate kbTemplate, long userId, User anonymousUser) throws PortalException {
        if (kbTemplate.getUserId() == userId) {
            kbTemplate.setUserId(anonymousUser.getUserId());
            kbTemplate.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(kbTemplate, anonymousUser);
        }
        this.kbTemplateLocalService.updateKBTemplate(kbTemplate);
    }

    public void delete(KBTemplate kbTemplate) throws PortalException {
        this.kbTemplateLocalService.deleteKBTemplate(kbTemplate);
    }

    public Class<KBTemplate> getTypeClass() {
        return KBTemplate.class;
    }

    protected void autoAnonymizeAssetEntry(KBTemplate kbTemplate, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(kbTemplate);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.kbTemplateLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return KBUADConstants.USER_ID_FIELD_NAMES_KB_TEMPLATE;
    }

    protected AssetEntry fetchAssetEntry(KBTemplate kbTemplate) {
        return this.assetEntryLocalService.fetchEntry(KBTemplate.class.getName(), kbTemplate.getKbTemplateId());
    }
}

