/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKBFolderUADAnonymizer
extends DynamicQueryUADAnonymizer<KBFolder> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected KBFolderLocalService kbFolderLocalService;

    public void autoAnonymize(KBFolder kbFolder, long userId, User anonymousUser) throws PortalException {
        if (kbFolder.getUserId() == userId) {
            kbFolder.setUserId(anonymousUser.getUserId());
            kbFolder.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(kbFolder, anonymousUser);
        }
        if (kbFolder.getStatusByUserId() == userId) {
            kbFolder.setStatusByUserId(anonymousUser.getUserId());
            kbFolder.setStatusByUserName(anonymousUser.getFullName());
        }
        this.kbFolderLocalService.updateKBFolder(kbFolder);
    }

    public void delete(KBFolder kbFolder) throws PortalException {
        this.kbFolderLocalService.deleteKBFolder(kbFolder);
    }

    public Class<KBFolder> getTypeClass() {
        return KBFolder.class;
    }

    protected void autoAnonymizeAssetEntry(KBFolder kbFolder, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(kbFolder);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.kbFolderLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return KBUADConstants.USER_ID_FIELD_NAMES_KB_FOLDER;
    }

    protected AssetEntry fetchAssetEntry(KBFolder kbFolder) {
        return this.assetEntryLocalService.fetchEntry(KBFolder.class.getName(), kbFolder.getKbFolderId());
    }
}

