/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBTemplateLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the kb template UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link KBTemplateUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseKBTemplateUADAnonymizer
	extends DynamicQueryUADAnonymizer<KBTemplate> {

	@Override
	public void autoAnonymize(
			KBTemplate kbTemplate, long userId, User anonymousUser)
		throws PortalException {

		if (kbTemplate.getUserId() == userId) {
			kbTemplate.setUserId(anonymousUser.getUserId());
			kbTemplate.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(kbTemplate, anonymousUser);
		}

		kbTemplateLocalService.updateKBTemplate(kbTemplate);
	}

	@Override
	public void delete(KBTemplate kbTemplate) throws PortalException {
		kbTemplateLocalService.deleteKBTemplate(kbTemplate);
	}

	@Override
	public Class<KBTemplate> getTypeClass() {
		return KBTemplate.class;
	}

	protected void autoAnonymizeAssetEntry(
		KBTemplate kbTemplate, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(kbTemplate);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return kbTemplateLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return KBUADConstants.USER_ID_FIELD_NAMES_KB_TEMPLATE;
	}

	protected AssetEntry fetchAssetEntry(KBTemplate kbTemplate) {
		return assetEntryLocalService.fetchEntry(
			KBTemplate.class.getName(), kbTemplate.getKbTemplateId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected KBTemplateLocalService kbTemplateLocalService;

}