/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the kb folder UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link KBFolderUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseKBFolderUADAnonymizer
	extends DynamicQueryUADAnonymizer<KBFolder> {

	@Override
	public void autoAnonymize(
			KBFolder kbFolder, long userId, User anonymousUser)
		throws PortalException {

		if (kbFolder.getUserId() == userId) {
			kbFolder.setUserId(anonymousUser.getUserId());
			kbFolder.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(kbFolder, anonymousUser);
		}

		if (kbFolder.getStatusByUserId() == userId) {
			kbFolder.setStatusByUserId(anonymousUser.getUserId());
			kbFolder.setStatusByUserName(anonymousUser.getFullName());
		}

		kbFolderLocalService.updateKBFolder(kbFolder);
	}

	@Override
	public void delete(KBFolder kbFolder) throws PortalException {
		kbFolderLocalService.deleteKBFolder(kbFolder);
	}

	@Override
	public Class<KBFolder> getTypeClass() {
		return KBFolder.class;
	}

	protected void autoAnonymizeAssetEntry(
		KBFolder kbFolder, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(kbFolder);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return kbFolderLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return KBUADConstants.USER_ID_FIELD_NAMES_KB_FOLDER;
	}

	protected AssetEntry fetchAssetEntry(KBFolder kbFolder) {
		return assetEntryLocalService.fetchEntry(
			KBFolder.class.getName(), kbFolder.getKbFolderId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected KBFolderLocalService kbFolderLocalService;

}