/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.knowledge.base.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.KBCommentLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the kb comment UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link KBCommentUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseKBCommentUADAnonymizer
	extends DynamicQueryUADAnonymizer<KBComment> {

	@Override
	public void autoAnonymize(
			KBComment kbComment, long userId, User anonymousUser)
		throws PortalException {

		if (kbComment.getUserId() == userId) {
			kbComment.setUserId(anonymousUser.getUserId());
			kbComment.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(kbComment, anonymousUser);
		}

		kbCommentLocalService.updateKBComment(kbComment);
	}

	@Override
	public void delete(KBComment kbComment) throws PortalException {
		kbCommentLocalService.deleteKBComment(kbComment);
	}

	@Override
	public Class<KBComment> getTypeClass() {
		return KBComment.class;
	}

	protected void autoAnonymizeAssetEntry(
		KBComment kbComment, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(kbComment);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return kbCommentLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return KBUADConstants.USER_ID_FIELD_NAMES_KB_COMMENT;
	}

	protected AssetEntry fetchAssetEntry(KBComment kbComment) {
		return assetEntryLocalService.fetchEntry(
			KBComment.class.getName(), kbComment.getKbCommentId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected KBCommentLocalService kbCommentLocalService;

}