/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.knowledge.base.uad.display;

import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.KBCommentLocalService;
import com.liferay.knowledge.base.uad.constants.KBUADConstants;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.user.associated.data.display.BaseModelUADDisplay;

import java.io.Serializable;

import java.util.List;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the KBComment UAD display.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom methods should be put in
 * {@link KBCommentUADDisplay}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseKBCommentUADDisplay
	extends BaseModelUADDisplay<KBComment> {

	@Override
	public KBComment get(Serializable primaryKey) throws PortalException {
		return kbCommentLocalService.getKBComment(
			Long.valueOf(primaryKey.toString()));
	}

	@Override
	public String[] getDisplayFieldNames() {
		return new String[] {"content"};
	}

	@Override
	public Class<KBComment> getTypeClass() {
		return KBComment.class;
	}

	@Override
	protected long doCount(DynamicQuery dynamicQuery) {
		return kbCommentLocalService.dynamicQueryCount(dynamicQuery);
	}

	@Override
	protected DynamicQuery doGetDynamicQuery() {
		return kbCommentLocalService.dynamicQuery();
	}

	@Override
	protected List<KBComment> doGetRange(
		DynamicQuery dynamicQuery, int start, int end) {

		return kbCommentLocalService.dynamicQuery(dynamicQuery, start, end);
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return KBUADConstants.USER_ID_FIELD_NAMES_KB_COMMENT;
	}

	@Reference
	protected KBCommentLocalService kbCommentLocalService;

}