/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.trash;

import com.liferay.knowledge.base.internal.trash.BaseKBTrashHandler;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.trash.TrashHelper;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBFolder"}, service={TrashHandler.class})
public class KBFolderTrashHandler
extends BaseKBTrashHandler {
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBFolder)")
    private ModelResourcePermission<KBFolder> _kbFolderModelResourcePermission;
    @Reference
    private TrashHelper _trashHelper;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this.kbFolderLocalService.deleteKBFolder(classPK, false);
    }

    public String getClassName() {
        return KBFolder.class.getName();
    }

    public String getDeleteMessage() {
        return "found-in-deleted-folder-x";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return this.getContainerModel(kbFolder.getParentKBFolderId());
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        return KnowledgeBaseUtil.getKBFolderControlPanelLink((PortletRequest)portletRequest, (long)classPK);
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return KnowledgeBaseUtil.getKBFolderControlPanelLink((PortletRequest)portletRequest, (long)kbFolder.getParentKBFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return KnowledgeBaseUtil.getKBFolderAbsolutePath((PortletRequest)portletRequest, (long)kbFolder.getParentKBFolderId());
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this.kbFolderLocalService.fetchKBFolder(classPK);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionUtil.contains(this._kbFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_KB_FOLDER");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isMovable(long classPK) throws PortalException {
        KBFolder parentFolder;
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return kbFolder.getParentKBFolderId() > 0L && ((parentFolder = this.kbFolderLocalService.fetchKBFolder(kbFolder.getParentKBFolderId())) == null || parentFolder.isInTrash());
    }

    public boolean isRestorable(long classPK) throws PortalException {
        KBFolder parentFolder;
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        if (kbFolder.getParentKBFolderId() > 0L && (parentFolder = this.kbFolderLocalService.fetchKBFolder(kbFolder.getParentKBFolderId())) == null) {
            return false;
        }
        return this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), kbFolder.getGroupId(), classPK, "RESTORE") && !this._trashHelper.isInTrashContainer((TrashedModel)kbFolder);
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this.kbFolderLocalService.moveKBFolder(classPK, containerModelId);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this.kbFolderLocalService.moveKBFolderFromTrash(userId, classPK, containerModelId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this.kbFolderLocalService.restoreKBFolderFromTrash(userId, classPK);
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return kbFolder.getGroupId();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return this._kbFolderModelResourcePermission.contains(permissionChecker, (ClassedModel)this.kbFolderLocalService.getKBFolder(classPK), actionId);
    }
}

