/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.DuplicateKBFolderNameException;
import com.liferay.knowledge.base.exception.InvalidKBFolderNameException;
import com.liferay.knowledge.base.exception.KBFolderParentException;
import com.liferay.knowledge.base.exception.NoSuchFolderException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.base.KBFolderLocalServiceBaseImpl;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBFolder"}, service={AopService.class})
public class KBFolderLocalServiceImpl
extends KBFolderLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public KBFolder addKBFolder(String externalReferenceCode, long userId, long groupId, long parentResourceClassNameId, long parentResourcePrimKey, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        this._validateName(groupId, parentResourcePrimKey, name);
        this._validateParent(parentResourceClassNameId, parentResourcePrimKey);
        long kbFolderId = this.counterLocalService.increment();
        KBFolder kbFolder = this.kbFolderPersistence.create(kbFolderId);
        kbFolder.setUuid(serviceContext.getUuid());
        kbFolder.setExternalReferenceCode(externalReferenceCode);
        kbFolder.setGroupId(groupId);
        kbFolder.setCompanyId(user.getCompanyId());
        kbFolder.setUserId(userId);
        kbFolder.setUserName(user.getFullName());
        kbFolder.setCreateDate(date);
        kbFolder.setModifiedDate(date);
        kbFolder.setParentKBFolderId(parentResourcePrimKey);
        kbFolder.setName(name);
        kbFolder.setUrlTitle(this._getUniqueUrlTitle(groupId, parentResourcePrimKey, kbFolderId, name));
        kbFolder.setDescription(description);
        kbFolder.setStatus(0);
        kbFolder.setStatusByUserId(userId);
        kbFolder.setStatusByUserName(user.getFullName());
        kbFolder.setStatusDate(date);
        kbFolder.setExpandoBridgeAttributes(serviceContext);
        kbFolder = (KBFolder)this.kbFolderPersistence.update((BaseModel)kbFolder);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this._addKBFolderResources(kbFolder, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this._addKBFolderResources(kbFolder, serviceContext.getModelPermissions());
        }
        return kbFolder;
    }

    @Override
    public KBFolder deleteKBFolder(KBFolder kbFolder) throws PortalException {
        return this.kbFolderLocalService.deleteKBFolder(kbFolder, true);
    }

    @SystemEvent(action=1, type=1)
    public KBFolder deleteKBFolder(KBFolder kbFolder, boolean includeTrashedEntries) throws PortalException {
        this._kbArticleLocalService.deleteKBArticles(kbFolder.getGroupId(), kbFolder.getKbFolderId(), includeTrashedEntries);
        List childKBFolders = this.kbFolderPersistence.findByG_P(kbFolder.getGroupId(), kbFolder.getKbFolderId());
        for (KBFolder childKBFolder : childKBFolders) {
            if (!includeTrashedEntries && this._trashHelper.isInTrashExplicitly((TrashedModel)childKBFolder)) continue;
            this.deleteKBFolder(childKBFolder.getKbFolderId());
        }
        this._resourceLocalService.deleteResource(kbFolder.getCompanyId(), KBFolder.class.getName(), 4, kbFolder.getKbFolderId());
        this._expandoRowLocalService.deleteRows(kbFolder.getKbFolderId());
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)kbFolder)) {
            this._trashEntryLocalService.deleteEntry(KBFolder.class.getName(), kbFolder.getKbFolderId());
        } else {
            this._trashVersionLocalService.deleteTrashVersion(KBFolder.class.getName(), kbFolder.getKbFolderId());
        }
        return (KBFolder)this.kbFolderPersistence.remove((BaseModel)kbFolder);
    }

    @Override
    public KBFolder deleteKBFolder(long kbFolderId) throws PortalException {
        return this.deleteKBFolder(kbFolderId, true);
    }

    public KBFolder deleteKBFolder(long kbFolderId, boolean includeTrashedEntries) throws PortalException {
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        return this.kbFolderLocalService.deleteKBFolder(kbFolder, includeTrashedEntries);
    }

    public void deleteKBFolders(long groupId) throws PortalException {
        List<KBFolder> kbFolders = this.getKBFolders(groupId, 0L, -1, -1);
        for (KBFolder kbFolder : kbFolders) {
            this.deleteKBFolder(kbFolder.getKbFolderId());
        }
    }

    public KBFolder fetchFirstChildKBFolder(long groupId, long kbFolderId) throws PortalException {
        return this.fetchFirstChildKBFolder(groupId, kbFolderId, null);
    }

    public KBFolder fetchFirstChildKBFolder(long groupId, long kbFolderId, OrderByComparator<KBFolder> orderByComparator) throws PortalException {
        return this.kbFolderPersistence.fetchByG_P_First(groupId, kbFolderId, orderByComparator);
    }

    @Override
    public KBFolder fetchKBFolder(long kbFolderId) {
        return this.kbFolderPersistence.fetchByPrimaryKey(kbFolderId);
    }

    public KBFolder fetchKBFolder(String uuid, long groupId) {
        return this.kbFolderPersistence.fetchByUUID_G(uuid, groupId);
    }

    public KBFolder fetchKBFolderByUrlTitle(long groupId, long parentKbFolderId, String urlTitle) throws PortalException {
        return this.kbFolderPersistence.fetchByG_P_UT(groupId, parentKbFolderId, urlTitle);
    }

    public KBFolder getKBFolderByUrlTitle(long groupId, long parentKbFolderId, String urlTitle) throws PortalException {
        return this.kbFolderPersistence.findByG_P_UT(groupId, parentKbFolderId, urlTitle);
    }

    public List<KBFolder> getKBFolders(long groupId, long parentKBFolderId, int start, int end) throws PortalException {
        return this.kbFolderPersistence.findByG_P_S(groupId, parentKBFolderId, 0, start, end);
    }

    public List<Object> getKBFoldersAndKBArticles(long groupId, long parentResourcePrimKey) {
        return this.getKBFoldersAndKBArticles(groupId, parentResourcePrimKey, 0);
    }

    public List<Object> getKBFoldersAndKBArticles(long groupId, long parentResourcePrimKey, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.kbFolderFinder.findF_A_ByG_P(groupId, parentResourcePrimKey, queryDefinition);
    }

    public List<Object> getKBFoldersAndKBArticles(long groupId, long parentResourcePrimKey, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.kbFolderFinder.findF_A_ByG_P(groupId, parentResourcePrimKey, queryDefinition);
    }

    public int getKBFoldersAndKBArticlesCount(long groupId, long parentResourcePrimKey, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.kbFolderFinder.countF_A_ByG_P(groupId, parentResourcePrimKey, queryDefinition);
    }

    public int getKBFoldersCount(long groupId, long parentKBFolderId) throws PortalException {
        return this.kbFolderPersistence.countByG_P(groupId, parentKBFolderId);
    }

    public int getKBFoldersCount(long groupId, long parentKBFolderId, int status) throws PortalException {
        return this.kbFolderPersistence.countByG_P_S(groupId, parentKBFolderId, status);
    }

    public KBFolder moveKBFolder(long kbFolderId, long parentKBFolderId) throws PortalException {
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        if (parentKBFolderId != 0L) {
            KBFolder parentKBFolder = this.kbFolderPersistence.findByPrimaryKey(parentKBFolderId);
            this._validateParent(kbFolder, parentKBFolder);
            parentKBFolderId = parentKBFolder.getKbFolderId();
        }
        kbFolder.setParentKBFolderId(parentKBFolderId);
        kbFolder = (KBFolder)this.kbFolderPersistence.update((BaseModel)kbFolder);
        LinkedList kbFoldersAndArticles = new LinkedList(this.kbFolderLocalService.getKBFoldersAndKBArticles(kbFolder.getGroupId(), kbFolder.getKbFolderId(), -1, -1, -1, null));
        while (!kbFoldersAndArticles.isEmpty()) {
            Object kbObject = kbFoldersAndArticles.pop();
            if (kbObject instanceof KBArticle) {
                KBArticle childKBArticle = (KBArticle)kbObject;
                this._kbArticleLocalService.updateKBArticle(childKBArticle);
                continue;
            }
            if (!(kbObject instanceof KBFolder)) continue;
            KBFolder childKBFolder = (KBFolder)kbObject;
            kbFoldersAndArticles.addAll(this.kbFolderLocalService.getKBFoldersAndKBArticles(childKBFolder.getGroupId(), childKBFolder.getKbFolderId(), -1, -1, -1, null));
        }
        return kbFolder;
    }

    public KBFolder moveKBFolderFromTrash(long userId, long kbFolderId, long parentKBFolderId) throws PortalException {
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        if (!kbFolder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)kbFolder)) {
            this.restoreKBFolderFromTrash(userId, kbFolderId);
        } else {
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(KBFolder.class.getName(), kbFolderId);
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, kbFolder, status);
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this._restoreDependentsFromTrash(kbFolder);
        }
        return this.moveKBFolder(kbFolderId, parentKBFolderId);
    }

    public KBFolder moveKBFolderToTrash(long userId, long kbFolderId) throws PortalException {
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        if (kbFolder.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = kbFolder.getStatus();
        kbFolder = this.updateStatus(userId, kbFolder, 8);
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, kbFolder.getGroupId(), KBFolder.class.getName(), kbFolder.getKbFolderId(), kbFolder.getUuid(), null, oldStatus, null, null);
        this._moveDependentsToTrash(kbFolder, trashEntry.getEntryId());
        return kbFolder;
    }

    public KBFolder restoreKBFolderFromTrash(long userId, long kbFolderId) throws PortalException {
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        if (!kbFolder.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(KBFolder.class.getName(), kbFolderId);
        kbFolder = this.updateStatus(userId, kbFolder, trashEntry.getStatus());
        this._restoreDependentsFromTrash(kbFolder);
        this._trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        return kbFolder;
    }

    public KBFolder updateKBFolder(long parentResourceClassNameId, long parentResourcePrimKey, long kbFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this._validateParent(parentResourceClassNameId, parentResourcePrimKey);
        KBFolder kbFolder = this.kbFolderPersistence.findByPrimaryKey(kbFolderId);
        if (!StringUtil.equals((String)name, (String)kbFolder.getName())) {
            this._validateName(kbFolder.getGroupId(), parentResourcePrimKey, name);
        }
        kbFolder.setModifiedDate(new Date());
        kbFolder.setParentKBFolderId(parentResourcePrimKey);
        kbFolder.setName(name);
        kbFolder.setDescription(description);
        kbFolder.setExpandoBridgeAttributes(serviceContext);
        return (KBFolder)this.kbFolderPersistence.update((BaseModel)kbFolder);
    }

    public KBFolder updateStatus(long userId, KBFolder kbFolder, int status) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        kbFolder.setStatus(status);
        kbFolder.setStatusByUserId(userId);
        kbFolder.setStatusByUserName(user.getFullName());
        kbFolder.setStatusDate(new Date());
        kbFolder = (KBFolder)this.kbFolderPersistence.update((BaseModel)kbFolder);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KBFolder.class);
        indexer.reindex((Object)kbFolder);
        return kbFolder;
    }

    private void _addKBFolderResources(KBFolder kbFolder, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(kbFolder.getCompanyId(), kbFolder.getGroupId(), kbFolder.getUserId(), KBFolder.class.getName(), kbFolder.getKbFolderId(), false, addGroupPermissions, addGuestPermissions);
    }

    private void _addKBFolderResources(KBFolder kbFolder, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(kbFolder.getCompanyId(), kbFolder.getGroupId(), kbFolder.getUserId(), KBFolder.class.getName(), kbFolder.getKbFolderId(), modelPermissions);
    }

    private String _getUniqueUrlTitle(long groupId, long parentKbFolderId, long kbFolderId, String name) {
        String urlTitle;
        String uniqueUrlTitle = urlTitle = KnowledgeBaseUtil.getUrlTitle((long)kbFolderId, (String)name);
        KBFolder kbFolder = this.kbFolderPersistence.fetchByG_P_UT(groupId, parentKbFolderId, uniqueUrlTitle);
        int i = 1;
        while (kbFolder != null) {
            uniqueUrlTitle = urlTitle + "-" + i;
            kbFolder = this.kbFolderPersistence.fetchByG_P_UT(groupId, parentKbFolderId, uniqueUrlTitle);
            ++i;
        }
        return uniqueUrlTitle;
    }

    private void _moveDependentsToTrash(KBFolder parentKBFolder, long trashEntryId) throws PortalException {
        List<Object> objects = this.getKBFoldersAndKBArticles(parentKBFolder.getGroupId(), parentKBFolder.getKbFolderId(), -1);
        for (Object object : objects) {
            if (object instanceof KBArticle) {
                this._kbArticleLocalService.moveDependentKBArticleToTrash((KBArticle)object, trashEntryId);
                continue;
            }
            KBFolder kbFolder = (KBFolder)object;
            if (kbFolder.isInTrash()) continue;
            int oldStatus = kbFolder.getStatus();
            kbFolder.setStatus(8);
            kbFolder = (KBFolder)this.kbFolderPersistence.update((BaseModel)kbFolder);
            if (oldStatus != 0) {
                this._trashVersionLocalService.addTrashVersion(trashEntryId, KBFolder.class.getName(), kbFolder.getKbFolderId(), oldStatus, null);
            }
            this._moveDependentsToTrash(kbFolder, trashEntryId);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KBFolder.class);
            indexer.reindex((Object)kbFolder);
        }
    }

    private void _restoreDependentsFromTrash(KBFolder parentKBFolder) throws PortalException {
        List<Object> objects = this.getKBFoldersAndKBArticles(parentKBFolder.getGroupId(), parentKBFolder.getKbFolderId(), 8);
        for (Object object : objects) {
            if (object instanceof KBArticle) {
                this._kbArticleLocalService.restoreDependentKBArticleFromTrash((KBArticle)object);
                continue;
            }
            KBFolder kbFolder = (KBFolder)object;
            if (!this._trashHelper.isInTrashImplicitly((TrashedModel)kbFolder)) continue;
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(KBFolder.class.getName(), kbFolder.getKbFolderId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            kbFolder.setStatus(oldStatus);
            kbFolder = (KBFolder)this.kbFolderPersistence.update((BaseModel)kbFolder);
            this._restoreDependentsFromTrash(kbFolder);
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KBFolder.class);
            indexer.reindex((Object)kbFolder);
        }
    }

    private void _validateName(long groupId, long parentKBFolderId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new InvalidKBFolderNameException("KB folder name is null");
        }
        KBFolder kbFolder = this.kbFolderPersistence.fetchByG_P_N(groupId, parentKBFolderId, name);
        if (kbFolder != null) {
            throw new DuplicateKBFolderNameException(String.format("A KB folder with name %s already exists", name));
        }
    }

    private void _validateParent(KBFolder kbFolder, KBFolder parentKBFolder) throws PortalException {
        if (kbFolder.getGroupId() != parentKBFolder.getGroupId()) {
            throw new NoSuchFolderException(String.format("No KB folder with KB folder ID %s found in group %s", parentKBFolder.getKbFolderId(), kbFolder.getGroupId()));
        }
        List ancestorKBFolderIds = parentKBFolder.getAncestorKBFolderIds();
        if (ancestorKBFolderIds.contains(kbFolder.getKbFolderId())) {
            throw new KBFolderParentException(String.format("Cannot move KBFolder %s inside its descendant KBFolder %s", kbFolder.getKbFolderId(), parentKBFolder.getKbFolderId()));
        }
    }

    private void _validateParent(long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        KBFolder parentKBFolder = null;
        if (parentResourceClassNameId == kbFolderClassNameId) {
            if (parentResourcePrimKey == 0L) {
                return;
            }
            parentKBFolder = this.kbFolderPersistence.fetchByPrimaryKey(parentResourcePrimKey);
        }
        if (parentKBFolder == null) {
            throw new NoSuchFolderException(String.format("No KB folder found with KB folder ID %", parentResourcePrimKey));
        }
    }
}

