/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.knowledge.base.configuration.KBGroupServiceConfiguration;
import com.liferay.knowledge.base.exception.KBCommentContentException;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.internal.util.AdminSubscriptionSenderFactory;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBTemplateLocalService;
import com.liferay.knowledge.base.service.base.KBCommentLocalServiceBaseImpl;
import com.liferay.knowledge.base.util.comparator.KBCommentCreateDateComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBComment"}, service={AopService.class})
public class KBCommentLocalServiceImpl
extends KBCommentLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KBCommentLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private JSONFactory _jSONFactory;
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference
    private KBTemplateLocalService _kbTemplateLocalService;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private SocialActivityLocalService _socialActivityLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public KBComment addKBComment(long userId, long classNameId, long classPK, String content, int userRating, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date date = new Date();
        this._validate(content);
        long kbCommentId = this.counterLocalService.increment();
        KBComment kbComment = this.kbCommentPersistence.create(kbCommentId);
        kbComment.setUuid(serviceContext.getUuid());
        kbComment.setGroupId(groupId);
        kbComment.setCompanyId(user.getCompanyId());
        kbComment.setUserId(user.getUserId());
        kbComment.setUserName(user.getFullName());
        kbComment.setCreateDate(serviceContext.getCreateDate(date));
        kbComment.setModifiedDate(serviceContext.getModifiedDate(date));
        kbComment.setClassNameId(classNameId);
        kbComment.setClassPK(classPK);
        kbComment.setContent(content);
        kbComment.setUserRating(userRating);
        kbComment.setStatus(1);
        kbComment = (KBComment)this.kbCommentPersistence.update((BaseModel)kbComment);
        JSONObject extraDataJSONObject = this._jSONFactory.createJSONObject();
        this._putTitle(extraDataJSONObject, kbComment);
        this._socialActivityLocalService.addActivity(userId, kbComment.getGroupId(), KBComment.class.getName(), kbCommentId, 5, extraDataJSONObject.toString(), 0L);
        this._notifySubscribers(userId, kbComment, serviceContext);
        return kbComment;
    }

    public KBComment addKBComment(long userId, long classNameId, long classPK, String content, ServiceContext serviceContext) throws PortalException {
        return this.addKBComment(userId, classNameId, classPK, content, this._getUserRating(userId, classNameId, classPK), serviceContext);
    }

    @Override
    @SystemEvent(type=1)
    public KBComment deleteKBComment(KBComment kbComment) throws PortalException {
        this.kbCommentPersistence.remove((BaseModel)kbComment);
        this._socialActivityLocalService.deleteActivities(KBComment.class.getName(), kbComment.getKbCommentId());
        return kbComment;
    }

    @Override
    public KBComment deleteKBComment(long kbCommentId) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.kbCommentLocalService.deleteKBComment(kbComment);
    }

    public void deleteKBComments(String className, long classPK) throws PortalException {
        List kbComments = this.kbCommentPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        for (KBComment kbComment : kbComments) {
            this.kbCommentLocalService.deleteKBComment(kbComment);
        }
    }

    public KBComment getKBComment(long userId, String className, long classPK) throws PortalException {
        return this.kbCommentPersistence.findByU_C_C_Last(userId, this._classNameLocalService.getClassNameId(className), classPK, (OrderByComparator)new KBCommentCreateDateComparator());
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end) {
        return this.kbCommentPersistence.findByG_S(groupId, status, start, end);
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end, OrderByComparator<KBComment> orderByComparator) {
        return this.kbCommentPersistence.findByG_S(groupId, status, start, end, orderByComparator);
    }

    public List<KBComment> getKBComments(long groupId, int start, int end, OrderByComparator<KBComment> orderByComparator) {
        return this.kbCommentPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<KBComment> getKBComments(long userId, String className, long classPK, int start, int end, OrderByComparator<KBComment> orderByComparator) {
        return this.kbCommentPersistence.findByU_C_C(userId, this._classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public List<KBComment> getKBComments(String className, long classPK, int status, int start, int end) {
        return this.getKBComments(className, classPK, status, start, end, (OrderByComparator<KBComment>)new KBCommentCreateDateComparator());
    }

    public List<KBComment> getKBComments(String className, long classPK, int status, int start, int end, OrderByComparator<KBComment> orderByComparator) {
        return this.kbCommentPersistence.findByC_C_S(this._classNameLocalService.getClassNameId(className), classPK, status, start, end, orderByComparator);
    }

    public List<KBComment> getKBComments(String className, long classPK, int start, int end, OrderByComparator<KBComment> orderByComparator) {
        return this.kbCommentPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public List<KBComment> getKBComments(String className, long classPK, int[] status, int start, int end) {
        return this.kbCommentPersistence.findByC_C_S(this._classNameLocalService.getClassNameId(className), classPK, status, start, end, (OrderByComparator)new KBCommentCreateDateComparator());
    }

    public int getKBCommentsCount(long groupId, int status) {
        return this.kbCommentPersistence.countByG_S(groupId, status);
    }

    public int getKBCommentsCount(long userId, String className, long classPK) {
        return this.kbCommentPersistence.countByU_C_C(userId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public int getKBCommentsCount(String className, long classPK) {
        return this.kbCommentPersistence.countByC_C(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public int getKBCommentsCount(String className, long classPK, int status) {
        return this.kbCommentPersistence.countByC_C_S(this._classNameLocalService.getClassNameId(className), classPK, status);
    }

    public int getKBCommentsCount(String className, long classPK, int[] status) {
        return this.kbCommentPersistence.countByC_C_S(this._classNameLocalService.getClassNameId(className), classPK, status);
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, int userRating, int status, ServiceContext serviceContext) throws PortalException {
        this._validate(content);
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        kbComment.setModifiedDate(serviceContext.getModifiedDate(null));
        kbComment.setClassNameId(classNameId);
        kbComment.setClassPK(classPK);
        kbComment.setContent(content);
        kbComment.setUserRating(userRating);
        kbComment.setStatus(status);
        kbComment = (KBComment)this.kbCommentPersistence.update((BaseModel)kbComment);
        JSONObject extraDataJSONObject = this._jSONFactory.createJSONObject();
        this._putTitle(extraDataJSONObject, kbComment);
        this._socialActivityLocalService.addActivity(kbComment.getUserId(), kbComment.getGroupId(), KBComment.class.getName(), kbCommentId, 6, extraDataJSONObject.toString(), 0L);
        return kbComment;
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, int status, ServiceContext serviceContext) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.updateKBComment(kbCommentId, classNameId, classPK, content, kbComment.getUserRating(), status, serviceContext);
    }

    public KBComment updateStatus(long userId, long kbCommentId, int status, ServiceContext serviceContext) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        kbComment.setStatus(status);
        kbComment = (KBComment)this.kbCommentPersistence.update((BaseModel)kbComment);
        this._notifySubscribers(userId, kbComment, serviceContext);
        return kbComment;
    }

    private String _getEmailKBArticleSuggestionNotificationBody(int status, KBGroupServiceConfiguration kbGroupServiceConfiguration) {
        if (status == 0) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionResolvedBody();
        }
        if (status == 2) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionInProgressBody();
        }
        if (status == 1) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionReceivedBody();
        }
        throw new IllegalArgumentException(String.format("Unknown suggestion status %s", status));
    }

    private String _getEmailKBArticleSuggestionNotificationSubject(int status, KBGroupServiceConfiguration kbGroupServiceConfiguration) {
        if (status == 0) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionResolvedSubject();
        }
        if (status == 2) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionInProgressSubject();
        }
        if (status == 1) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionReceivedSubject();
        }
        throw new IllegalArgumentException(String.format("Unknown suggestion status %s", status));
    }

    private String _getFormattedKBCommentCreateDate(KBComment kbComment, Locale locale) {
        DateFormat dateFormat = DateFormatFactoryUtil.getDate((Locale)locale);
        return dateFormat.format(kbComment.getCreateDate());
    }

    private KBGroupServiceConfiguration _getKBGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (KBGroupServiceConfiguration)this._configurationProvider.getConfiguration(KBGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.knowledge.base"));
    }

    private int _getUserRating(long userId, long classNameId, long classPK) throws PortalException {
        ClassName className = this._classNameLocalService.getClassName(classNameId);
        RatingsEntry ratingsEntry = this._ratingsEntryLocalService.fetchEntry(userId, className.getValue(), classPK);
        if (ratingsEntry == null) {
            return 2;
        }
        if (ratingsEntry.getScore() > 0.0) {
            return 1;
        }
        return 0;
    }

    private boolean _isSuggestionStatusChangeNotificationEnabled(int status, KBGroupServiceConfiguration kbGroupServiceConfiguration) {
        if (status == 0) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionResolvedEnabled();
        }
        if (status == 2) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionInProgressEnabled();
        }
        if (status == 1) {
            return kbGroupServiceConfiguration.emailKBArticleSuggestionReceivedEnabled();
        }
        return false;
    }

    private void _notifySubscribers(long userId, KBComment kbComment, ServiceContext serviceContext) throws PortalException {
        KBGroupServiceConfiguration kbGroupServiceConfiguration = this._getKBGroupServiceConfiguration(kbComment.getGroupId());
        if (!this._isSuggestionStatusChangeNotificationEnabled(kbComment.getStatus(), kbGroupServiceConfiguration)) {
            return;
        }
        KBArticle kbArticle = this._kbArticleLocalService.fetchLatestKBArticle(kbComment.getClassPK(), 0);
        if (kbArticle == null) {
            KBTemplate kbTemplate = this._kbTemplateLocalService.fetchKBTemplate(kbComment.getClassPK());
            if (kbTemplate != null) {
                return;
            }
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle exists with the key {resourcePrimKey=", kbComment.getClassPK(), ", status=", 0, "}"}));
        }
        String fromName = kbGroupServiceConfiguration.emailFromName();
        String fromAddress = kbGroupServiceConfiguration.emailFromAddress();
        String subject = this._getEmailKBArticleSuggestionNotificationSubject(kbComment.getStatus(), kbGroupServiceConfiguration);
        String body = this._getEmailKBArticleSuggestionNotificationBody(kbComment.getStatus(), kbGroupServiceConfiguration);
        String kbArticleContent = StringUtil.replace((String)kbArticle.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + serviceContext.getPortalURL() + "/", "src=\"" + serviceContext.getPortalURL() + "/"});
        SubscriptionSender subscriptionSender = AdminSubscriptionSenderFactory.createSubscriptionSender(kbArticle, serviceContext);
        subscriptionSender.setBody(body);
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", (Object)kbArticleContent, false);
        subscriptionSender.setContextAttribute("[$COMMENT_CONTENT$]", (Object)kbComment.getContent(), false);
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(kbArticle.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedContextAttributeWithFunction("[$COMMENT_CREATE_DATE$]", locale -> this._getFormattedKBCommentCreateDate(kbComment, (Locale)locale), false);
        subscriptionSender.setMailId("kb_article", new Object[]{kbArticle.getKbArticleId()});
        subscriptionSender.setPortletId(serviceContext.getPortletId());
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(kbArticle.getGroupId());
        subscriptionSender.setSubject(subject);
        User user = this._userLocalService.getUser(kbComment.getUserId());
        subscriptionSender.addRuntimeSubscribers(user.getEmailAddress(), user.getFullName());
        subscriptionSender.flushNotificationsAsync();
    }

    private void _putTitle(JSONObject jsonObject, KBComment kbComment) {
        KBArticle kbArticle = null;
        KBTemplate kbTemplate = null;
        String className = kbComment.getClassName();
        try {
            if (className.equals(KBArticle.class.getName())) {
                kbArticle = this._kbArticleLocalService.getLatestKBArticle(kbComment.getClassPK(), 0);
                jsonObject.put("title", kbArticle.getTitle());
            } else if (className.equals(KBTemplate.class.getName())) {
                kbTemplate = this._kbTemplateLocalService.getKBTemplate(kbComment.getClassPK());
                jsonObject.put("title", kbTemplate.getTitle());
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to put title", (Throwable)exception);
        }
    }

    private void _validate(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new KBCommentContentException();
        }
    }
}

