/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.util.AdminHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class KBArticleStagedModelDataHandler
extends BaseStagedModelDataHandler<KBArticle> {
    public static final String[] CLASS_NAMES = new String[]{KBArticle.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(KBArticleStagedModelDataHandler.class);
    @Reference
    private AdminHelper _adminHelper;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ExportImportContentProcessor<String> _kbArticleExportImportContentProcessor;
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference
    private KBFolderLocalService _kbFolderLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public void deleteStagedModel(KBArticle kbArticle) throws PortalException {
        this._kbArticleLocalService.deleteKBArticle(kbArticle);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        KBArticle kbArticle = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (kbArticle != null) {
            this.deleteStagedModel(kbArticle);
        }
    }

    public KBArticle fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._kbArticleLocalService.fetchKBArticleByUuidAndGroupId(uuid, groupId);
    }

    public List<KBArticle> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._kbArticleLocalService.getKBArticlesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(KBArticle kbArticle) {
        return kbArticle.getTitle();
    }

    public int[] getExportableStatuses() {
        return new int[]{0, 7};
    }

    protected boolean countStagedModel(PortletDataContext portletDataContext, KBArticle kbArticle) {
        return !portletDataContext.isModelCounted(KBArticle.class.getName(), (Serializable)Long.valueOf(kbArticle.getResourcePrimKey()));
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, KBArticle kbArticle) throws Exception {
        if (kbArticle.getParentResourcePrimKey() != 0L) {
            long kbArticleClassNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
            if (kbArticle.getParentResourceClassNameId() == kbArticleClassNameId) {
                KBArticle parentKBArticle = this._kbArticleLocalService.getLatestKBArticle(kbArticle.getParentResourcePrimKey(), 0);
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)kbArticle, (StagedModel)parentKBArticle, (String)"parent");
            } else {
                KBFolder parentKBFolder = this._kbFolderLocalService.getKBFolder(kbArticle.getParentResourcePrimKey());
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)kbArticle, (StagedModel)parentKBFolder, (String)"parent");
            }
        }
        this._exportKBArticleAttachments(portletDataContext, kbArticle);
        String content = (String)((Object)this._kbArticleExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)kbArticle, (Serializable)((Object)kbArticle.getContent()), true, true));
        kbArticle.setContent(content);
        Element kbArticleElement = portletDataContext.getExportDataElement((ClassedModel)kbArticle);
        portletDataContext.addClassedModel(kbArticleElement, ExportImportPathUtil.getModelPath((StagedModel)kbArticle), (ClassedModel)kbArticle);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, KBArticle kbArticle) throws Exception {
        KBArticle existingKBArticle;
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)kbArticle, KBArticle.class);
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)kbArticle, KBFolder.class);
        Map kbArticleResourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(KBArticle.class);
        long parentResourceClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        long parentResourcePrimKey = 0L;
        long kbArticleClassNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        if (kbArticleClassNameId == kbArticle.getParentResourceClassNameId()) {
            parentResourceClassNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
            parentResourcePrimKey = MapUtil.getLong((Map)kbArticleResourcePrimKeys, (long)kbArticle.getParentResourcePrimKey(), (long)0L);
        } else if (kbArticle.getParentResourcePrimKey() != 0L) {
            Map kbFolderResourcePrimKeys = portletDataContext.getNewPrimaryKeysMap(KBFolder.class);
            parentResourcePrimKey = MapUtil.getLong((Map)kbFolderResourcePrimKeys, (long)kbArticle.getParentResourcePrimKey(), (long)0L);
        }
        String[] sections = this._adminHelper.unescapeSections(kbArticle.getSections());
        String content = (String)((Object)this._kbArticleExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)kbArticle, (Serializable)((Object)kbArticle.getContent())));
        kbArticle.setContent(content);
        long resourcePrimaryKey = MapUtil.getLong((Map)kbArticleResourcePrimKeys, (long)kbArticle.getResourcePrimKey(), (long)0L);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)kbArticle);
        long userId = portletDataContext.getUserId(kbArticle.getUserUuid());
        KBArticle importedKBArticle = null;
        importedKBArticle = portletDataContext.isDataStrategyMirror() ? ((existingKBArticle = this._findExistingKBArticle(portletDataContext, resourcePrimaryKey, kbArticle, serviceContext)) == null ? this._addKBArticle(userId, parentResourceClassNameId, parentResourcePrimKey, kbArticle, sections, serviceContext) : this._updateKBArticle(userId, existingKBArticle.getResourcePrimKey(), parentResourceClassNameId, parentResourcePrimKey, kbArticle, sections, serviceContext)) : (resourcePrimaryKey == kbArticle.getResourcePrimKey() ? this._addKBArticle(userId, parentResourceClassNameId, parentResourcePrimKey, kbArticle, sections, serviceContext) : this._updateKBArticle(userId, resourcePrimaryKey, parentResourceClassNameId, parentResourcePrimKey, kbArticle, sections, serviceContext));
        this._importKBArticleAttachments(portletDataContext, kbArticle, importedKBArticle);
        portletDataContext.importClassedModel((ClassedModel)kbArticle, (ClassedModel)importedKBArticle);
        if (!kbArticle.isMain()) {
            kbArticleResourcePrimKeys.put(kbArticle.getResourcePrimKey(), importedKBArticle.getResourcePrimKey());
        }
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, KBArticle kbArticle) throws Exception {
        KBArticle existingKBArticle = this.fetchStagedModelByUuidAndGroupId(kbArticle.getUuid(), portletDataContext.getScopeGroupId());
        if (existingKBArticle == null || !existingKBArticle.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)KBArticle.class.getName());
        if (trashHandler.isRestorable(existingKBArticle.getResourcePrimKey())) {
            trashHandler.restoreTrashEntry(portletDataContext.getUserId(kbArticle.getUserUuid()), existingKBArticle.getResourcePrimKey());
        }
    }

    protected void importReferenceStagedModels(PortletDataContext portletDataContext, KBArticle stagedModel) throws PortletDataException {
        super.importReferenceStagedModels(portletDataContext, (StagedModel)stagedModel);
        Element stagedModelElement = portletDataContext.getImportDataStagedModelElement((StagedModel)stagedModel);
        long kbFolderClassNameId = this._portal.getClassNameId(KBFolderConstants.getClassName());
        stagedModel.setParentResourceClassNameId(kbFolderClassNameId);
        Element referencesElement = stagedModelElement.element("references");
        if (referencesElement == null) {
            return;
        }
        long kbArticleClassNameId = this._portal.getClassNameId(KBArticleConstants.getClassName());
        List referenceElements = referencesElement.elements();
        for (Element referenceElement : referenceElements) {
            String referenceType = referenceElement.attributeValue("type");
            if (!referenceType.equals("parent")) continue;
            String className = referenceElement.attributeValue("class-name");
            if (!className.equals(KBArticle.class.getName())) break;
            stagedModel.setParentResourceClassNameId(kbArticleClassNameId);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KBArticle _addKBArticle(long userId, long parentResourceClassNameId, long parentResourcePrimKey, KBArticle kbArticle, String[] sections, ServiceContext serviceContext) throws Exception {
        KBArticle importedKBArticle = this._kbArticleLocalService.addKBArticle(kbArticle.getExternalReferenceCode(), userId, parentResourceClassNameId, parentResourcePrimKey, kbArticle.getTitle(), kbArticle.getUrlTitle(), kbArticle.getContent(), kbArticle.getDescription(), sections, kbArticle.getSourceURL(), kbArticle.getDisplayDate(), kbArticle.getExpirationDate(), kbArticle.getReviewDate(), null, serviceContext);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            this._kbArticleLocalService.updatePriority(importedKBArticle.getResourcePrimKey(), kbArticle.getPriority());
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
        return importedKBArticle;
    }

    private void _exportKBArticleAttachments(PortletDataContext portletDataContext, KBArticle kbArticle) throws Exception {
        for (FileEntry fileEntry : kbArticle.getAttachmentsFileEntries()) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)kbArticle, (StagedModel)fileEntry, (String)"weak");
        }
    }

    private KBArticle _findExistingKBArticle(PortletDataContext portletDataContext, long resourcePrimaryKey, KBArticle kbArticle, ServiceContext serviceContext) {
        KBArticle existingKBArticle = this._kbArticleLocalService.fetchKBArticle(resourcePrimaryKey, portletDataContext.getScopeGroupId(), kbArticle.getVersion());
        if (existingKBArticle != null) {
            return existingKBArticle;
        }
        existingKBArticle = this.fetchStagedModelByUuidAndGroupId(kbArticle.getUuid(), portletDataContext.getScopeGroupId());
        if (existingKBArticle != null) {
            return existingKBArticle;
        }
        serviceContext.setUuid(kbArticle.getUuid());
        existingKBArticle = this._kbArticleLocalService.fetchLatestKBArticle(resourcePrimaryKey, portletDataContext.getScopeGroupId());
        if (existingKBArticle != null) {
            return existingKBArticle;
        }
        Map kbFolderIds = portletDataContext.getNewPrimaryKeysMap(KBFolder.class);
        long kbFolderId = MapUtil.getLong((Map)kbFolderIds, (long)kbArticle.getKbFolderId(), (long)kbArticle.getKbFolderId());
        return this._kbArticleLocalService.fetchLatestKBArticleByUrlTitle(portletDataContext.getScopeGroupId(), kbFolderId, kbArticle.getUrlTitle(), -1);
    }

    private InputStream _getKBArticalAttachmentInputStream(String binPath, PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
            try {
                return FileEntryUtil.getContentStream((FileEntry)fileEntry);
            }
            catch (NoSuchFileException noSuchFileException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchFileException);
                }
                return null;
            }
        }
        return portletDataContext.getZipEntryAsInputStream(binPath);
    }

    private void _importKBArticleAttachments(PortletDataContext portletDataContext, KBArticle kbArticle, KBArticle importedKBArticle) throws Exception {
        List dlFileEntryElements = portletDataContext.getReferenceDataElements((StagedModel)kbArticle, DLFileEntry.class);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(portletDataContext.getCompanyId());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        for (Element dlFileEntryElement : dlFileEntryElements) {
            String path = dlFileEntryElement.attributeValue("path");
            FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
            String binPath = dlFileEntryElement.attributeValue("bin-path");
            try {
                InputStream inputStream = this._getKBArticalAttachmentInputStream(binPath, portletDataContext, fileEntry);
                Throwable throwable = null;
                try {
                    if (inputStream == null) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()));
                        continue;
                    }
                    this._portletFileRepository.addPortletFileEntry(null, portletDataContext.getScopeGroupId(), portletDataContext.getUserId(importedKBArticle.getUserUuid()), KBArticle.class.getName(), importedKBArticle.getClassPK(), "com_liferay_knowledge_base_web_portlet_AdminPortlet", importedKBArticle.getAttachmentsFolderId(), inputStream, fileEntry.getFileName(), fileEntry.getMimeType(), true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (DuplicateFileEntryException duplicateFileEntryException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)duplicateFileEntryException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KBArticle _updateKBArticle(long userId, long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey, KBArticle kbArticle, String[] sections, ServiceContext serviceContext) throws Exception {
        this._kbArticleLocalService.updateKBArticle(userId, resourcePrimKey, kbArticle.getTitle(), kbArticle.getContent(), kbArticle.getDescription(), sections, kbArticle.getSourceURL(), kbArticle.getDisplayDate(), kbArticle.getExpirationDate(), kbArticle.getReviewDate(), null, null, serviceContext);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            this._kbArticleLocalService.moveKBArticle(userId, resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey, kbArticle.getPriority());
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
        return this._kbArticleLocalService.getLatestKBArticle(resourcePrimKey, kbArticle.getStatus());
    }
}

