/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.helper;

import com.liferay.diff.DiffHtml;
import com.liferay.diff.DiffVersion;
import com.liferay.diff.DiffVersionsInfo;
import com.liferay.knowledge.base.internal.util.KBArticleDiffUtil;
import com.liferay.knowledge.base.internal.util.KBSectionEscapeUtil;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.knowledge.base.util.AdminHelper;
import com.liferay.knowledge.base.util.comparator.KBArticleVersionComparator;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AdminHelper.class})
public class AdminHelperImpl
implements AdminHelper {
    @Reference
    private DiffHtml _diffHtml;
    @Reference
    private KBArticleService _kbArticleService;

    public String[] escapeSections(String[] sections) {
        return KBSectionEscapeUtil.escapeSections(sections);
    }

    public DiffVersionsInfo getDiffVersionsInfo(long groupId, long kbArticleResourcePrimKey, int sourceVersion, int targetVersion) {
        double previousVersion = 0.0;
        double nextVersion = 0.0;
        List kbArticles = this._kbArticleService.getKBArticleVersions(groupId, kbArticleResourcePrimKey, 0, -1, -1, (OrderByComparator)new KBArticleVersionComparator());
        for (KBArticle curKBArticle : kbArticles) {
            if (curKBArticle.getVersion() < sourceVersion && (double)curKBArticle.getVersion() > previousVersion) {
                previousVersion = curKBArticle.getVersion();
            }
            if (curKBArticle.getVersion() <= targetVersion || !((double)curKBArticle.getVersion() < nextVersion) && nextVersion != 0.0) continue;
            nextVersion = curKBArticle.getVersion();
        }
        ArrayList<DiffVersion> diffVersions = new ArrayList<DiffVersion>();
        for (KBArticle curKBArticle : kbArticles) {
            DiffVersion diffVersion = new DiffVersion(curKBArticle.getUserId(), (double)curKBArticle.getVersion(), curKBArticle.getModifiedDate());
            diffVersions.add(diffVersion);
        }
        return new DiffVersionsInfo(diffVersions, nextVersion, previousVersion);
    }

    public String getKBArticleDiff(long resourcePrimKey, int sourceVersion, int targetVersion, String param) throws Exception {
        return KBArticleDiffUtil.getKBArticleDiff((UnsafeFunction<Integer, KBArticle, Exception>)((UnsafeFunction)version -> this._kbArticleService.getKBArticle(resourcePrimKey, version.intValue())), sourceVersion, targetVersion, param, this._diffHtml);
    }

    public String[] unescapeSections(String sections) {
        return KBSectionEscapeUtil.unescapeSections(sections);
    }
}

