/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.link.model.AssetLink;
import com.liferay.asset.link.service.AssetLinkLocalService;
import com.liferay.diff.DiffHtml;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.knowledge.base.configuration.KBGroupServiceConfiguration;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.DuplicateKBArticleExternalReferenceCodeException;
import com.liferay.knowledge.base.exception.KBArticleContentException;
import com.liferay.knowledge.base.exception.KBArticleDisplayDateException;
import com.liferay.knowledge.base.exception.KBArticleExpirationDateException;
import com.liferay.knowledge.base.exception.KBArticleParentException;
import com.liferay.knowledge.base.exception.KBArticlePriorityException;
import com.liferay.knowledge.base.exception.KBArticleReviewDateException;
import com.liferay.knowledge.base.exception.KBArticleSourceURLException;
import com.liferay.knowledge.base.exception.KBArticleStatusException;
import com.liferay.knowledge.base.exception.KBArticleTitleException;
import com.liferay.knowledge.base.exception.KBArticleUrlTitleException;
import com.liferay.knowledge.base.exception.LockedKBArticleException;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.internal.configuration.KBServiceConfiguration;
import com.liferay.knowledge.base.internal.helper.KBArticleLocalSiblingNavigationHelper;
import com.liferay.knowledge.base.internal.importer.KBArticleImporter;
import com.liferay.knowledge.base.internal.util.AdminSubscriptionSenderFactory;
import com.liferay.knowledge.base.internal.util.KBArticleDiffUtil;
import com.liferay.knowledge.base.internal.util.KBCommentUtil;
import com.liferay.knowledge.base.internal.util.KBSectionEscapeUtil;
import com.liferay.knowledge.base.markdown.converter.factory.MarkdownConverterFactory;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBArticleTable;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.base.KBArticleLocalServiceBaseImpl;
import com.liferay.knowledge.base.service.persistence.KBCommentPersistence;
import com.liferay.knowledge.base.service.persistence.KBFolderPersistence;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.util.comparator.KBArticlePriorityComparator;
import com.liferay.knowledge.base.util.comparator.KBArticleVersionComparator;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.view.count.ViewCountManager;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.knowledge.base.internal.configuration.KBServiceConfiguration"}, property={"model.class.name=com.liferay.knowledge.base.model.KBArticle"}, service={AopService.class})
public class KBArticleLocalServiceImpl
extends KBArticleLocalServiceBaseImpl {
    private static final String _NOTIFICATION_ACTION_REVIEW = "review";
    private static final String _NOTIFICATION_RECEIVER_OWNER = "owner";
    private static final String _NOTIFICATION_RECEIVER_SUBSCRIBER = "subscriber";
    private static final int[] _STATUSES = new int[]{0, 1};
    private static final Log _log = LogFactoryUtil.getLog(KBArticleLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private BeanProperties _beanProperties;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private final Map<Long, Date> _dates = new ConcurrentHashMap<Long, Date>();
    @Reference
    private DiffHtml _diffHtml;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private KBCommentPersistence _kbCommentPersistence;
    @Reference
    private KBFolderPersistence _kbFolderPersistence;
    private KBServiceConfiguration _kbServiceConfiguration;
    @Reference
    private LockManager _lockManager;
    @Reference
    private MarkdownConverterFactory _markdownConverterFactory;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SocialActivityLocalService _socialActivityLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private ViewCountManager _viewCountManager;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @Reference
    private ZipReaderFactory _zipReaderFactory;

    public FileEntry addAttachment(long userId, long resourcePrimKey, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        KBArticle kbArticle = this.kbArticleLocalService.getLatestKBArticle(resourcePrimKey, -1);
        return this._portletFileRepository.addPortletFileEntry(null, kbArticle.getGroupId(), userId, KBArticle.class.getName(), resourcePrimKey, "com.liferay.knowledge.base", kbArticle.getAttachmentsFolderId(), inputStream, fileName, mimeType, true);
    }

    public KBArticle addKBArticle(String externalReferenceCode, long userId, long parentResourceClassNameId, long parentResourcePrimKey, String title, String urlTitle, String content, String description, String[] sections, String sourceURL, Date displayDate, Date expirationDate, Date reviewDate, String[] selectedFileNames, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        urlTitle = this._normalizeUrlTitle(urlTitle);
        double priority = this._getPriority(groupId, parentResourcePrimKey);
        long kbArticleId = this.counterLocalService.increment();
        this._validateExternalReferenceCode(externalReferenceCode, groupId);
        this._validate(title, content, sourceURL, displayDate, expirationDate, reviewDate);
        this._validateParent(parentResourceClassNameId, parentResourcePrimKey);
        long kbFolderId = KnowledgeBaseUtil.getKBFolderId((long)parentResourceClassNameId, (long)parentResourcePrimKey);
        urlTitle = StringUtil.toLowerCase((String)urlTitle);
        this._validateUrlTitle(groupId, kbFolderId, urlTitle);
        long resourcePrimKey = this.counterLocalService.increment();
        long rootResourcePrimKey = this._getRootResourcePrimKey(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
        KBArticle kbArticle = this.kbArticlePersistence.create(kbArticleId);
        kbArticle.setUuid(serviceContext.getUuid());
        kbArticle.setResourcePrimKey(resourcePrimKey);
        kbArticle.setGroupId(groupId);
        kbArticle.setCompanyId(user.getCompanyId());
        kbArticle.setUserId(user.getUserId());
        kbArticle.setUserName(user.getFullName());
        kbArticle.setExternalReferenceCode(externalReferenceCode);
        kbArticle.setRootResourcePrimKey(rootResourcePrimKey);
        kbArticle.setParentResourceClassNameId(parentResourceClassNameId);
        kbArticle.setParentResourcePrimKey(parentResourcePrimKey);
        kbArticle.setKbFolderId(kbFolderId);
        kbArticle.setVersion(1);
        kbArticle.setTitle(title);
        kbArticle.setUrlTitle(this._getUniqueUrlTitle(groupId, kbFolderId, kbArticleId, title, urlTitle));
        kbArticle.setContent(content);
        kbArticle.setDescription(description);
        kbArticle.setPriority(priority);
        kbArticle.setSections(StringUtil.merge((Object[])KBSectionEscapeUtil.escapeSections(sections)));
        kbArticle.setLatest(true);
        kbArticle.setMain(false);
        kbArticle.setSourceURL(sourceURL);
        kbArticle.setDisplayDate(displayDate);
        kbArticle.setExpirationDate(expirationDate);
        kbArticle.setReviewDate(reviewDate);
        kbArticle.setStatus(2);
        kbArticle.setExpandoBridgeAttributes(serviceContext);
        kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addKBArticleResources(kbArticle, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addKBArticleResources(kbArticle, serviceContext.getModelPermissions());
        }
        this.updateKBArticleAsset(userId, kbArticle, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this._addKBArticleAttachments(userId, kbArticle, selectedFileNames);
        this._startWorkflowInstance(userId, kbArticle, serviceContext);
        return kbArticle;
    }

    public void addKBArticleResources(KBArticle kbArticle, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), kbArticle.getUserId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addKBArticleResources(KBArticle kbArticle, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), kbArticle.getUserId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), modelPermissions);
    }

    public void addKBArticleResources(long kbArticleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        KBArticle kbArticle = this.kbArticlePersistence.findByPrimaryKey(kbArticleId);
        this.addKBArticleResources(kbArticle, addGroupPermissions, addGuestPermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addKBArticlesMarkdown(long userId, long groupId, long parentKbFolderId, String fileName, boolean prioritizeByNumericalPrefix, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            KBArticleImporter kbArticleImporter = new KBArticleImporter(this._configurationProvider, this._markdownConverterFactory.create(), this, this._portal, this._dlURLHelper, this._zipReaderFactory);
            int n = kbArticleImporter.processZipFile(userId, groupId, parentKbFolderId, prioritizeByNumericalPrefix, inputStream, serviceContext);
            return n;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public void addTempAttachment(long groupId, long userId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException {
        TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)tempFolderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public void checkKBArticles(long companyId) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        Date date = new Date();
        long userId = this._userLocalService.getGuestUserId(company.getCompanyId());
        this._checkKBArticlesByDisplayDate(company, date, userId);
        this._checkKBArticlesByExpirationDate(company, date, userId);
        this._dates.computeIfAbsent(companyId, key -> new Date(date.getTime() - this._getKBArticleCheckInterval() * 60000L));
        this._checkKBArticlesByReviewDate(company, date, userId);
        this._dates.put(companyId, date);
    }

    public void deleteGroupKBArticles(long groupId) throws PortalException {
        this.deleteKBArticles(groupId, 0L);
        Group group = this._groupLocalService.getGroup(groupId);
        List subscriptions = this._subscriptionLocalService.getSubscriptions(group.getCompanyId(), KBArticle.class.getName(), groupId);
        for (Subscription subscription : subscriptions) {
            this.unsubscribeGroupKBArticles(subscription.getUserId(), groupId);
        }
    }

    @Override
    @SystemEvent(action=1, type=1)
    public KBArticle deleteKBArticle(KBArticle kbArticle) throws PortalException {
        return this.kbArticleLocalService.deleteKBArticle(PrincipalThreadLocal.getUserId(), kbArticle.getResourcePrimKey(), kbArticle.getVersion());
    }

    @Override
    @SystemEvent(action=1, type=1)
    public KBArticle deleteKBArticle(long resourcePrimKey) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        return this.kbArticleLocalService.deleteKBArticle(PrincipalThreadLocal.getUserId(), kbArticle.getResourcePrimKey(), kbArticle.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemEvent(action=1, type=1)
    public KBArticle deleteKBArticle(long userId, long resourcePrimKey, int version) throws PortalException {
        KBArticle kbArticle = this.kbArticlePersistence.findByR_V(resourcePrimKey, version);
        if (!this.hasKBArticleLock(userId, resourcePrimKey)) {
            this.lockKBArticle(userId, resourcePrimKey);
        }
        try {
            TrashEntry trashEntry;
            this.deleteKBArticles(kbArticle.getGroupId(), kbArticle.getResourcePrimKey());
            this._resourceLocalService.deleteResource(kbArticle.getCompanyId(), KBArticle.class.getName(), 4, kbArticle.getResourcePrimKey());
            this.kbArticlePersistence.removeByResourcePrimKey(kbArticle.getResourcePrimKey());
            KBCommentUtil.deleteKBComments(KBArticle.class.getName(), this._classNameLocalService, kbArticle.getResourcePrimKey(), this._kbCommentPersistence);
            this._deleteAssets(kbArticle);
            this._expandoRowLocalService.deleteRows(kbArticle.getKbArticleId());
            this._ratingsStatsLocalService.deleteStats(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
            this._socialActivityLocalService.deleteActivities(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
            Indexer indexer = this._indexerRegistry.getIndexer(KBArticle.class);
            indexer.delete((Object)kbArticle);
            if (!GroupThreadLocal.isDeleteInProcess()) {
                this._portletFileRepository.deletePortletFolder(kbArticle.getAttachmentsFolderId());
            }
            this._deleteSubscriptions(kbArticle);
            if (kbArticle.isInTrash() && (trashEntry = this._trashEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getResourcePrimKey())) == null) {
                this._trashVersionLocalService.deleteTrashVersion(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
            }
            this._viewCountManager.deleteViewCount(kbArticle.getCompanyId(), this._classNameLocalService.getClassNameId(KBArticle.class), kbArticle.getPrimaryKey());
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(kbArticle.getCompanyId(), kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        }
        finally {
            this.unlockKBArticle(userId, resourcePrimKey);
        }
        return kbArticle;
    }

    public void deleteKBArticles(long groupId, long parentResourcePrimKey) throws PortalException {
        this.deleteKBArticles(groupId, parentResourcePrimKey, true);
    }

    public void deleteKBArticles(long groupId, long parentResourcePrimKey, boolean includeTrashedEntries) throws PortalException {
        for (KBArticle kbArticle : this.getKBArticles(groupId, parentResourcePrimKey, -1, -1, -1, null)) {
            if (!includeTrashedEntries && this._trashHelper.isInTrashExplicitly((TrashedModel)kbArticle)) continue;
            this.kbArticleLocalService.deleteKBArticle(kbArticle);
        }
        for (KBArticle kbArticle : this.getKBArticles(groupId, parentResourcePrimKey, 8, -1, -1, null)) {
            if (!includeTrashedEntries && this._trashHelper.isInTrashExplicitly((TrashedModel)kbArticle)) continue;
            this.kbArticleLocalService.deleteKBArticle(kbArticle);
        }
    }

    public void deleteKBArticles(long[] resourcePrimKeys) throws PortalException {
        List<KBArticle> kbArticles = this.getKBArticles(resourcePrimKeys, -1, null);
        for (KBArticle kbArticle : kbArticles) {
            this.kbArticleLocalService.deleteKBArticle(kbArticle);
        }
    }

    public void deleteTempAttachment(long groupId, long userId, String fileName, String tempFolderName) throws PortalException {
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)userId, (String)tempFolderName, (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KBArticle expireKBArticle(long userId, long resourcePrimKey, ServiceContext serviceContext) throws PortalException {
        if (!this.hasKBArticleLock(userId, resourcePrimKey)) {
            this.lockKBArticle(userId, resourcePrimKey);
        }
        try {
            KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
            if (kbArticle.isDraft() || kbArticle.isPending() || kbArticle.isScheduled()) {
                KBArticle kBArticle = kbArticle;
                return kBArticle;
            }
            kbArticle.setExpirationDate(new Date());
            this.kbArticleLocalService.updateKBArticle(kbArticle);
            KBArticle kBArticle = this.updateStatus(userId, resourcePrimKey, 3, serviceContext);
            return kBArticle;
        }
        finally {
            this.unlockKBArticle(userId, resourcePrimKey);
        }
    }

    public KBArticle fetchFirstChildKBArticle(long groupId, long parentResourcePrimKey) {
        return this.kbArticlePersistence.fetchByG_P_L_NotS_First(groupId, parentResourcePrimKey, true, 8, (OrderByComparator)KBArticlePriorityComparator.getInstance((boolean)true));
    }

    public KBArticle fetchKBArticle(long resourcePrimKey, long groupId, int version) {
        return this.kbArticlePersistence.fetchByR_G_V(resourcePrimKey, groupId, version);
    }

    public KBArticle fetchKBArticleByExternalReferenceCode(long groupId, String externalReferenceCode, int version) {
        return this.kbArticlePersistence.fetchByG_ERC_V(groupId, externalReferenceCode, version);
    }

    public KBArticle fetchKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle) {
        KBArticle kbArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), 0);
        if (kbArticle == null) {
            kbArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle, 1);
        }
        return kbArticle;
    }

    public KBArticle fetchKBArticleByUrlTitle(long groupId, String kbFolderUrlTitle, String urlTitle) {
        List kbArticles = this.kbArticleFinder.findByUrlTitle(groupId, kbFolderUrlTitle, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), _STATUSES, 0, 1);
        if (kbArticles.isEmpty()) {
            return null;
        }
        return (KBArticle)kbArticles.get(0);
    }

    public KBArticle fetchLatestKBArticle(long resourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
        }
        return this.kbArticlePersistence.fetchByR_S_First(resourcePrimKey, status, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
    }

    public KBArticle fetchLatestKBArticle(long resourcePrimKey, long groupId) {
        return this.kbArticlePersistence.fetchByR_G_L_First(resourcePrimKey, groupId, true, null);
    }

    public KBArticle fetchLatestKBArticleByExternalReferenceCode(long groupId, String externalReferenceCode) {
        return this.kbArticlePersistence.fetchByG_ERC_Last(groupId, externalReferenceCode, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
    }

    public KBArticle fetchLatestKBArticleByExternalReferenceCode(long groupId, String externalReferenceCode, int status) {
        KBArticle latestKBArticle = this.kbArticlePersistence.fetchByG_ERC_Last(groupId, externalReferenceCode, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
        if (latestKBArticle == null || status == -1 || latestKBArticle.getStatus() == status) {
            return latestKBArticle;
        }
        return this.kbArticlePersistence.fetchByG_ERC_S_First(groupId, externalReferenceCode, status, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
    }

    public KBArticle fetchLatestKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle, int status) {
        urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)"");
        List kbArticles = null;
        KBArticleVersionComparator orderByComparator = KBArticleVersionComparator.getInstance((boolean)false);
        kbArticles = status == -1 ? this.kbArticlePersistence.findByG_KBFI_UT_NotS(groupId, kbFolderId, urlTitle, 8, 0, 1, (OrderByComparator)orderByComparator) : this.kbArticlePersistence.findByG_KBFI_UT_S(groupId, kbFolderId, urlTitle, status, 0, 1, (OrderByComparator)orderByComparator);
        if (kbArticles.isEmpty()) {
            return null;
        }
        return (KBArticle)kbArticles.get(0);
    }

    public PersistedModel fetchPersistedModel(Serializable primaryKeyObj) {
        PersistedModel persistedModel = (PersistedModel)this.kbArticlePersistence.fetchByPrimaryKey(primaryKeyObj);
        if (persistedModel == null) {
            persistedModel = this.fetchLatestKBArticle(GetterUtil.getLong((Object)primaryKeyObj), 0);
        }
        return persistedModel;
    }

    public List<KBArticle> getAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        return this._getAllDescendantKBArticles(resourcePrimKey, status, orderByComparator, false);
    }

    public List<KBArticle> getCompanyKBArticles(long companyId, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByC_L_NotS(companyId, true, 8, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByC_M_NotS(companyId, true, 8, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public int getCompanyKBArticlesCount(long companyId, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByC_L_NotS(companyId, true, 8);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByC_M_NotS(companyId, true, 8);
        }
        return this.kbArticlePersistence.countByC_S(companyId, status);
    }

    public List<KBArticle> getGroupKBArticles(long groupId, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByG_L_NotS(groupId, true, 8, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_M_NotS(groupId, true, 8, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_S(groupId, status, start, end, orderByComparator);
    }

    public int getGroupKBArticlesCount(long groupId, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByG_L_NotS(groupId, true, 8);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_M_NotS(groupId, true, 8);
        }
        return this.kbArticlePersistence.countByG_S(groupId, status);
    }

    public KBArticle getKBArticle(long resourcePrimKey, int version) throws PortalException {
        return this.kbArticlePersistence.findByR_V(resourcePrimKey, version);
    }

    public List<KBArticle> getKBArticleAndAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        return this._getAllDescendantKBArticles(resourcePrimKey, status, orderByComparator, true);
    }

    public KBArticle getKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle) throws PortalException {
        KBArticle kbArticle = this.fetchKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""));
        if (kbArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle exists with the key {groupId=", groupId, ", kbFolderId=", kbFolderId, ", urlTitle=", urlTitle, "}"}));
        }
        return kbArticle;
    }

    public KBArticle getKBArticleByUrlTitle(long groupId, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        KBArticle kbArticle = this.fetchKBArticleByUrlTitle(groupId, kbFolderUrlTitle, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""));
        if (kbArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle with the key {groupId=", groupId, ", urlTitle=", urlTitle, "} found in a folder with URL title ", kbFolderUrlTitle}));
        }
        return kbArticle;
    }

    public List<KBArticle> getKBArticles(long groupId, long parentResourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByG_P_L_NotS(groupId, parentResourcePrimKey, true, 8, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_P_M_NotS(groupId, parentResourcePrimKey, true, 8, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_P_S(groupId, parentResourcePrimKey, status, start, end, orderByComparator);
    }

    public List<KBArticle> getKBArticles(long[] resourcePrimKeys, int status, OrderByComparator<KBArticle> orderByComparator) {
        List kbArticles = new ArrayList();
        Long[][] params = new Long[][]{ArrayUtil.toArray((long[])resourcePrimKeys)};
        while ((params = KnowledgeBaseUtil.getParams((Long[])params[0])) != null) {
            List curKBArticles = null;
            curKBArticles = status == -1 ? this.kbArticlePersistence.findByR_L_NotS(ArrayUtil.toArray((Long[])params[1]), true, 8) : (status == 0 ? this.kbArticlePersistence.findByR_M_NotS(ArrayUtil.toArray((Long[])params[1]), true, 8) : this.kbArticlePersistence.findByR_S(ArrayUtil.toArray((Long[])params[1]), new int[]{status}));
            kbArticles.addAll(curKBArticles);
        }
        kbArticles = orderByComparator != null ? ListUtil.sort(kbArticles, orderByComparator) : KnowledgeBaseUtil.sort((long[])resourcePrimKeys, kbArticles);
        return Collections.unmodifiableList(kbArticles);
    }

    public int getKBArticlesCount(long groupId, long parentResourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByG_P_L_NotS(groupId, parentResourcePrimKey, true, 8);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_P_M_NotS(groupId, parentResourcePrimKey, true, 8);
        }
        return this.kbArticlePersistence.countByG_P_S(groupId, parentResourcePrimKey, status);
    }

    public List<KBArticle> getKBArticleVersions(long resourcePrimKey, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        if (status == -1) {
            return this.kbArticlePersistence.findByResourcePrimKey(resourcePrimKey, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByR_S(resourcePrimKey, status, start, end, orderByComparator);
    }

    public int getKBArticleVersionsCount(long resourcePrimKey, int status) {
        if (status == -1) {
            return this.kbArticlePersistence.countByResourcePrimKey(resourcePrimKey);
        }
        return this.kbArticlePersistence.countByR_S(resourcePrimKey, status);
    }

    public List<KBArticle> getKBFolderKBArticles(long groupId, long kbFolderId) {
        return this.kbArticlePersistence.findByG_KBFI_L_NotS(groupId, kbFolderId, true, 8);
    }

    public int getKBFolderKBArticlesCount(long groupId, long kbFolderId, int status) {
        return this.kbArticlePersistence.countByG_KBFI_S(groupId, kbFolderId, status);
    }

    public KBArticle getLatestKBArticle(long resourcePrimKey) throws PortalException {
        return this.getLatestKBArticle(resourcePrimKey, -1);
    }

    public KBArticle getLatestKBArticle(long resourcePrimKey, int status) throws PortalException {
        if (status == -1) {
            return this.kbArticlePersistence.findByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
        }
        return this.kbArticlePersistence.findByR_S_First(resourcePrimKey, status, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
    }

    public KBArticle getLatestKBArticle(long resourcePrimKey, int[] statuses) throws PortalException {
        if (ArrayUtil.contains((int[])statuses, (int)-1)) {
            return this.kbArticlePersistence.findByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
        }
        List kbArticles = this.kbArticlePersistence.findByR_S(new long[]{resourcePrimKey}, statuses, 0, 1, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
        if (!kbArticles.isEmpty()) {
            return (KBArticle)kbArticles.get(0);
        }
        return null;
    }

    public KBArticle getLatestKBArticleByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        return this.kbArticlePersistence.findByG_ERC_First(groupId, externalReferenceCode, (OrderByComparator)KBArticleVersionComparator.getInstance((boolean)false));
    }

    public KBArticle getLatestKBArticleByUrlTitle(long groupId, long kbFolderId, String urlTitle, int status) throws PortalException {
        KBArticle latestKBArticle = this.fetchLatestKBArticleByUrlTitle(groupId, kbFolderId, urlTitle = StringUtil.replaceFirst((String)urlTitle, (char)'/', (String)""), status);
        if (latestKBArticle == null) {
            throw new NoSuchArticleException(StringBundler.concat((Object[])new Object[]{"No KBArticle exists with the key {groupId=", groupId, ", kbFolderId=", kbFolderId, ", urlTitle=", urlTitle, ", status=", status, "}"}));
        }
        return latestKBArticle;
    }

    public KBArticle[] getPreviousAndNextKBArticles(long kbArticleId) throws PortalException {
        KBArticleLocalSiblingNavigationHelper kbArticleLocalSiblingNavigationHelper = new KBArticleLocalSiblingNavigationHelper(this.kbArticlePersistence);
        return kbArticleLocalSiblingNavigationHelper.getPreviousAndNextKBArticles(kbArticleId);
    }

    public List<KBArticle> getSectionsKBArticles(long groupId, String[] sections, int status, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        String[] array = KBSectionEscapeUtil.escapeSections(sections);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.quote((String)array[i], (String)"%");
        }
        if (status == -1) {
            return this.kbArticlePersistence.findByG_LikeS_L_NotS(groupId, array, true, 8, start, end, orderByComparator);
        }
        if (status == 0) {
            return this.kbArticlePersistence.findByG_LikeS_M_NotS(groupId, array, true, 8, start, end, orderByComparator);
        }
        return this.kbArticlePersistence.findByG_LikeS_S(groupId, array, status, start, end, orderByComparator);
    }

    public int getSectionsKBArticlesCount(long groupId, String[] sections, int status) {
        String[] array = KBSectionEscapeUtil.escapeSections(sections);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.quote((String)array[i], (String)"%");
        }
        if (status == -1) {
            return this.kbArticlePersistence.countByG_LikeS_L_NotS(groupId, array, true, 8);
        }
        if (status == 0) {
            return this.kbArticlePersistence.countByG_LikeS_M_NotS(groupId, array, true, 8);
        }
        return this.kbArticlePersistence.countByG_LikeS_S(groupId, array, status);
    }

    public String[] getTempAttachmentNames(long groupId, long userId, String tempFolderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)tempFolderName);
    }

    public boolean hasKBArticleLock(long userId, long resourcePrimKey) {
        return this._lockManager.hasLock(userId, KBArticleConstants.getClassName(), resourcePrimKey);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void incrementViewCount(long userId, long resourcePrimKey, int increment) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        long classNameId = this._classNameLocalService.getClassNameId(KBArticle.class);
        this._viewCountManager.incrementViewCount(kbArticle.getCompanyId(), classNameId, kbArticle.getPrimaryKey(), increment);
        if (kbArticle.isApproved() || kbArticle.isFirstVersion()) {
            return;
        }
        kbArticle = this.getLatestKBArticle(resourcePrimKey, 0);
        this._viewCountManager.incrementViewCount(kbArticle.getCompanyId(), classNameId, kbArticle.getPrimaryKey(), increment);
    }

    public Lock lockKBArticle(long userId, long resourcePrimKey) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((long)CompanyThreadLocal.getCompanyId(), (String)"LPD-11003")) {
            return null;
        }
        if (userId <= 0L) {
            Lock lock = this._lockManager.fetchLock(KBArticleConstants.getClassName(), resourcePrimKey);
            if (lock != null) {
                LockedKBArticleException lockedKBArticleException = new LockedKBArticleException();
                lockedKBArticleException.setLock(lock);
                throw lockedKBArticleException;
            }
            return null;
        }
        try {
            return this._lockManager.lock(userId, KBArticleConstants.getClassName(), resourcePrimKey, String.valueOf(userId), false, KBArticleConstants.LOCK_EXPIRATION_TIME);
        }
        catch (DuplicateLockException duplicateLockException) {
            throw new LockedKBArticleException((Throwable)duplicateLockException);
        }
    }

    public void moveDependentKBArticlesToTrash(long parentResourcePrimKey, long trashEntryId) throws PortalException {
        List<KBArticle> allDescendantKBArticles = this.getAllDescendantKBArticles(parentResourcePrimKey, -1, null);
        for (KBArticle descendantKBArticle : allDescendantKBArticles) {
            this._moveDependentKBArticleToTrash(descendantKBArticle, trashEntryId);
        }
    }

    public void moveDependentKBArticleToTrash(KBArticle kbArticle, long trashEntryId) throws PortalException {
        this._moveDependentKBArticleToTrash(kbArticle, trashEntryId);
        this.moveDependentKBArticlesToTrash(kbArticle.getResourcePrimKey(), trashEntryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveKBArticle(long userId, long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey, double priority) throws PortalException {
        if (!this.hasKBArticleLock(userId, resourcePrimKey)) {
            this.lockKBArticle(userId, resourcePrimKey);
        }
        try {
            KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
            if (kbArticle.getResourcePrimKey() == parentResourcePrimKey) {
                return;
            }
            this._validateParent(kbArticle, parentResourceClassNameId, parentResourcePrimKey);
            this._validateParentStatus(parentResourceClassNameId, parentResourcePrimKey, kbArticle.getStatus());
            this._validatePriority(priority);
            this._updatePermissionFields(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
            long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
            long kbFolderId = 0L;
            if (parentResourceClassNameId == kbFolderClassNameId) {
                kbFolderId = parentResourcePrimKey;
            } else {
                KBArticle parentKBArticle = this.getLatestKBArticle(parentResourcePrimKey, -1);
                kbFolderId = parentKBArticle.getKbFolderId();
            }
            List<KBArticle> kbArticles = this.getKBArticleVersions(resourcePrimKey, -1, -1, -1, (OrderByComparator<KBArticle>)KBArticleVersionComparator.getInstance((boolean)false));
            for (KBArticle kBArticle : kbArticles) {
                kBArticle.setParentResourceClassNameId(parentResourceClassNameId);
                kBArticle.setParentResourcePrimKey(parentResourcePrimKey);
                kBArticle.setKbFolderId(kbFolderId);
                kBArticle.setPriority(priority);
                KBArticle kBArticle2 = (KBArticle)this.kbArticlePersistence.update((BaseModel)kBArticle);
                this._indexKBArticle(kBArticle2);
            }
            if (kbArticle.getKbFolderId() != kbFolderId) {
                List<KBArticle> descendantKBArticles = this.getAllDescendantKBArticles(resourcePrimKey, -1, null);
                for (KBArticle curKBArticle : descendantKBArticles) {
                    List<KBArticle> kbArticleVersions = this.getKBArticleVersions(curKBArticle.getResourcePrimKey(), -1, -1, -1, (OrderByComparator<KBArticle>)KBArticleVersionComparator.getInstance((boolean)false));
                    for (KBArticle kbArticleVersion : kbArticleVersions) {
                        kbArticleVersion.setKbFolderId(kbFolderId);
                        kbArticleVersion = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticleVersion);
                        this._indexKBArticle(kbArticleVersion);
                    }
                }
            }
            KBArticle latestKBArticle = this.getLatestKBArticle(resourcePrimKey, -1);
            JSONObject jSONObject = JSONUtil.put((String)"title", (Object)latestKBArticle.getTitle());
            if (latestKBArticle.isApproved() || !latestKBArticle.isFirstVersion()) {
                this._socialActivityLocalService.addActivity(userId, latestKBArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 7, jSONObject.toString(), 0L);
            }
            this._indexKBArticle(latestKBArticle);
        }
        finally {
            this.unlockKBArticle(userId, resourcePrimKey);
        }
    }

    public void moveKBArticleFromTrash(long userId, long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey);
        if (!kbArticle.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)kbArticle)) {
            this.restoreKBArticleFromTrash(userId, resourcePrimKey);
        } else {
            this.restoreDependentKBArticleFromTrash(kbArticle);
        }
        this.moveKBArticle(userId, kbArticle.getResourcePrimKey(), parentResourceClassNameId, parentResourcePrimKey, kbArticle.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KBArticle moveKBArticleToTrash(long userId, long resourcePrimKey) throws PortalException {
        if (!this.hasKBArticleLock(userId, resourcePrimKey)) {
            this.lockKBArticle(userId, resourcePrimKey);
        }
        try {
            KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey);
            if (kbArticle.isInTrash()) {
                throw new TrashEntryException();
            }
            long classPK = kbArticle.getClassPK();
            int oldStatus = kbArticle.getStatus();
            kbArticle = this._updateStatus(userId, kbArticle, 8);
            this._assetEntryLocalService.updateVisible(KBArticle.class.getName(), classPK, false);
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)kbArticle.getTitle());
            this._socialActivityLocalService.addActivity(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 10007, extraDataJSONObject.toString(), 0L);
            TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, kbArticle.getUuid(), null, oldStatus, null, null);
            this.moveDependentKBArticlesToTrash(resourcePrimKey, trashEntry.getEntryId());
            KBArticle kBArticle = kbArticle;
            return kBArticle;
        }
        finally {
            this.unlockKBArticle(userId, resourcePrimKey);
        }
    }

    public void restoreDependentKBArticleFromTrash(KBArticle kbArticle) throws PortalException {
        this._restoreDependentKBArticleFromTrash(kbArticle);
        this.restoreDependentKBArticlesFromTrash(kbArticle.getResourcePrimKey());
    }

    public void restoreDependentKBArticlesFromTrash(long parentResourcePrimKey) throws PortalException {
        List<KBArticle> allDescendantKBArticles = this.getAllDescendantKBArticles(parentResourcePrimKey, 8, null);
        for (KBArticle descendantKBArticle : allDescendantKBArticles) {
            this._restoreDependentKBArticleFromTrash(descendantKBArticle);
        }
    }

    public void restoreKBArticleFromTrash(long userId, long resourcePrimKey) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey);
        if (!kbArticle.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(KBArticle.class.getName(), resourcePrimKey);
        if ((kbArticle = this._updateStatus(userId, kbArticle, trashEntry.getStatus())).isApproved()) {
            this._assetEntryLocalService.updateVisible(KBArticle.class.getName(), resourcePrimKey, true);
        }
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)kbArticle.getTitle());
        this._socialActivityLocalService.addActivity(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 10008, extraDataJSONObject.toString(), 0L);
        this.restoreDependentKBArticlesFromTrash(resourcePrimKey);
        this._trashEntryLocalService.deleteEntry(KBArticle.class.getName(), resourcePrimKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KBArticle revertKBArticle(long userId, long resourcePrimKey, int version, ServiceContext serviceContext) throws PortalException {
        if (!this.hasKBArticleLock(userId, resourcePrimKey)) {
            this.lockKBArticle(userId, resourcePrimKey);
        }
        try {
            KBArticle kbArticle = this.kbArticleLocalService.getKBArticle(resourcePrimKey, version);
            ExpandoBridge expandoBridge = kbArticle.getExpandoBridge();
            serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
            KBArticle kBArticle = this.updateKBArticle(userId, resourcePrimKey, kbArticle.getTitle(), kbArticle.getContent(), kbArticle.getDescription(), StringUtil.split((String)kbArticle.getSections()), kbArticle.getSourceURL(), kbArticle.getDisplayDate(), kbArticle.getExpirationDate(), kbArticle.getReviewDate(), null, null, serviceContext);
            return kBArticle;
        }
        finally {
            this.unlockKBArticle(userId, resourcePrimKey);
        }
    }

    public List<KBArticle> search(long groupId, String title, String content, int status, Date startDate, Date endDate, boolean andOperator, int start, int end, OrderByComparator<KBArticle> orderByComparator) {
        DynamicQuery dynamicQuery = this._buildDynamicQuery(groupId, title, content, status, startDate, endDate, andOperator);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public void subscribeGroupKBArticles(long userId, long groupId) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, KBArticle.class.getName(), groupId);
    }

    public void subscribeKBArticle(long userId, long groupId, long resourcePrimKey) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, KBArticle.class.getName(), resourcePrimKey);
    }

    public void unlockKBArticle(long userId, long resourcePrimKey) {
        this.unlockKBArticle(userId, resourcePrimKey, false);
    }

    public void unlockKBArticle(long userId, long resourcePrimKey, boolean force) {
        if (!FeatureFlagManagerUtil.isEnabled((long)CompanyThreadLocal.getCompanyId(), (String)"LPD-11003")) {
            return;
        }
        if (force || this._lockManager.hasLock(userId, KBArticleConstants.getClassName(), resourcePrimKey)) {
            this._lockManager.unlock(KBArticleConstants.getClassName(), resourcePrimKey);
        }
    }

    public void unsubscribeGroupKBArticles(long userId, long groupId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, KBArticle.class.getName(), groupId);
    }

    public void unsubscribeKBArticle(long userId, long resourcePrimKey) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, KBArticle.class.getName(), resourcePrimKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KBArticle updateAndUnlockKBArticle(long userId, long resourcePrimKey, String title, String content, String description, String[] sections, String sourceURL, Date displayDate, Date expirationDate, Date reviewDate, String[] selectedFileNames, long[] removeFileEntryIds, ServiceContext serviceContext) throws PortalException {
        try {
            KBArticle kBArticle = this.updateKBArticle(userId, resourcePrimKey, title, content, description, sections, sourceURL, displayDate, expirationDate, reviewDate, selectedFileNames, removeFileEntryIds, serviceContext);
            return kBArticle;
        }
        finally {
            this.unlockKBArticle(userId, resourcePrimKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KBArticle updateKBArticle(long userId, long resourcePrimKey, String title, String content, String description, String[] sections, String sourceURL, Date displayDate, Date expirationDate, Date reviewDate, String[] selectedFileNames, long[] removeFileEntryIds, ServiceContext serviceContext) throws PortalException {
        boolean autoLock = false;
        if (!this.hasKBArticleLock(userId, resourcePrimKey)) {
            this.lockKBArticle(userId, resourcePrimKey);
            autoLock = true;
        }
        try {
            User user = this._userLocalService.getUser(userId);
            this._validate(title, content, sourceURL, displayDate, expirationDate, reviewDate);
            KBArticle oldKBArticle = this.getLatestKBArticle(resourcePrimKey, -1);
            int oldVersion = oldKBArticle.getVersion();
            KBArticle kbArticle = null;
            if (oldKBArticle.isApproved() || oldKBArticle.isExpired()) {
                long kbArticleId = this.counterLocalService.increment();
                kbArticle = this.kbArticlePersistence.create(kbArticleId);
                kbArticle.setUuid(serviceContext.getUuid());
                kbArticle.setResourcePrimKey(oldKBArticle.getResourcePrimKey());
                kbArticle.setGroupId(oldKBArticle.getGroupId());
                kbArticle.setCompanyId(user.getCompanyId());
                kbArticle.setUserId(user.getUserId());
                kbArticle.setUserName(user.getFullName());
                kbArticle.setCreateDate(oldKBArticle.getCreateDate());
                kbArticle.setExternalReferenceCode(oldKBArticle.getExternalReferenceCode());
                kbArticle.setRootResourcePrimKey(oldKBArticle.getRootResourcePrimKey());
                kbArticle.setParentResourceClassNameId(oldKBArticle.getParentResourceClassNameId());
                kbArticle.setParentResourcePrimKey(oldKBArticle.getParentResourcePrimKey());
                kbArticle.setKbFolderId(oldKBArticle.getKbFolderId());
                kbArticle.setVersion(oldVersion + 1);
                kbArticle.setUrlTitle(oldKBArticle.getUrlTitle());
                kbArticle.setPriority(oldKBArticle.getPriority());
                this._viewCountManager.incrementViewCount(kbArticle.getCompanyId(), this._classNameLocalService.getClassNameId(KBArticle.class), kbArticle.getPrimaryKey(), (int)oldKBArticle.getViewCount());
                Indexer indexer = this._indexerRegistry.getIndexer(KBArticle.class);
                indexer.delete((Object)oldKBArticle);
            } else {
                kbArticle = oldKBArticle;
            }
            if (oldKBArticle.isPending()) {
                kbArticle.setStatus(1);
            } else {
                kbArticle.setStatus(2);
            }
            kbArticle.setTitle(title);
            kbArticle.setContent(content);
            kbArticle.setDescription(description);
            kbArticle.setSections(StringUtil.merge((Object[])KBSectionEscapeUtil.escapeSections(sections)));
            kbArticle.setLatest(true);
            kbArticle.setMain(false);
            kbArticle.setSourceURL(sourceURL);
            kbArticle.setDisplayDate(displayDate);
            kbArticle.setExpirationDate(expirationDate);
            kbArticle.setReviewDate(reviewDate);
            kbArticle.setExpandoBridgeAttributes(serviceContext);
            kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
            if (oldKBArticle.isApproved() || oldKBArticle.isExpired()) {
                oldKBArticle.setModifiedDate(oldKBArticle.getModifiedDate());
                oldKBArticle.setLatest(false);
                this.kbArticlePersistence.update((BaseModel)oldKBArticle);
            }
            this.updateKBArticleAsset(userId, kbArticle, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
            this._addKBArticleAttachments(userId, kbArticle, selectedFileNames);
            this._removeKBArticleAttachments(removeFileEntryIds);
            this._indexKBArticle(kbArticle);
            this._startWorkflowInstance(userId, kbArticle, serviceContext);
            KBArticle kBArticle = kbArticle;
            return kBArticle;
        }
        finally {
            if (autoLock && this.hasKBArticleLock(userId, resourcePrimKey)) {
                this.unlockKBArticle(userId, resourcePrimKey);
            }
        }
    }

    public void updateKBArticleAsset(long userId, KBArticle kbArticle, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        boolean visible = false;
        if (kbArticle.isApproved()) {
            visible = true;
        }
        String summary = this._htmlParser.extractText(StringUtil.shorten((String)kbArticle.getContent(), (int)500));
        AssetEntry assetEntry = this._assetEntryLocalService.updateEntry(userId, kbArticle.getGroupId(), kbArticle.getCreateDate(), kbArticle.getModifiedDate(), KBArticle.class.getName(), kbArticle.getClassPK(), kbArticle.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, null, kbArticle.getExpirationDate(), "text/html", kbArticle.getTitle(), kbArticle.getDescription(), summary, null, null, 0, 0, null);
        this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public void updateKBArticleResources(KBArticle kbArticle, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this._resourceLocalService.updateResources(kbArticle.getCompanyId(), kbArticle.getGroupId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void updateKBArticlesPriorities(Map<Long, Double> resourcePrimKeyToPriorityMap) throws PortalException {
        for (double priority : resourcePrimKeyToPriorityMap.values()) {
            this._validatePriority(priority);
        }
        long[] resourcePrimKeys = StringUtil.split((String)StringUtil.merge(resourcePrimKeyToPriorityMap.keySet()), (long)0L);
        List<KBArticle> kbArticles = this.getKBArticles(resourcePrimKeys, -1, null);
        for (KBArticle kbArticle : kbArticles) {
            double priority = resourcePrimKeyToPriorityMap.get(kbArticle.getResourcePrimKey());
            this.updatePriority(kbArticle.getResourcePrimKey(), priority);
        }
    }

    public void updatePriority(long resourcePrimKey, double priority) {
        List<KBArticle> kbArticleVersions = this.getKBArticleVersions(resourcePrimKey, -1, -1, -1, null);
        for (KBArticle kbArticle : kbArticleVersions) {
            kbArticle.setPriority(priority);
            this.kbArticlePersistence.update((BaseModel)kbArticle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KBArticle updateStatus(long userId, long resourcePrimKey, int status, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        boolean main = false;
        Date date = new Date();
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        if (status == 0) {
            main = true;
            if (date.before(kbArticle.getDisplayDate())) {
                status = 7;
            }
        }
        this._validateParentStatus(kbArticle.getParentResourceClassNameId(), kbArticle.getParentResourcePrimKey(), status);
        kbArticle.setMain(main);
        kbArticle.setStatus(status);
        kbArticle.setStatusByUserId(user.getUserId());
        kbArticle.setStatusByUserName(user.getFullName());
        kbArticle.setStatusDate(serviceContext.getModifiedDate(date));
        kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (status != 0 && status != 3) {
            return kbArticle;
        }
        if (!kbArticle.isFirstVersion()) {
            KBArticle oldKBArticle = this.kbArticlePersistence.findByR_V(resourcePrimKey, kbArticle.getVersion() - 1);
            oldKBArticle.setModifiedDate(oldKBArticle.getModifiedDate());
            oldKBArticle.setMain(false);
            oldKBArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)oldKBArticle);
            Indexer indexer = this._indexerRegistry.getIndexer(KBArticle.class);
            indexer.delete((Object)oldKBArticle);
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        if (status == 0) {
            assetEntry = this._assetEntryLocalService.getEntry(KBArticle.class.getName(), kbArticle.getKbArticleId());
        }
        List assetLinks = this._assetLinkLocalService.getDirectLinks(assetEntry.getEntryId(), 0);
        long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
        this.updateKBArticleAsset(userId, kbArticle, assetEntry.getCategoryIds(), assetEntry.getTagNames(), assetLinkEntryIds);
        SystemEventHierarchyEntryThreadLocal.push(KBArticle.class);
        try {
            this._assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getKbArticleId());
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(KBArticle.class);
        }
        boolean visible = false;
        if (kbArticle.isApproved()) {
            visible = true;
        }
        this._assetEntryLocalService.updateVisible(KBArticle.class.getName(), kbArticle.getResourcePrimKey(), visible);
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)kbArticle.getTitle());
        if (!kbArticle.isFirstVersion()) {
            this._socialActivityLocalService.addActivity(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 3, extraDataJSONObject.toString(), 0L);
        } else {
            this._socialActivityLocalService.addActivity(userId, kbArticle.getGroupId(), KBArticle.class.getName(), resourcePrimKey, 1, extraDataJSONObject.toString(), 0L);
        }
        this._indexKBArticle(kbArticle);
        Set receivers = SetUtil.fromArray((Object[])new String[]{_NOTIFICATION_RECEIVER_SUBSCRIBER});
        if (status == 3) {
            receivers.add(_NOTIFICATION_RECEIVER_OWNER);
        }
        this._notify(receivers, userId, kbArticle, this._getAction(kbArticle, status), serviceContext);
        return kbArticle;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._kbServiceConfiguration = (KBServiceConfiguration)ConfigurableUtil.createConfigurable(KBServiceConfiguration.class, properties);
    }

    private void _addKBArticleAttachment(long userId, long groupId, long resourcePrimKey, String selectedFileName) throws PortalException {
        FileEntry tempFileEntry = TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)"com.liferay.knowledge.base.admin", (String)selectedFileName);
        InputStream inputStream = tempFileEntry.getContentStream();
        this.addAttachment(userId, resourcePrimKey, selectedFileName, inputStream, tempFileEntry.getMimeType());
        if (tempFileEntry != null) {
            TempFileEntryUtil.deleteTempFileEntry((long)tempFileEntry.getFileEntryId());
        }
    }

    private void _addKBArticleAttachments(long userId, KBArticle kbArticle, String[] selectedFileNames) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])selectedFileNames)) {
            return;
        }
        for (String selectedFileName : selectedFileNames) {
            this._addKBArticleAttachment(userId, kbArticle.getGroupId(), kbArticle.getResourcePrimKey(), selectedFileName);
        }
    }

    private DynamicQuery _buildDynamicQuery(long groupId, String title, String content, int status, Date startDate, Date endDate, boolean andOperator) {
        Property property;
        Object junction = null;
        junction = andOperator ? RestrictionsFactoryUtil.conjunction() : RestrictionsFactoryUtil.disjunction();
        HashMap<String, String> terms = new HashMap<String, String>();
        if (Validator.isNotNull((String)title)) {
            terms.put("title", title);
        }
        if (Validator.isNotNull((String)content)) {
            terms.put("content", content);
        }
        for (Map.Entry entry : terms.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            for (String keyword : KnowledgeBaseUtil.splitKeywords((String)value)) {
                Criterion criterion = RestrictionsFactoryUtil.ilike((String)key, (Object)StringUtil.quote((String)keyword, (String)"%"));
                disjunction.add(criterion);
            }
            junction.add((Criterion)disjunction);
        }
        if (status != -1) {
            Property property2 = PropertyFactoryUtil.forName((String)"status");
            junction.add(property2.eq((Object)status));
        }
        if (endDate != null && startDate != null) {
            String[] propertyNames;
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            for (String propertyName : propertyNames = new String[]{"createDate", "modifiedDate"}) {
                Property property3 = PropertyFactoryUtil.forName((String)propertyName);
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(property3.gt((Object)startDate));
                conjunction.add(property3.lt((Object)endDate));
                disjunction.add((Criterion)conjunction);
            }
            junction.add((Criterion)disjunction);
        }
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KBArticle.class, (ClassLoader)this.getClassLoader());
        if (status == -1) {
            property = PropertyFactoryUtil.forName((String)"latest");
            dynamicQuery.add(property.eq((Object)Boolean.TRUE));
        } else if (status == 0) {
            property = PropertyFactoryUtil.forName((String)"main");
            dynamicQuery.add(property.eq((Object)Boolean.TRUE));
        }
        if (groupId > 0L) {
            property = PropertyFactoryUtil.forName((String)"groupId");
            dynamicQuery.add(property.eq((Object)groupId));
        }
        return dynamicQuery.add((Criterion)junction);
    }

    private void _checkKBArticlesByDisplayDate(Company company, Date displayDate, long userId) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Publishing knowledge base articles with display date ", "prior to ", displayDate, " for company ", company.getCompanyId()}));
        }
        List<KBArticle> kbArticles = this._getKBArticlesByCompanyIdAndDisplayDate(company.getCompanyId(), displayDate);
        for (KBArticle kbArticle : kbArticles) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Publish knowledge base article ", kbArticle.getKbArticleId(), " with display date ", kbArticle.getDisplayDate()}));
            }
            this.updateStatus(userId, kbArticle.getResourcePrimKey(), 0, this._getServiceContext(company, kbArticle));
        }
    }

    private void _checkKBArticlesByExpirationDate(Company company, Date expirationDate, long userId) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Expiring knowledge base articles with expiration date ", "prior to ", expirationDate, " for company ", company.getCompanyId()}));
        }
        List<KBArticle> kbArticles = this._getKBArticlesByCompanyIdAndExpirationDate(company.getCompanyId(), expirationDate);
        for (KBArticle kbArticle : kbArticles) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Expiring knowledge base article ", kbArticle.getKbArticleId(), " with expiration date ", kbArticle.getExpirationDate()}));
            }
            this.updateStatus(userId, kbArticle.getResourcePrimKey(), 3, this._getServiceContext(company, kbArticle));
        }
    }

    private void _checkKBArticlesByReviewDate(Company company, Date reviewDate, long userId) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sending review notification for knowledge base articles ", "with review date between ", this._dates.get(company.getCompanyId()), " and ", reviewDate, " for company ", company.getCompanyId()}));
        }
        List<KBArticle> kbArticles = this._getKBArticlesByCompanyIdAndReviewDate(company.getCompanyId(), this._dates.get(company.getCompanyId()), reviewDate);
        for (KBArticle kbArticle : kbArticles) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sending review notification for knowledge base ", "article ", kbArticle.getKbArticleId(), " with reviewDate ", kbArticle.getReviewDate()}));
            }
            this._notify(SetUtil.fromArray((Object[])new String[]{_NOTIFICATION_RECEIVER_OWNER, _NOTIFICATION_RECEIVER_SUBSCRIBER}), userId, kbArticle, _NOTIFICATION_ACTION_REVIEW, this._getServiceContext(company, kbArticle));
        }
    }

    private void _deleteAssets(KBArticle kbArticle) throws PortalException {
        int kbArticleVersionsCount;
        this._assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getClassPK());
        if (!(kbArticle.isApproved() || (kbArticleVersionsCount = this.kbArticleLocalService.getKBArticleVersionsCount(kbArticle.getResourcePrimKey(), -1)) != 0 && kbArticle.isFirstVersion())) {
            this._assetEntryLocalService.deleteEntry(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        }
    }

    private void _deleteSubscriptions(KBArticle kbArticle) throws PortalException {
        List subscriptions = this._subscriptionLocalService.getSubscriptions(kbArticle.getCompanyId(), KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        for (Subscription subscription : subscriptions) {
            this.unsubscribeKBArticle(subscription.getUserId(), subscription.getClassPK());
        }
    }

    private String _getAction(KBArticle kbArticle, int status) {
        if (status == 3) {
            return "expire";
        }
        if (kbArticle.isFirstVersion()) {
            return "add";
        }
        return "update";
    }

    private void _getAllDescendantKBArticles(List<KBArticle> kbArticles, long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator) {
        List curKBArticles = null;
        curKBArticles = status == -1 ? this.kbArticlePersistence.findByP_L_NotS(resourcePrimKey, true, 8, -1, -1, orderByComparator) : (status == 0 ? this.kbArticlePersistence.findByP_M_NotS(resourcePrimKey, true, 8, -1, -1, orderByComparator) : this.kbArticlePersistence.findByP_S(resourcePrimKey, status, -1, -1, orderByComparator));
        for (KBArticle curKBArticle : curKBArticles) {
            kbArticles.add(curKBArticle);
            this._getAllDescendantKBArticles(kbArticles, curKBArticle.getResourcePrimKey(), status, orderByComparator);
        }
    }

    private List<KBArticle> _getAllDescendantKBArticles(long resourcePrimKey, int status, OrderByComparator<KBArticle> orderByComparator, boolean includeParentArticle) {
        List<Object> kbArticles = null;
        if (includeParentArticle) {
            kbArticles = this.getKBArticles(new long[]{resourcePrimKey}, status, null);
            kbArticles = ListUtil.copy(kbArticles);
        } else {
            kbArticles = new ArrayList<KBArticle>();
        }
        this._getAllDescendantKBArticles(kbArticles, resourcePrimKey, status, orderByComparator);
        return Collections.unmodifiableList(kbArticles);
    }

    private String _getBody(String action, KBGroupServiceConfiguration kbGroupServiceConfiguration) {
        if (Objects.equals(action, "add")) {
            return kbGroupServiceConfiguration.emailKBArticleAddedBody();
        }
        if (Objects.equals(action, "expire")) {
            return kbGroupServiceConfiguration.emailKBArticleExpiredBody();
        }
        if (Objects.equals(action, _NOTIFICATION_ACTION_REVIEW)) {
            return kbGroupServiceConfiguration.emailKBArticleReviewBody();
        }
        return kbGroupServiceConfiguration.emailKBArticleUpdatedBody();
    }

    private Map<String, String> _getEmailKBArticleDiffs(KBArticle kbArticle) {
        HashMap<String, String> emailKBArticleDiffs = new HashMap<String, String>();
        for (String param : new String[]{"content", "title"}) {
            String value = this._beanProperties.getString((Object)kbArticle, param);
            try {
                value = KBArticleDiffUtil.getKBArticleDiff((UnsafeFunction<Integer, KBArticle, Exception>)((UnsafeFunction)version -> this.getKBArticle(kbArticle.getResourcePrimKey(), (int)version)), kbArticle.getVersion() - 1, kbArticle.getVersion(), param, this._diffHtml);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            emailKBArticleDiffs.put(param, value);
        }
        return emailKBArticleDiffs;
    }

    private long _getKBArticleCheckInterval() {
        return this._kbServiceConfiguration.checkInterval();
    }

    private List<KBArticle> _getKBArticlesByCompanyIdAndDisplayDate(long companyId, Date displayDate) {
        return (List)this.kbArticlePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)KBArticleTable.INSTANCE).from((Table)KBArticleTable.INSTANCE).where(KBArticleTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)KBArticleTable.INSTANCE.displayDate.lte((Object)displayDate)).and((Expression)KBArticleTable.INSTANCE.latest.eq((Object)Boolean.TRUE)).and((Expression)KBArticleTable.INSTANCE.status.eq((Object)7)).and((Expression)KBArticleTable.INSTANCE.status.neq((Object)2)).and((Expression)KBArticleTable.INSTANCE.status.neq((Object)1))).orderBy(new OrderByExpression[]{KBArticleTable.INSTANCE.createDate.ascending()}));
    }

    private List<KBArticle> _getKBArticlesByCompanyIdAndExpirationDate(long companyId, Date expirationDate) {
        return (List)this.kbArticlePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)KBArticleTable.INSTANCE).from((Table)KBArticleTable.INSTANCE).where(KBArticleTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)KBArticleTable.INSTANCE.expirationDate.lte((Object)expirationDate)).and((Expression)KBArticleTable.INSTANCE.latest.eq((Object)Boolean.TRUE)).and((Expression)KBArticleTable.INSTANCE.status.neq((Object)2)).and((Expression)KBArticleTable.INSTANCE.status.neq((Object)3)).and((Expression)KBArticleTable.INSTANCE.status.neq((Object)1)).and((Expression)KBArticleTable.INSTANCE.status.neq((Object)7))));
    }

    private List<KBArticle> _getKBArticlesByCompanyIdAndReviewDate(long companyId, Date reviewDateGT, Date reviewDateLTE) {
        return (List)this.kbArticlePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)KBArticleTable.INSTANCE).from((Table)KBArticleTable.INSTANCE).where(KBArticleTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)KBArticleTable.INSTANCE.latest.eq((Object)Boolean.TRUE)).and((Expression)KBArticleTable.INSTANCE.reviewDate.gt((Object)reviewDateGT)).and((Expression)KBArticleTable.INSTANCE.reviewDate.lte((Object)reviewDateLTE))));
    }

    private String _getKBArticleURL(KBArticle kbArticle) throws PortalException {
        String controlPanelFullURL = this._portal.getControlPanelFullURL(kbArticle.getGroupId(), "com_liferay_knowledge_base_web_portlet_AdminPortlet", null);
        String namespace = this._portal.getPortletNamespace("com_liferay_knowledge_base_web_portlet_AdminPortlet");
        String kbArticleURL = HttpComponentsUtil.addParameter((String)controlPanelFullURL, (String)(namespace + "mvcRenderCommandName"), (String)"/knowledge_base/view_kb_article");
        kbArticleURL = HttpComponentsUtil.addParameter((String)kbArticleURL, (String)(namespace + "redirect"), (String)HttpComponentsUtil.addParameter((String)controlPanelFullURL, (String)(namespace + "mvcRenderCommandName"), (String)"/knowledge_base/view"));
        kbArticleURL = HttpComponentsUtil.addParameter((String)kbArticleURL, (String)(namespace + "resourceClassNameId"), (long)kbArticle.getClassNameId());
        kbArticleURL = HttpComponentsUtil.addParameter((String)kbArticleURL, (String)(namespace + "resourcePrimKey"), (long)kbArticle.getResourcePrimKey());
        kbArticleURL = HttpComponentsUtil.addParameter((String)kbArticleURL, (String)(namespace + "selectedItemId"), (long)kbArticle.getResourcePrimKey());
        return kbArticleURL;
    }

    private KBGroupServiceConfiguration _getKBGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (KBGroupServiceConfiguration)this._configurationProvider.getConfiguration(KBGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.knowledge.base"));
    }

    private int _getNotificationType(String action) {
        if (Objects.equals(action, "add")) {
            return 0;
        }
        if (Objects.equals(action, "expire")) {
            return 3;
        }
        if (Objects.equals(action, _NOTIFICATION_ACTION_REVIEW)) {
            return 2;
        }
        return 1;
    }

    private double _getPriority(long groupId, long parentResourcePrimKey) throws PortalException {
        KBGroupServiceConfiguration kbGroupServiceConfiguration = this._getKBGroupServiceConfiguration(groupId);
        if (!kbGroupServiceConfiguration.articleIncrementPriorityEnabled()) {
            return 1.0;
        }
        List<KBArticle> kbArticles = this.getKBArticles(groupId, parentResourcePrimKey, -1, 0, 1, (OrderByComparator<KBArticle>)KBArticlePriorityComparator.getInstance((boolean)false));
        if (kbArticles.isEmpty()) {
            return 1.0;
        }
        KBArticle kbArticle = kbArticles.get(0);
        return Math.floor(kbArticle.getPriority()) + 1.0;
    }

    private long _getRootResourcePrimKey(long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        if (parentResourcePrimKey == 0L) {
            return resourcePrimKey;
        }
        long classNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        if (parentResourceClassNameId == classNameId) {
            KBArticle kbArticle = this.getLatestKBArticle(parentResourcePrimKey, -1);
            return kbArticle.getRootResourcePrimKey();
        }
        return resourcePrimKey;
    }

    private ServiceContext _getServiceContext(Company company, KBArticle kbArticle) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setPlid(0L);
        serviceContext.setPortalURL(company.getPortalURL(kbArticle.getGroupId()));
        serviceContext.setPortletId("com_liferay_knowledge_base_web_portlet_AdminPortlet");
        serviceContext.setScopeGroupId(kbArticle.getGroupId());
        return serviceContext;
    }

    private String _getSubject(String action, KBGroupServiceConfiguration kbGroupServiceConfiguration) {
        if (Objects.equals(action, "add")) {
            return kbGroupServiceConfiguration.emailKBArticleAddedSubject();
        }
        if (Objects.equals(action, "expire")) {
            return kbGroupServiceConfiguration.emailKBArticleExpiredSubject();
        }
        if (Objects.equals(action, _NOTIFICATION_ACTION_REVIEW)) {
            return kbGroupServiceConfiguration.emailKBArticleReviewSubject();
        }
        return kbGroupServiceConfiguration.emailKBArticleUpdatedSubject();
    }

    private String _getUniqueUrlTitle(long groupId, long kbFolderId, long kbArticleId, String title) throws PortalException {
        String urlTitle;
        String uniqueUrlTitle = urlTitle = KnowledgeBaseUtil.getUrlTitle((long)kbArticleId, (String)title);
        if (kbFolderId == 0L) {
            int kbArticlesCount = this.kbArticlePersistence.countByG_KBFI_UT_S(groupId, kbFolderId, uniqueUrlTitle, _STATUSES);
            int i = 1;
            while (kbArticlesCount > 0) {
                uniqueUrlTitle = this._getUniqueUrlTitle(urlTitle, i);
                kbArticlesCount = this.kbArticlePersistence.countByG_KBFI_UT_S(groupId, kbFolderId, uniqueUrlTitle, _STATUSES);
                ++i;
            }
            return uniqueUrlTitle;
        }
        KBFolder kbFolder = this._kbFolderPersistence.findByPrimaryKey(kbFolderId);
        int kbArticlesCount = this.kbArticleFinder.countByUrlTitle(groupId, kbFolder.getUrlTitle(), uniqueUrlTitle, _STATUSES);
        int i = 1;
        while (kbArticlesCount > 0) {
            uniqueUrlTitle = this._getUniqueUrlTitle(urlTitle, i);
            kbArticlesCount = this.kbArticleFinder.countByUrlTitle(groupId, kbFolder.getUrlTitle(), uniqueUrlTitle, _STATUSES);
            ++i;
        }
        return uniqueUrlTitle;
    }

    private String _getUniqueUrlTitle(long groupId, long kbFolderId, long kbArticleId, String title, String urlTitle) throws PortalException {
        if (Validator.isNull((String)urlTitle)) {
            return this._getUniqueUrlTitle(groupId, kbFolderId, kbArticleId, title);
        }
        return urlTitle.substring(1);
    }

    private String _getUniqueUrlTitle(String urlTitle, int suffix) {
        String uniqueUrlTitle = urlTitle + "-" + suffix;
        return StringUtil.shorten((String)uniqueUrlTitle, (int)ModelHintsUtil.getMaxLength((String)KBArticle.class.getName(), (String)"urlTitle"), (String)("-" + suffix));
    }

    private void _indexKBArticle(KBArticle kbArticle) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Indexer indexer = this._indexerRegistry.getIndexer(KBArticle.class);
            indexer.reindex((Object)kbArticle);
            return null;
        });
    }

    private void _moveDependentKBArticleToTrash(KBArticle kbArticle, long trashEntryId) throws PortalException {
        if (kbArticle.isInTrash()) {
            throw new TrashEntryException();
        }
        long classPK = kbArticle.getClassPK();
        int status = kbArticle.getStatus();
        kbArticle.setStatus(8);
        kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (status == 1) {
            status = 2;
        }
        if (status != 0) {
            this._trashVersionLocalService.addTrashVersion(trashEntryId, KBArticle.class.getName(), kbArticle.getResourcePrimKey(), status, null);
        }
        this._assetEntryLocalService.updateVisible(KBArticle.class.getName(), classPK, false);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KBArticle.class);
        indexer.reindex((Object)kbArticle);
    }

    private String _normalizeUrlTitle(String urlTitle) {
        if (Validator.isNull((String)urlTitle)) {
            return null;
        }
        if (StringUtil.startsWith((String)urlTitle, (char)'/')) {
            return urlTitle;
        }
        return "/" + urlTitle;
    }

    private void _notify(Set<String> receivers, long userId, KBArticle kbArticle, String action, ServiceContext serviceContext) throws PortalException {
        if (receivers.isEmpty()) {
            return;
        }
        KBGroupServiceConfiguration kbGroupServiceConfiguration = this._getKBGroupServiceConfiguration(kbArticle.getGroupId());
        if (Objects.equals(action, "add") && !kbGroupServiceConfiguration.emailKBArticleAddedEnabled()) {
            return;
        }
        if (Objects.equals(action, "expire") && !kbGroupServiceConfiguration.emailKBArticleExpiredEnabled()) {
            return;
        }
        if (Objects.equals(action, "update") && !kbGroupServiceConfiguration.emailKBArticleUpdatedEnabled()) {
            return;
        }
        if (Objects.equals(action, _NOTIFICATION_ACTION_REVIEW) && !kbGroupServiceConfiguration.emailKBArticleReviewEnabled()) {
            return;
        }
        String fromAddress = kbGroupServiceConfiguration.emailFromAddress();
        String kbArticleContent = StringUtil.replace((String)kbArticle.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + serviceContext.getPortalURL() + "/", "src=\"" + serviceContext.getPortalURL() + "/"});
        Map<String, String> kbArticleDiffs = this._getEmailKBArticleDiffs(kbArticle);
        for (Map.Entry<String, String> entry : kbArticleDiffs.entrySet()) {
            String value = StringUtil.replace((String)entry.getValue(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + serviceContext.getPortalURL() + "/", "src=\"" + serviceContext.getPortalURL() + "/"});
            kbArticleDiffs.put(entry.getKey(), value);
        }
        SubscriptionSender subscriptionSender = AdminSubscriptionSenderFactory.createSubscriptionSender(kbArticle, serviceContext);
        subscriptionSender.setBody(this._getBody(action, kbGroupServiceConfiguration));
        subscriptionSender.setClassName(kbArticle.getModelClassName());
        subscriptionSender.setClassPK(kbArticle.getClassPK());
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", (Object)kbArticleContent, false);
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT_DIFF$]", (Object)kbArticleDiffs.get("content"), false);
        subscriptionSender.setContextAttribute("[$ARTICLE_TITLE_DIFF$]", (Object)kbArticleDiffs.get("title"), false);
        subscriptionSender.setContextCreatorUserPrefix("ARTICLE");
        subscriptionSender.setCreatorUserId(kbArticle.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(kbArticle.getTitle());
        subscriptionSender.setEntryURL(this._getKBArticleURL(kbArticle));
        subscriptionSender.setFrom(fromAddress, kbGroupServiceConfiguration.emailFromName());
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("kb_article", new Object[]{kbArticle.getKbArticleId()});
        subscriptionSender.setNotificationType(this._getNotificationType(action));
        subscriptionSender.setPortletId(serviceContext.getPortletId());
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(kbArticle.getGroupId());
        subscriptionSender.setSubject(this._getSubject(action, kbGroupServiceConfiguration));
        if (receivers.contains(_NOTIFICATION_RECEIVER_SUBSCRIBER)) {
            subscriptionSender.addAssetEntryPersistedSubscribers(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
            subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), kbArticle.getGroupId());
            subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
            for (KBArticle parentKBArticle = kbArticle.getParentKBArticle(); parentKBArticle != null; parentKBArticle = parentKBArticle.getParentKBArticle()) {
                subscriptionSender.addPersistedSubscribers(KBArticle.class.getName(), parentKBArticle.getResourcePrimKey());
            }
        }
        if (receivers.contains(_NOTIFICATION_RECEIVER_OWNER)) {
            User user = this._userLocalService.fetchUser(kbArticle.getUserId());
            if (user == null || !user.isActive()) {
                user = this._userLocalService.fetchUser(userId);
            }
            subscriptionSender.addRuntimeSubscribers(user.getEmailAddress(), user.getFullName());
        }
        subscriptionSender.flushNotificationsAsync();
    }

    private void _removeKBArticleAttachments(long[] removeFileEntryIds) throws PortalException {
        if (ArrayUtil.isEmpty((long[])removeFileEntryIds)) {
            return;
        }
        for (long removeFileEntryId : removeFileEntryIds) {
            this._portletFileRepository.deletePortletFileEntry(removeFileEntryId);
        }
    }

    private void _restoreDependentKBArticleFromTrash(KBArticle kbArticle) throws PortalException {
        if (!kbArticle.isInTrash()) {
            throw new TrashEntryException();
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)kbArticle)) {
            return;
        }
        TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(KBArticle.class.getName(), kbArticle.getResourcePrimKey());
        int oldStatus = 0;
        if (trashVersion != null) {
            oldStatus = trashVersion.getStatus();
        }
        kbArticle.setStatus(oldStatus);
        kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
        if (trashVersion != null) {
            this._trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
        if (oldStatus == 0) {
            this._assetEntryLocalService.updateVisible(KBArticle.class.getName(), kbArticle.getResourcePrimKey(), true);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KBArticle.class);
        indexer.reindex((Object)kbArticle);
    }

    private void _startWorkflowInstance(long userId, KBArticle kbArticle, ServiceContext serviceContext) throws PortalException {
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)kbArticle.getCompanyId(), (long)kbArticle.getGroupId(), (long)userId, (String)KBArticle.class.getName(), (long)kbArticle.getResourcePrimKey(), (Object)kbArticle, (ServiceContext)serviceContext, Collections.emptyMap());
    }

    private void _updatePermissionFields(long resourcePrimKey, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        KBArticle kbArticle = this.getLatestKBArticle(resourcePrimKey, -1);
        if (kbArticle.getParentResourcePrimKey() == parentResourcePrimKey) {
            return;
        }
        long rootResourcePrimKey = this._getRootResourcePrimKey(resourcePrimKey, parentResourceClassNameId, parentResourcePrimKey);
        if (kbArticle.getRootResourcePrimKey() == rootResourcePrimKey) {
            return;
        }
        List<KBArticle> kbArticles1 = this.getKBArticleAndAllDescendantKBArticles(resourcePrimKey, -1, null);
        for (KBArticle curKBArticle1 : kbArticles1) {
            List<KBArticle> kbArticles2 = this.getKBArticleVersions(curKBArticle1.getResourcePrimKey(), -1, -1, -1, null);
            for (KBArticle curKBArticle2 : kbArticles2) {
                curKBArticle2.setRootResourcePrimKey(rootResourcePrimKey);
                this.kbArticlePersistence.update((BaseModel)curKBArticle2);
            }
        }
        this._indexWriterHelper.updatePermissionFields(KBArticle.class.getName(), String.valueOf(resourcePrimKey));
    }

    private KBArticle _updateStatus(long userId, KBArticle kbArticle, int status) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        kbArticle.setStatus(status);
        kbArticle.setStatusByUserId(user.getUserId());
        kbArticle.setStatusByUserName(user.getFullName());
        kbArticle.setStatusDate(new Date());
        kbArticle = (KBArticle)this.kbArticlePersistence.update((BaseModel)kbArticle);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KBArticle.class);
        indexer.reindex((Object)kbArticle);
        return kbArticle;
    }

    private void _validate(String title, String content, String sourceURL, Date displayDate, Date expirationDate, Date reviewDate) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new KBArticleTitleException("Title is null");
        }
        if (Validator.isNull((String)content)) {
            throw new KBArticleContentException("Content is null");
        }
        this._validateSourceURL(sourceURL);
        if (displayDate == null) {
            throw new KBArticleDisplayDateException("Display date is null");
        }
        Date now = new Date();
        if (expirationDate != null) {
            if (expirationDate.before(now)) {
                throw new KBArticleExpirationDateException("Expiration date " + String.valueOf(expirationDate) + " is in the past");
            }
            if (expirationDate.before(displayDate)) {
                throw new KBArticleExpirationDateException(StringBundler.concat((Object[])new Object[]{"Expiration date ", expirationDate, " is prior to display date ", displayDate}));
            }
        }
        if (reviewDate != null && reviewDate.before(now)) {
            throw new KBArticleReviewDateException("Review date is " + String.valueOf(reviewDate) + " in the past");
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        KBArticle kbArticle = this.fetchLatestKBArticleByExternalReferenceCode(groupId, externalReferenceCode);
        if (kbArticle != null) {
            throw new DuplicateKBArticleExternalReferenceCodeException(StringBundler.concat((Object[])new Object[]{"Duplicate knowledge base article external reference code ", externalReferenceCode, " in group ", groupId}));
        }
    }

    private void _validateParent(KBArticle kbArticle, long parentResourceClassNameId, long parentResourcePrimKey) throws PortalException {
        KBArticle parentKBArticle;
        List ancestorResourcePrimaryKeys;
        this._validateParent(parentResourceClassNameId, parentResourcePrimKey);
        long kbArticleClassNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        if (parentResourceClassNameId == kbArticleClassNameId && (ancestorResourcePrimaryKeys = (parentKBArticle = this.getLatestKBArticle(parentResourcePrimKey, -1)).getAncestorResourcePrimaryKeys()).contains(kbArticle.getResourcePrimKey())) {
            throw new KBArticleParentException(String.format("Cannot move KBArticle %s inside its descendant KBArticle %s", kbArticle.getResourcePrimKey(), parentKBArticle.getResourcePrimKey()));
        }
    }

    private void _validateParent(long resourceClassNameId, long resourcePrimKey) throws PortalException {
        long kbArticleClassNameId = this._classNameLocalService.getClassNameId(KBArticleConstants.getClassName());
        long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        if (resourceClassNameId != kbArticleClassNameId && resourceClassNameId != kbFolderClassNameId) {
            throw new KBArticleParentException(String.format("Invalid parent with resource class name ID %s and resource primary key %s", resourceClassNameId, resourcePrimKey));
        }
    }

    private void _validateParentStatus(long parentResourceClassNameId, long parentResourcePrimKey, int status) throws PortalException {
        long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolder.class);
        if (parentResourceClassNameId == kbFolderClassNameId) {
            return;
        }
        KBArticle kbArticle = this.fetchLatestKBArticle(parentResourcePrimKey, 0);
        if (kbArticle == null && status == 0) {
            throw new KBArticleStatusException();
        }
    }

    private void _validatePriority(double priority) throws PortalException {
        if (priority <= 0.0) {
            throw new KBArticlePriorityException("Invalid priority " + priority);
        }
    }

    private void _validateSourceURL(String sourceURL) throws PortalException {
        if (Validator.isNull((String)sourceURL)) {
            return;
        }
        if (!Validator.isUrl((String)sourceURL)) {
            throw new KBArticleSourceURLException(sourceURL);
        }
    }

    private void _validateUrlTitle(long groupId, long kbFolderId, String urlTitle) throws PortalException {
        if (Validator.isNull((String)urlTitle)) {
            return;
        }
        if (!KnowledgeBaseUtil.isValidUrlTitle((String)urlTitle)) {
            throw new KBArticleUrlTitleException.MustNotContainInvalidCharacters(urlTitle);
        }
        int urlTitleMaxSize = ModelHintsUtil.getMaxLength((String)KBArticle.class.getName(), (String)"urlTitle");
        if (urlTitle.length() > urlTitleMaxSize + 1) {
            throw new KBArticleUrlTitleException.MustNotExceedMaximumSize(urlTitle, urlTitleMaxSize);
        }
        List kbArticles = this.kbArticlePersistence.findByG_KBFI_UT_NotS(groupId, kbFolderId, urlTitle.substring(1), 8);
        if (!kbArticles.isEmpty()) {
            throw new KBArticleUrlTitleException.MustNotBeDuplicate(urlTitle);
        }
    }
}

