/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v2_0_2;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KBArticleUpgradeProcess
extends UpgradeProcess {
    private static final String _DEFAULT_SUFFIX = "-1";
    private static final int _MAX_URL_TITLE_LENGTH = 74;
    private static final Pattern _pattern = Pattern.compile("-\\d+$");

    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        try (SafeCloseable safeCloseable = db.addTemporaryIndex(this.connection, "KBArticle", false, new String[]{"groupId", "kbFolderId", "urlTitle"});){
            boolean changed = true;
            while (changed) {
                changed = this._renameConflictingKBArticleFriendlyURLs();
            }
            changed = true;
            while (changed) {
                changed = this._renameConflictingKBFolderFriendlyURLs();
            }
        }
    }

    private String _getUniqueUrlTitle(String urlTitle, int n) {
        Object suffix = _DEFAULT_SUFFIX;
        int i = urlTitle.lastIndexOf(45);
        if (i != -1) {
            Matcher matcher = _pattern.matcher(urlTitle);
            matcher.region(i, urlTitle.length());
            if (matcher.matches()) {
                int counter = GetterUtil.getInteger((String)urlTitle.substring(i + 1));
                int spreadValue = 16 + n;
                suffix = "-" + String.valueOf(counter + spreadValue);
                urlTitle = urlTitle.substring(0, i);
            }
        }
        if (urlTitle.length() + ((String)suffix).length() > 74) {
            urlTitle = urlTitle.substring(0, 74 - ((String)suffix).length());
        }
        return urlTitle + (String)suffix;
    }

    /*
     * Exception decompiling
     */
    private boolean _renameConflictingFriendlyURL(String selectSQL, String updateSQL) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean _renameConflictingKBArticleFriendlyURLs() throws SQLException {
        return this._renameConflictingFriendlyURL(StringBundler.concat((String[])new String[]{"select distinct kbArticle2.kbArticleId, kbArticle2.urlTitle ", "from KBArticle kbArticle1 inner join KBArticle kbArticle2 on ", "kbArticle1.groupId = kbArticle2.groupId and ", "kbArticle1.kbFolderId = kbArticle2.kbFolderId and ", "kbArticle1.urlTitle = kbArticle2.urlTitle where ", "kbArticle1.kbArticleId < kbArticle2.kbArticleId"}), "update KBArticle set urlTitle = ? where kbArticleId = ?");
    }

    private boolean _renameConflictingKBFolderFriendlyURLs() throws SQLException {
        return this._renameConflictingFriendlyURL(StringBundler.concat((String[])new String[]{"select distinct kbArticle2.kbFolderId, kbArticle2.urlTitle ", "from KBFolder kbArticle1 inner join KBFolder kbArticle2 on ", "kbArticle1.groupId = kbArticle2.groupId and ", "kbArticle1.parentKBFolderId = kbArticle2.parentKBFolderId ", "and kbArticle1.urlTitle = kbArticle2.urlTitle where ", "kbArticle1.kbFolderId < kbArticle2.kbFolderId"}), "update KBFolder set urlTitle = ? where kbFolderId = ?");
    }
}

