/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.trash;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.trash.BaseTrashHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKBTrashHandler
extends BaseTrashHandler {
    @Reference
    protected KBArticleLocalService kbArticleLocalService;
    @Reference
    protected KBFolderLocalService kbFolderLocalService;

    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        if (containerModelId == 0L) {
            return null;
        }
        return this.kbFolderLocalService.getKBFolder(containerModelId);
    }

    public String getContainerModelClassName(long classPK) {
        return KBFolder.class.getName();
    }

    public String getContainerModelName() {
        return "folder";
    }

    public List<ContainerModel> getContainerModels(long classPK, long containerModelId, int start, int end) throws PortalException {
        List kbFolders = this.kbFolderLocalService.getKBFolders(this.getGroupId(classPK), containerModelId, start, end);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>(kbFolders.size());
        containerModels.addAll(kbFolders);
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long containerModelId) throws PortalException {
        return this.kbFolderLocalService.getKBFoldersCount(this.getGroupId(classPK), containerModelId);
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getParentContainerModel(classPK);
        if (containerModel == null) {
            return containerModels;
        }
        containerModels.add(containerModel);
        while (containerModel.getParentContainerModelId() > 0L && (containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) != null) {
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRootContainerModelName() {
        return "home";
    }

    public String getSubcontainerModelName() {
        return "folder";
    }

    public String getTrashContainedModelName() {
        return "kb-articles";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return this.kbArticleLocalService.getKBArticlesCount(kbFolder.getGroupId(), classPK, 8);
    }

    public String getTrashContainerModelName() {
        return "folders";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return this.kbFolderLocalService.getKBFoldersCount(kbFolder.getGroupId(), classPK, 8);
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return this.kbFolderLocalService.getKBFoldersAndKBArticlesCount(kbFolder.getGroupId(), classPK, 8);
    }

    public List<TrashedModel> getTrashModelTrashedModels(long classPK, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(classPK);
        return TransformUtil.transform((Collection)this.kbFolderLocalService.getKBFoldersAndKBArticles(kbFolder.getGroupId(), classPK, 8, start, end, orderByComparator), object -> {
            if (object instanceof KBFolder) {
                return (KBFolder)object;
            }
            return (KBArticle)object;
        });
    }

    protected abstract long getGroupId(long var1) throws PortalException;
}

