/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.security.permission.resource;

import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.model.KBFolderModel;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.BaseModelResourcePermissionWrapper;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.PropsValues;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.knowledge.base.model.KBFolder"}, service={ModelResourcePermission.class})
public class KBFolderModelResourcePermissionWrapper
extends BaseModelResourcePermissionWrapper<KBFolder> {
    @Reference
    private KBFolderLocalService _kbFolderLocalService;
    @Reference(target="(resource.name=com.liferay.knowledge.base.admin)")
    private PortletResourcePermission _portletResourcePermission;

    protected ModelResourcePermission<KBFolder> doGetModelResourcePermission() {
        return ModelResourcePermissionFactory.create(KBFolder.class, KBFolderModel::getKbFolderId, arg_0 -> ((KBFolderLocalService)this._kbFolderLocalService).getKBFolder(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new KBFolderDynamicInheritanceModelResourcePermissionLogic((ModelResourcePermission<KBFolder>)modelResourcePermission));
            }
        });
    }

    private class KBFolderDynamicInheritanceModelResourcePermissionLogic
    implements ModelResourcePermissionLogic<KBFolder> {
        private final ModelResourcePermission<KBFolder> _kbFolderModelResourcePermission;

        public Boolean contains(PermissionChecker permissionChecker, String name, KBFolder kbFolder, String actionId) throws PortalException {
            if (!"VIEW".equals(actionId)) {
                return null;
            }
            long parentKBFolderId = kbFolder.getParentKBFolderId();
            if (parentKBFolderId == 0L) {
                return null;
            }
            kbFolder = KBFolderModelResourcePermissionWrapper.this._kbFolderLocalService.fetchKBFolder(parentKBFolderId);
            if (kbFolder != null && !this._kbFolderModelResourcePermission.contains(permissionChecker, (ClassedModel)kbFolder, actionId)) {
                return false;
            }
            return null;
        }

        private KBFolderDynamicInheritanceModelResourcePermissionLogic(ModelResourcePermission<KBFolder> kbFolderModelResourcePermission) {
            this._kbFolderModelResourcePermission = kbFolderModelResourcePermission;
        }
    }
}

