/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class RatingsEntryUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_ARTICLE = "com.liferay.knowledgebase.model.Article";

    protected void doUpgrade() throws Exception {
        this._updateRatingsEntries();
    }

    protected long getClassNameId(String className) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select classNameId from ClassName_ where value = ?");){
            long l;
            block16: {
                ResultSet resultSet;
                block14: {
                    long l2;
                    block15: {
                        preparedStatement.setString(1, className);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            l2 = resultSet.getLong("classNameId");
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                l = 0L;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return l;
        }
    }

    private void _updateRatingsEntries() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select entryId, score from RatingsEntry where classNameId = ?");){
            preparedStatement.setLong(1, this.getClassNameId(_CLASS_NAME_ARTICLE));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long entryId = resultSet.getLong("entryId");
                    double score = resultSet.getDouble("score");
                    this.runSQL(StringBundler.concat((Object[])new Object[]{"update RatingsEntry set score = ", score * 2.0, " where entryId = ", entryId}));
                }
            }
        }
    }
}

