/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.service.base.KBCommentServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=kb", "json.web.service.context.path=KBComment"}, service={AopService.class})
public class KBCommentServiceImpl
extends KBCommentServiceBaseImpl {
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBComment)")
    private ModelResourcePermission<KBComment> _kbCommentModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.knowledge.base.admin)")
    private PortletResourcePermission _portletResourcePermission;

    public KBComment deleteKBComment(KBComment kbComment) throws PortalException {
        this._kbCommentModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)kbComment, "DELETE");
        return this.kbCommentLocalService.deleteKBComment(kbComment);
    }

    public KBComment deleteKBComment(long kbCommentId) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.deleteKBComment(kbComment);
    }

    public KBComment getKBComment(long kbCommentId) throws PortalException {
        this._kbCommentModelResourcePermission.check(this.getPermissionChecker(), kbCommentId, "VIEW");
        return this.kbCommentLocalService.getKBComment(kbCommentId);
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end) throws PortalException {
        if (this._portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, status, start, end);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end, OrderByComparator<KBComment> orderByComparator) throws PortalException {
        if (this._portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, status, start, end, orderByComparator);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, int start, int end, OrderByComparator<KBComment> orderByComparator) throws PortalException {
        if (this._portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, start, end, orderByComparator);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int status, int start, int end) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBComments(className, classPK, status, start, end);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int status, int start, int end, OrderByComparator<KBComment> orderByComparator) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBComments(className, classPK, status, start, end, orderByComparator);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int start, int end, OrderByComparator<KBComment> orderByComparator) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBComments(className, classPK, start, end, orderByComparator);
        }
        return Collections.emptyList();
    }

    public int getKBCommentsCount(long groupId) throws PortalException {
        if (this._portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentPersistence.countByGroupId(groupId);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, int status) throws PortalException {
        if (this._portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBCommentsCount(groupId, status);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, String className, long classPK) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBCommentsCount(className, classPK);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, String className, long classPK, int status) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBCommentsCount(className, classPK, status);
        }
        return 0;
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, int status, ServiceContext serviceContext) throws PortalException {
        this._kbCommentModelResourcePermission.check(this.getPermissionChecker(), kbCommentId, "UPDATE");
        return this.kbCommentLocalService.updateKBComment(kbCommentId, classNameId, classPK, content, status, serviceContext);
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, ServiceContext serviceContext) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.updateKBComment(kbCommentId, classNameId, classPK, content, kbComment.getStatus(), serviceContext);
    }

    public KBComment updateStatus(long kbCommentId, int status, ServiceContext serviceContext) throws PortalException {
        this._kbCommentModelResourcePermission.check(this.getPermissionChecker(), kbCommentId, "UPDATE");
        return this.kbCommentLocalService.updateStatus(this.getUserId(), kbCommentId, status, serviceContext);
    }

    private boolean _containsViewSuggestionPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK) throws PortalException {
        if (!className.equals(KBArticleConstants.getClassName())) {
            throw new IllegalArgumentException("Only KB articles support suggestions");
        }
        KBArticle kbArticle = this._kbArticleLocalService.fetchKBArticle(classPK);
        kbArticle = kbArticle != null ? this._kbArticleLocalService.getLatestKBArticle(kbArticle.getResourcePrimKey(), -1) : this._kbArticleLocalService.getLatestKBArticle(classPK, -1);
        return this._portletResourcePermission.contains(permissionChecker, groupId, "VIEW_SUGGESTIONS") || this._kbArticleModelResourcePermission.contains(permissionChecker, (ClassedModel)kbArticle, "UPDATE");
    }
}

