/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.model.impl;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.NoSuchFolderException;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.model.KBFolderModel;
import com.liferay.knowledge.base.model.impl.KBFolderBaseImpl;
import com.liferay.knowledge.base.service.KBArticleServiceUtil;
import com.liferay.knowledge.base.service.KBFolderLocalServiceUtil;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public class KBFolderImpl
extends KBFolderBaseImpl {
    public List<Long> getAncestorKBFolderIds() throws PortalException {
        return this._getAncestors(KBFolderModel::getKbFolderId);
    }

    public List<KBFolder> getAncestorKBFolders() throws PortalException {
        return this._getAncestors(Function.identity());
    }

    public long getClassNameId() {
        return PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
    }

    public KBFolder getParentKBFolder() throws PortalException {
        long parentKBFolderId = this.getParentKBFolderId();
        if (parentKBFolderId <= 0L) {
            return null;
        }
        return KBFolderLocalServiceUtil.getKBFolder((long)parentKBFolderId);
    }

    public String getParentTitle(Locale locale) throws PortalException {
        KBFolder parentKBFolder = this.getParentKBFolder();
        if (parentKBFolder == null) {
            return LanguageUtil.get((Locale)locale, (String)"home");
        }
        return parentKBFolder.getName();
    }

    public boolean isEmpty() throws PortalException {
        int kbArticlesCount = KBArticleServiceUtil.getKBArticlesCount((long)this.getGroupId(), (long)this.getKbFolderId(), (int)0);
        if (kbArticlesCount > 0) {
            return false;
        }
        int kbFoldersCount = KBFolderServiceUtil.getKBFoldersCount((long)this.getGroupId(), (long)this.getKbFolderId());
        return kbFoldersCount <= 0;
    }

    public boolean isRoot() {
        return this.getParentKBFolderId() == 0L;
    }

    private <T> List<T> _getAncestors(Function<KBFolder, T> function) throws PortalException {
        ArrayList<T> ancestors = new ArrayList<T>();
        KBFolderImpl kbFolder = this;
        while (!kbFolder.isRoot()) {
            try {
                kbFolder = kbFolder.getParentKBFolder();
                ancestors.add(function.apply(kbFolder));
            }
            catch (NoSuchFolderException noSuchFolderException) {
                if (kbFolder.isInTrash()) break;
                throw noSuchFolderException;
            }
        }
        return ancestors;
    }
}

