/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.upgrade.v1_3_3;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class UpgradeKBFolder
extends UpgradeProcess {
    private static final Pattern _normalizationFriendlyUrlPattern = Pattern.compile("[^a-z0-9_-]");

    protected void doUpgrade() throws Exception {
        Map<Long, String> urlTitles = this._getInitialUrlTitles(this.connection);
        for (Map.Entry<Long, String> entry : urlTitles.entrySet()) {
            String uniqueUrlTitle = this._findUniqueUrlTitle(this.connection, entry.getValue());
            int i = 1;
            while (uniqueUrlTitle == null) {
                uniqueUrlTitle = this._findUniqueUrlTitle(this.connection, entry.getValue() + "-" + i);
                ++i;
            }
            this._updateKBFolder(this.connection, entry.getKey(), uniqueUrlTitle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _findUniqueUrlTitle(Connection con, String urlTitle) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            block4: {
                String string;
                ps = null;
                rs = null;
                try {
                    ps = con.prepareStatement("select count(*) from KBFolder where KBFolder.urlTitle like ?");
                    ps.setString(1, urlTitle + "%");
                    rs = ps.executeQuery();
                    if (rs.next()) break block4;
                    string = urlTitle;
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp((Statement)ps);
                    DataAccess.cleanUp(rs);
                    throw throwable;
                }
                DataAccess.cleanUp((Statement)ps);
                DataAccess.cleanUp((ResultSet)rs);
                return string;
            }
            int kbFolderCount = rs.getInt(1);
            if (kbFolderCount != 0) break block5;
            String string = urlTitle;
            DataAccess.cleanUp((Statement)ps);
            DataAccess.cleanUp((ResultSet)rs);
            return string;
        }
        String string = null;
        DataAccess.cleanUp((Statement)ps);
        DataAccess.cleanUp((ResultSet)rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> _getInitialUrlTitles(Connection con) throws SQLException {
        HashMap<Long, String> hashMap;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("select kbFolderId, name from KBFolder where (KBFolder.urlTitle is null) or (KBFolder.urlTitle = '')");
            rs = ps.executeQuery();
            HashMap<Long, String> urlTitles = new HashMap<Long, String>();
            while (rs.next()) {
                long kbFolderId = rs.getLong(1);
                String name = rs.getString(2);
                String urlTitle = this._getUrlTitle(kbFolderId, name);
                urlTitles.put(kbFolderId, urlTitle);
            }
            hashMap = urlTitles;
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Statement)ps);
            DataAccess.cleanUp(rs);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps);
        DataAccess.cleanUp((ResultSet)rs);
        return hashMap;
    }

    private String _getUrlTitle(long id, String title) {
        if (title == null) {
            return String.valueOf(id);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalize((String)title, (Pattern)_normalizationFriendlyUrlPattern);
        return title.substring(0, 75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateKBFolder(Connection con, long kbFolderId, String urlTitle) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("update KBFolder set KBFolder.urlTitle = ? where KBFolder.kbFolderId = ?");
            ps.setString(1, urlTitle);
            ps.setLong(2, kbFolderId);
            ps.execute();
        }
        finally {
            DataAccess.cleanUp((Statement)ps);
        }
    }
}

