/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.knowledge.base.exception.KBTemplateContentException;
import com.liferay.knowledge.base.exception.KBTemplateTitleException;
import com.liferay.knowledge.base.exception.NoSuchTemplateException;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.service.base.KBTemplateLocalServiceBaseImpl;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KBTemplateLocalServiceImpl
extends KBTemplateLocalServiceBaseImpl {
    public KBTemplate addKBTemplate(long userId, String title, String content, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        this.validate(title, content);
        long kbTemplateId = this.counterLocalService.increment();
        KBTemplate kbTemplate = this.kbTemplatePersistence.create(kbTemplateId);
        kbTemplate.setUuid(serviceContext.getUuid());
        kbTemplate.setGroupId(groupId);
        kbTemplate.setCompanyId(user.getCompanyId());
        kbTemplate.setUserId(user.getUserId());
        kbTemplate.setUserName(user.getFullName());
        kbTemplate.setCreateDate(serviceContext.getCreateDate(now));
        kbTemplate.setModifiedDate(serviceContext.getModifiedDate(now));
        kbTemplate.setTitle(title);
        kbTemplate.setContent(content);
        kbTemplate = (KBTemplate)this.kbTemplatePersistence.update((BaseModel)kbTemplate);
        this.resourceLocalService.addModelResources((AuditedModel)kbTemplate, serviceContext);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", kbTemplate.getTitle());
        this.socialActivityLocalService.addActivity(userId, groupId, KBTemplate.class.getName(), kbTemplateId, 2, extraDataJSONObject.toString(), 0L);
        return kbTemplate;
    }

    public void deleteGroupKBTemplates(long groupId) throws PortalException {
        List kbTemplates = this.kbTemplatePersistence.findByGroupId(groupId);
        for (KBTemplate kbTemplate : kbTemplates) {
            this.kbTemplateLocalService.deleteKBTemplate(kbTemplate);
        }
    }

    @Override
    @SystemEvent(action=1, type=1)
    public KBTemplate deleteKBTemplate(KBTemplate kbTemplate) throws PortalException {
        this.kbTemplatePersistence.remove((BaseModel)kbTemplate);
        this.resourceLocalService.deleteResource(kbTemplate.getCompanyId(), KBTemplate.class.getName(), 4, kbTemplate.getKbTemplateId());
        this.kbCommentLocalService.deleteKBComments(KBTemplate.class.getName(), kbTemplate.getKbTemplateId());
        this.socialActivityLocalService.deleteActivities(KBTemplate.class.getName(), kbTemplate.getKbTemplateId());
        return kbTemplate;
    }

    @Override
    public KBTemplate deleteKBTemplate(long kbTemplateId) throws PortalException {
        KBTemplate kbTemplate = this.kbTemplatePersistence.findByPrimaryKey(kbTemplateId);
        return this.kbTemplateLocalService.deleteKBTemplate(kbTemplate);
    }

    public void deleteKBTemplates(long[] kbTemplateIds) throws PortalException {
        for (long kbTemplateId : kbTemplateIds) {
            KBTemplate kbTemplate = null;
            try {
                kbTemplate = this.kbTemplatePersistence.findByPrimaryKey(kbTemplateId);
            }
            catch (NoSuchTemplateException nste) {
                continue;
            }
            this.kbTemplateLocalService.deleteKBTemplate(kbTemplate);
        }
    }

    public List<KBTemplate> getGroupKBTemplates(long groupId, int start, int end, OrderByComparator<KBTemplate> orderByComparator) {
        return this.kbTemplatePersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public int getGroupKBTemplatesCount(long groupId) {
        return this.kbTemplatePersistence.countByGroupId(groupId);
    }

    public List<KBTemplate> search(long groupId, String title, String content, Date startDate, Date endDate, boolean andOperator, int start, int end, OrderByComparator<KBTemplate> orderByComparator) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(groupId, title, content, startDate, endDate, andOperator);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public KBTemplate updateKBTemplate(long kbTemplateId, String title, String content, ServiceContext serviceContext) throws PortalException {
        this.validate(title, content);
        KBTemplate kbTemplate = this.kbTemplatePersistence.findByPrimaryKey(kbTemplateId);
        kbTemplate.setModifiedDate(serviceContext.getModifiedDate(null));
        kbTemplate.setTitle(title);
        kbTemplate.setContent(content);
        kbTemplate = (KBTemplate)this.kbTemplatePersistence.update((BaseModel)kbTemplate);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", kbTemplate.getTitle());
        this.socialActivityLocalService.addActivity(kbTemplate.getUserId(), kbTemplate.getGroupId(), KBTemplate.class.getName(), kbTemplateId, 4, extraDataJSONObject.toString(), 0L);
        return kbTemplate;
    }

    public void updateKBTemplateResources(KBTemplate kbTemplate, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.updateResources(kbTemplate.getCompanyId(), kbTemplate.getGroupId(), KBTemplate.class.getName(), kbTemplate.getKbTemplateId(), groupPermissions, guestPermissions);
    }

    protected DynamicQuery buildDynamicQuery(long groupId, String title, String content, Date startDate, Date endDate, boolean andOperator) {
        Object junction = null;
        junction = andOperator ? RestrictionsFactoryUtil.conjunction() : RestrictionsFactoryUtil.disjunction();
        HashMap<String, String> terms = new HashMap<String, String>();
        if (Validator.isNotNull((String)title)) {
            terms.put("title", title);
        }
        if (Validator.isNotNull((String)content)) {
            terms.put("content", content);
        }
        for (Map.Entry entry : terms.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            for (String keyword : KnowledgeBaseUtil.splitKeywords((String)value)) {
                Criterion criterion = RestrictionsFactoryUtil.ilike((String)key, (Object)StringUtil.quote((String)keyword, (String)"%"));
                disjunction.add(criterion);
            }
            junction.add((Criterion)disjunction);
        }
        if (endDate != null && startDate != null) {
            String[] propertyNames;
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            for (String propertyName : propertyNames = new String[]{"createDate", "modifiedDate"}) {
                Property property = PropertyFactoryUtil.forName((String)propertyName);
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(property.gt((Object)startDate));
                conjunction.add(property.lt((Object)endDate));
                disjunction.add((Criterion)conjunction);
            }
            junction.add((Criterion)disjunction);
        }
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KBTemplate.class, (ClassLoader)this.getClassLoader());
        if (groupId > 0L) {
            Property property = PropertyFactoryUtil.forName((String)"groupId");
            dynamicQuery.add(property.eq((Object)groupId));
        }
        return dynamicQuery.add((Criterion)junction);
    }

    protected void validate(String title, String content) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new KBTemplateTitleException();
        }
        if (Validator.isNull((String)content)) {
            throw new KBTemplateContentException();
        }
    }
}

