/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.json.storage.internal.upgrade;

import com.liferay.json.storage.service.JSONStorageEntryLocalService;
import com.liferay.json.storage.upgrade.JSONStorageUpgradeStepFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={JSONStorageUpgradeStepFactory.class})
public class JSONStorageUpgradeStepFactoryImpl
implements JSONStorageUpgradeStepFactory {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private JSONStorageEntryLocalService _jsonStorageEntryLocalService;

    public UpgradeStep createUpgradeStep(Class<?> modelClass, String tableName, String primaryKeyName, String jsonColumnName) {
        return new JSONStorageUpgradeProcess(modelClass, tableName, primaryKeyName, jsonColumnName);
    }

    private class JSONStorageUpgradeProcess
    extends UpgradeProcess {
        private final String _jsonColumnName;
        private final Class<?> _modelClass;
        private final String _primaryKeyName;
        private final String _tableName;

        protected void doUpgrade() throws Exception {
            if (!this.hasColumn(this._tableName, this._jsonColumnName)) {
                return;
            }
            long classNameId = JSONStorageUpgradeStepFactoryImpl.this._classNameLocalService.getClassNameId(this._modelClass);
            StringBundler sb = new StringBundler(7);
            sb.append("select companyId, ");
            sb.append(this._primaryKeyName);
            sb.append(", ");
            sb.append(this._jsonColumnName);
            sb.append(" from ");
            sb.append(this._tableName);
            if (this.hasColumn(this._tableName, "ctCollectionId")) {
                sb.append(" where ctCollectionId = 0");
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String json = resultSet.getString(this._jsonColumnName);
                    if (!Validator.isNotNull((String)json)) continue;
                    JSONStorageUpgradeStepFactoryImpl.this._jsonStorageEntryLocalService.addJSONStorageEntries(resultSet.getLong("companyId"), classNameId, resultSet.getLong(this._primaryKeyName), json);
                }
            }
            this.alterTableDropColumn(this._tableName, this._jsonColumnName);
        }

        private JSONStorageUpgradeProcess(Class<?> modelClass, String tableName, String primaryKeyName, String jsonColumnName) {
            this._modelClass = modelClass;
            this._tableName = tableName;
            this._primaryKeyName = primaryKeyName;
            this._jsonColumnName = jsonColumnName;
        }
    }
}

